/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.RuntimeMetricsUtil;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

public final class Classes {
    static final Classes INSTANCE = new Classes();

    public static void registerObservers(OpenTelemetry openTelemetry) {
        INSTANCE.registerObservers(openTelemetry, ManagementFactory.getClassLoadingMXBean());
    }

    void registerObservers(OpenTelemetry openTelemetry, ClassLoadingMXBean classBean) {
        Meter meter = RuntimeMetricsUtil.getMeter(openTelemetry);
        meter.counterBuilder("process.runtime.jvm.classes.loaded").setDescription("Number of classes loaded since JVM start").setUnit("1").buildWithCallback(observableMeasurement -> observableMeasurement.record(classBean.getTotalLoadedClassCount()));
        meter.counterBuilder("process.runtime.jvm.classes.unloaded").setDescription("Number of classes unloaded since JVM start").setUnit("1").buildWithCallback(observableMeasurement -> observableMeasurement.record(classBean.getUnloadedClassCount()));
        meter.upDownCounterBuilder("process.runtime.jvm.classes.current_loaded").setDescription("Number of classes currently loaded").setUnit("1").buildWithCallback(observableMeasurement -> observableMeasurement.record((long)classBean.getLoadedClassCount()));
    }

    private Classes() {
    }
}

