/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.otel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.otel.ScopeContext;

class OtelOpStatsLogger
implements OpStatsLogger {
    private final DoubleHistogram histo;
    private final Attributes successAttributes;
    private final Attributes failureAttributes;

    OtelOpStatsLogger(Meter meter, ScopeContext sc) {
        this.histo = meter.histogramBuilder(sc.getName()).build();
        this.successAttributes = Attributes.builder().putAll(sc.getAttributes()).put("success", "true").build();
        this.failureAttributes = Attributes.builder().putAll(sc.getAttributes()).put("success", "false").build();
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.histo.record(valueMillis, this.failureAttributes);
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        double valueMillis = (double)unit.toMicros(eventLatency) / 1000.0;
        this.histo.record(valueMillis, this.successAttributes);
    }

    public void registerSuccessfulValue(long value) {
        this.histo.record((double)value, this.successAttributes);
    }

    public void registerFailedValue(long value) {
        this.histo.record((double)value, this.failureAttributes);
    }

    public OpStatsData toOpStatsData() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }
}

