/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.table;

import com.google.common.util.concurrent.RateLimiter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.tools.perf.table.BenchmarkTask;
import org.apache.bookkeeper.tools.perf.table.KeyGenerator;
import org.apache.bookkeeper.tools.perf.table.PerfClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WriteTask
extends BenchmarkTask {
    private static final Logger log = LoggerFactory.getLogger(WriteTask.class);
    protected final RateLimiter limiter;
    protected final Semaphore semaphore;
    protected final byte[] valueBytes;
    protected final PerfClient.OpStats writeOpStats;

    WriteTask(Table<ByteBuf, ByteBuf> table, int tid, long randSeed, long numRecords, long keyRange, PerfClient.Flags flags, KeyGenerator generator, RateLimiter limiter, Semaphore semaphore) {
        super(table, tid, randSeed, numRecords, keyRange, flags, generator);
        this.limiter = limiter;
        this.semaphore = semaphore;
        this.valueBytes = new byte[flags.valueSize];
        ThreadLocalRandom.current().nextBytes(this.valueBytes);
        this.writeOpStats = new PerfClient.OpStats(PerfClient.OP.PUT.name());
    }

    @Override
    protected void runTask() throws Exception {
        for (long i = 0L; i < this.numRecords; ++i) {
            if (null != this.semaphore) {
                this.semaphore.acquire();
            }
            if (null != this.limiter) {
                this.limiter.acquire();
            }
            this.writeKey(i, this.valueBytes);
        }
    }

    protected abstract void getKey(ByteBuf var1, long var2, long var4);

    void writeKey(long i, byte[] valueBytes) {
        ByteBuf keyBuf = PooledByteBufAllocator.DEFAULT.heapBuffer(this.flags.keySize);
        this.getKey(keyBuf, i, this.keyRange);
        keyBuf.writerIndex(keyBuf.readerIndex() + keyBuf.writableBytes());
        ByteBuf valBuf = Unpooled.wrappedBuffer((byte[])valueBytes);
        long startTime = System.nanoTime();
        this.table.put((Object)keyBuf, (Object)valBuf).whenComplete((result, cause) -> {
            if (null != this.semaphore) {
                this.semaphore.release();
            }
            if (null != cause) {
                log.error("Error at put key/value", cause);
            } else {
                long latencyMicros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - startTime);
                this.writeOpStats.recordOp(latencyMicros);
            }
            ReferenceCountUtil.release((Object)keyBuf);
            ReferenceCountUtil.release((Object)valBuf);
        });
    }

    @Override
    protected void reportStats(long oldTime) {
        this.writeOpStats.reportStats(oldTime);
    }

    @Override
    protected void printAggregatedStats() {
        this.writeOpStats.printAggregatedStats();
    }
}

