/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AsymmetricKeyInfoConverter;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AsymmetricAlgorithmProvider
extends AlgorithmProvider {
    AsymmetricAlgorithmProvider() {
    }

    protected void addKeyAgreementAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, String string2, Map<String, String> map, EngineCreator engineCreator) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyAgreement." + string, string2, engineCreator);
        bouncyCastleFipsProvider.addAttributes("KeyAgreement." + string, map);
    }

    protected void addSignatureAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, String string2, String string3, ASN1ObjectIdentifier aSN1ObjectIdentifier, Map<String, String> map, EngineCreator engineCreator) {
        String string4 = string + "WITH" + string2;
        String string5 = string + "/" + string2;
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string4, string3, engineCreator);
        bouncyCastleFipsProvider.addAlias("Signature", string4, string5);
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("Signature", string4, aSN1ObjectIdentifier);
        }
        bouncyCastleFipsProvider.addAttributes("Signature." + string4, map);
    }

    protected void addSignatureAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, String string2, String string3, ASN1ObjectIdentifier aSN1ObjectIdentifier, EngineCreator engineCreator) {
        String string4 = string + "WITH" + string2;
        String string5 = string + "/" + string2;
        bouncyCastleFipsProvider.addAlgorithmImplementation("Signature." + string4, string3, engineCreator);
        bouncyCastleFipsProvider.addAlias("Signature", string4, string5);
        if (aSN1ObjectIdentifier != null) {
            bouncyCastleFipsProvider.addAlias("Signature", string4, aSN1ObjectIdentifier);
        }
    }

    protected void registerOid(BouncyCastleFipsProvider bouncyCastleFipsProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        bouncyCastleFipsProvider.addAlias("KeyFactory", string, aSN1ObjectIdentifier);
        bouncyCastleFipsProvider.addAlias("KeyPairGenerator", string, aSN1ObjectIdentifier);
        bouncyCastleFipsProvider.addKeyInfoConverter(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
    }

    protected void registerOidAlgorithmParameters(BouncyCastleFipsProvider bouncyCastleFipsProvider, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        bouncyCastleFipsProvider.addAlias("AlgorithmParameterGenerator", string, aSN1ObjectIdentifier);
        bouncyCastleFipsProvider.addAlias("AlgorithmParameters", string, aSN1ObjectIdentifier);
    }
}

