/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Set;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.DigestCalculator;
import org.apache.zookeeper.server.NodeHashMapImpl;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NodeHashMapImplTest
extends ZKTestCase {
    @BeforeEach
    public void setUp() {
        ZooKeeperServer.setDigestEnabled((boolean)true);
    }

    @AfterEach
    public void tearDown() {
        ZooKeeperServer.setDigestEnabled((boolean)false);
    }

    @Test
    public void testOperations() {
        NodeHashMapImpl nodes = new NodeHashMapImpl(new DigestCalculator());
        Assertions.assertEquals((int)0, (int)nodes.size());
        Assertions.assertEquals((long)0L, (long)nodes.getDigest());
        String p1 = "p1";
        DataNode n1 = new DataNode(p1.getBytes(), Long.valueOf(0L), new StatPersisted());
        nodes.put(p1, n1);
        Assertions.assertEquals((Object)n1, (Object)nodes.get(p1));
        Assertions.assertNotEquals((long)0L, (long)nodes.getDigest());
        Assertions.assertEquals((int)1, (int)nodes.size());
        String p2 = "p2";
        nodes.put(p2, new DataNode(p2.getBytes(), Long.valueOf(0L), new StatPersisted()));
        Set entries = nodes.entrySet();
        Assertions.assertEquals((int)2, (int)entries.size());
        nodes.remove(p1);
        Assertions.assertEquals((int)1, (int)nodes.size());
        nodes.remove(p2);
        Assertions.assertEquals((int)0, (int)nodes.size());
        Assertions.assertEquals((long)0L, (long)nodes.getDigest());
        String p3 = "p3";
        DataNode n3 = new DataNode(p3.getBytes(), Long.valueOf(0L), new StatPersisted());
        nodes.put(p3, n3);
        long preChangeDigest = nodes.getDigest();
        Assertions.assertNotEquals((long)0L, (long)preChangeDigest);
        nodes.preChange(p3, n3);
        Assertions.assertEquals((long)0L, (long)nodes.getDigest());
        n3.stat.setMzxid(1L);
        n3.stat.setMtime(1L);
        n3.stat.setVersion(1);
        nodes.postChange(p3, n3);
        long postChangeDigest = nodes.getDigest();
        Assertions.assertNotEquals((long)0L, (long)postChangeDigest);
        Assertions.assertNotEquals((long)preChangeDigest, (long)postChangeDigest);
    }
}

