/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumPeerTestBase
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(QuorumPeerTestBase.class);
    public static final int TIMEOUT = 5000;
    protected Servers servers;
    protected int numServers = 0;

    @AfterEach
    public void tearDown() throws Exception {
        if (this.servers == null || this.servers.mt == null) {
            LOG.info("No servers to shutdown!");
            return;
        }
        for (int i = 0; i < this.numServers; ++i) {
            if (i >= this.servers.mt.length) continue;
            this.servers.mt[i].shutdown();
        }
    }

    public void process(WatchedEvent event) {
    }

    protected Servers LaunchServers(int numServers) throws IOException, InterruptedException {
        return this.LaunchServers(numServers, (Integer)null);
    }

    protected Servers LaunchServers(int numServers, Map<String, String> otherConfigs) throws IOException, InterruptedException {
        return this.LaunchServers(numServers, 0, null, otherConfigs);
    }

    protected Servers LaunchServers(int numServers, Integer tickTime) throws IOException, InterruptedException {
        return this.LaunchServers(numServers, 0, tickTime);
    }

    protected Servers LaunchServers(int numServers, int numObservers, Integer tickTime) throws IOException, InterruptedException {
        return this.LaunchServers(numServers, numObservers, tickTime, new HashMap<String, String>());
    }

    protected Servers LaunchServers(int numServers, int numObservers, Integer tickTime, Map<String, String> otherConfigs) throws IOException, InterruptedException {
        int SERVER_COUNT = numServers + numObservers;
        Servers svrs = new Servers();
        svrs.clientPorts = new int[SERVER_COUNT];
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < SERVER_COUNT; ++i) {
            svrs.clientPorts[i] = PortAssignment.unique();
            String role = i < numServers ? "participant" : "observer";
            sb.append(String.format("server.%d=127.0.0.1:%d:%d:%s;127.0.0.1:%d\n", i, PortAssignment.unique(), PortAssignment.unique(), role, svrs.clientPorts[i]));
        }
        String quorumCfgSection = sb.toString();
        svrs.mt = new MainThread[SERVER_COUNT];
        svrs.zk = new ZooKeeper[SERVER_COUNT];
        for (int i = 0; i < SERVER_COUNT; ++i) {
            svrs.mt[i] = tickTime != null ? new MainThread(i, svrs.clientPorts[i], quorumCfgSection, otherConfigs, tickTime) : new MainThread(i, svrs.clientPorts[i], quorumCfgSection, otherConfigs);
            svrs.mt[i].start();
            svrs.restartClient(i, this);
        }
        this.waitForAll(svrs, ZooKeeper.States.CONNECTED);
        return svrs;
    }

    public static void waitForOne(ZooKeeper zk, ZooKeeper.States state) throws InterruptedException {
        int iterations = ClientBase.CONNECTION_TIMEOUT / 500;
        while (zk.getState() != state) {
            if (iterations-- == 0) {
                throw new RuntimeException("Waiting too long " + zk.getState() + " != " + state);
            }
            Thread.sleep(500L);
        }
    }

    protected void waitForAll(Servers servers, ZooKeeper.States state) throws InterruptedException {
        QuorumPeerTestBase.waitForAll(servers.zk, state);
    }

    public static void waitForAll(ZooKeeper[] zks, ZooKeeper.States state) throws InterruptedException {
        int iterations = ClientBase.CONNECTION_TIMEOUT / 1000;
        boolean someoneNotConnected = true;
        while (someoneNotConnected) {
            if (iterations-- == 0) {
                QuorumPeerTestBase.logStates(zks);
                ClientBase.logAllStackTraces();
                throw new RuntimeException("Waiting too long");
            }
            someoneNotConnected = false;
            for (ZooKeeper zk : zks) {
                if (zk.getState() == state) continue;
                someoneNotConnected = true;
                break;
            }
            Thread.sleep(1000L);
        }
    }

    public static void logStates(ZooKeeper[] zks) {
        StringBuilder sbBuilder = new StringBuilder("Connection States: {");
        for (int i = 0; i < zks.length; ++i) {
            sbBuilder.append(i + " : " + zks[i].getState() + ", ");
        }
        sbBuilder.append('}');
        LOG.error(sbBuilder.toString());
    }

    protected static class Servers {
        MainThread[] mt;
        ZooKeeper[] zk;
        public int[] clientPorts;

        protected Servers() {
        }

        public void shutDownAllServers() throws InterruptedException {
            for (MainThread t : this.mt) {
                t.shutdown();
            }
        }

        public void restartAllServersAndClients(Watcher watcher) throws IOException, InterruptedException {
            for (MainThread t : this.mt) {
                if (t.isAlive()) continue;
                t.start();
            }
            for (int i = 0; i < this.zk.length; ++i) {
                this.restartClient(i, watcher);
            }
        }

        public void restartClient(int clientIndex, Watcher watcher) throws IOException, InterruptedException {
            if (this.zk[clientIndex] != null) {
                this.zk[clientIndex].close();
            }
            this.zk[clientIndex] = new ZooKeeper("127.0.0.1:" + this.clientPorts[clientIndex], ClientBase.CONNECTION_TIMEOUT, watcher);
        }

        public int findLeader() {
            for (int i = 0; i < this.mt.length; ++i) {
                if (this.mt[i].main.quorumPeer.leader == null) continue;
                LOG.info("Leader is {}", (Object)i);
                return i;
            }
            LOG.info("Cannot find Leader");
            return -1;
        }

        public int findAnyFollower() {
            for (int i = 0; i < this.mt.length; ++i) {
                if (this.mt[i].main.quorumPeer.follower == null) continue;
                LOG.info("Follower is {}", (Object)i);
                return i;
            }
            LOG.info("Cannot find any follower");
            return -1;
        }

        public int findAnyObserver() {
            for (int i = 0; i < this.mt.length; ++i) {
                if (this.mt[i].main.quorumPeer.observer == null) continue;
                LOG.info("Observer is {}", (Object)i);
                return i;
            }
            LOG.info("Cannot find any observer");
            return -1;
        }
    }

    public static class MainThread
    implements Runnable {
        final File confFile;
        final File tmpDir;
        public static final int UNSET_STATIC_CLIENTPORT = -1;
        public static final int UNSET_MYID = -1;
        volatile TestQPMain main;
        File baseDir;
        private int myid;
        private int clientPort;
        private String quorumCfgSection;
        private Map<String, String> otherConfigs;
        Thread currentThread;

        public MainThread(int myid, int clientPort, String quorumCfgSection, Map<String, String> otherConfigs, int tickTime) throws IOException {
            this.baseDir = ClientBase.createTmpDir();
            this.myid = myid;
            this.clientPort = clientPort;
            this.quorumCfgSection = quorumCfgSection;
            this.otherConfigs = otherConfigs;
            LOG.info("id = {} tmpDir = {} clientPort = {}", new Object[]{myid, this.baseDir, clientPort});
            this.confFile = new File(this.baseDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=" + tickTime + "\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            fwriter.write("connectToLearnerMasterLimit=5\n");
            this.tmpDir = new File(this.baseDir, "data");
            if (!this.tmpDir.mkdir()) {
                throw new IOException("Unable to mkdir " + this.tmpDir);
            }
            String dir = this.tmpDir.toString();
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().contains("windows")) {
                dir = dir.replace('\\', '/');
            }
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            Set<Map.Entry<String, String>> entrySet = otherConfigs.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                fwriter.write(entry.getKey() + "=" + entry.getValue() + "\n");
            }
            fwriter.write(quorumCfgSection + "\n");
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(this.tmpDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
        }

        public MainThread(int myid, String quorumCfgSection) throws IOException {
            this(myid, quorumCfgSection, true);
        }

        public MainThread(int myid, String quorumCfgSection, Integer secureClientPort, boolean writeDynamicConfigFile) throws IOException {
            this(myid, -1, 8080, secureClientPort, quorumCfgSection, null, null, writeDynamicConfigFile, null);
        }

        public MainThread(int myid, String quorumCfgSection, boolean writeDynamicConfigFile) throws IOException {
            this(myid, -1, quorumCfgSection, writeDynamicConfigFile);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, boolean writeDynamicConfigFile) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, null, null, writeDynamicConfigFile);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, String peerType, boolean writeDynamicConfigFile) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, null, peerType, writeDynamicConfigFile);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, boolean writeDynamicConfigFile, String version) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, null, null, writeDynamicConfigFile, version);
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, String configs) throws IOException {
            this(myid, clientPort, 8080, quorumCfgSection, configs, null, true);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs) throws IOException {
            this(myid, clientPort, adminServerPort, quorumCfgSection, configs, null, true);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs, String peerType, boolean writeDynamicConfigFile) throws IOException {
            this(myid, clientPort, adminServerPort, quorumCfgSection, configs, peerType, writeDynamicConfigFile, null);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, String quorumCfgSection, String configs, String peerType, boolean writeDynamicConfigFile, String version) throws IOException {
            this(myid, clientPort, adminServerPort, null, quorumCfgSection, configs, peerType, writeDynamicConfigFile, version);
        }

        public MainThread(int myid, int clientPort, int adminServerPort, Integer secureClientPort, String quorumCfgSection, String configs, String peerType, boolean writeDynamicConfigFile, String version) throws IOException {
            this.tmpDir = ClientBase.createTmpDir();
            LOG.info("id = {} tmpDir = {} clientPort = {} adminServerPort = {}", new Object[]{myid, this.tmpDir, clientPort, adminServerPort});
            File dataDir = new File(this.tmpDir, "data");
            if (!dataDir.mkdir()) {
                throw new IOException("Unable to mkdir " + dataDir);
            }
            this.confFile = new File(this.tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=4000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            fwriter.write("connectToLearnerMasterLimit=5\n");
            if (configs != null) {
                fwriter.write(configs);
            }
            String dir = PathUtils.normalizeFileSystemPath((String)dataDir.toString());
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("admin.serverPort=" + adminServerPort + "\n");
            if (clientPort != -1) {
                fwriter.write("clientPort=" + clientPort + "\n");
            }
            if (secureClientPort != null) {
                fwriter.write("secureClientPort=" + secureClientPort + "\n");
            }
            if (peerType != null) {
                fwriter.write("peerType=" + peerType + "\n");
            }
            if (writeDynamicConfigFile) {
                String dynamicConfigFilename = this.createDynamicFile(quorumCfgSection, version);
                fwriter.write("dynamicConfigFile=" + dynamicConfigFilename + "\n");
            } else {
                fwriter.write(quorumCfgSection);
            }
            fwriter.flush();
            fwriter.close();
            File myidFile = new File(dataDir, "myid");
            fwriter = new FileWriter(myidFile);
            fwriter.write(Integer.toString(myid));
            fwriter.flush();
            fwriter.close();
            ClientBase.createInitializeFile(dataDir);
        }

        private String createDynamicFile(String quorumCfgSection, String version) throws IOException {
            String filename = "zoo.cfg.dynamic";
            if (version != null) {
                filename = filename + "." + version;
            }
            File dynamicConfigFile = new File(this.tmpDir, filename);
            String dynamicConfigFilename = PathUtils.normalizeFileSystemPath((String)dynamicConfigFile.toString());
            FileWriter fDynamicConfigWriter = new FileWriter(dynamicConfigFile);
            fDynamicConfigWriter.write(quorumCfgSection);
            fDynamicConfigWriter.flush();
            fDynamicConfigWriter.close();
            return dynamicConfigFilename;
        }

        public File[] getDynamicFiles() {
            return this.getFilesWithPrefix("zoo.cfg.dynamic");
        }

        public File[] getFilesWithPrefix(final String prefix) {
            return this.tmpDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
        }

        public File getFileByName(String filename) {
            File f = new File(this.tmpDir.getPath(), filename);
            return f.isFile() ? f : null;
        }

        public void writeTempDynamicConfigFile(String nextQuorumCfgSection, String version) throws IOException {
            File nextDynamicConfigFile = new File(this.tmpDir, "zoo.cfg.dynamic.next");
            FileWriter fwriter = new FileWriter(nextDynamicConfigFile);
            fwriter.write(nextQuorumCfgSection + "\nversion=" + version);
            fwriter.flush();
            fwriter.close();
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection) throws IOException {
            this(myid, clientPort, quorumCfgSection, new HashMap<String, String>());
        }

        public MainThread(int myid, int clientPort, String quorumCfgSection, Map<String, String> otherConfigs) throws IOException {
            this(myid, clientPort, quorumCfgSection, otherConfigs, 4000);
        }

        public synchronized void start() {
            this.main = this.getTestQPMain();
            this.currentThread = new Thread(this);
            this.currentThread.start();
        }

        public TestQPMain getTestQPMain() {
            return new TestQPMain();
        }

        @Override
        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", (Throwable)e);
            }
            finally {
                this.currentThread = null;
            }
        }

        public void shutdown() throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null && t.isAlive()) {
                this.main.shutdown();
                t.join(500L);
            }
        }

        public void join(long timeout) throws InterruptedException {
            Thread t = this.currentThread;
            if (t != null) {
                t.join(timeout);
            }
        }

        public boolean isAlive() {
            Thread t = this.currentThread;
            return t != null && t.isAlive();
        }

        public void reinitialize() throws IOException {
            File dataDir = this.main.quorumPeer.getTxnFactory().getDataLogDir();
            ClientBase.recursiveDelete(dataDir);
            ClientBase.createInitializeFile(dataDir.getParentFile());
        }

        public boolean isQuorumPeerRunning() {
            return this.main.quorumPeer != null;
        }

        public String getPropFromStaticFile(String key) throws IOException {
            Properties props = new Properties();
            props.load(new FileReader(this.confFile));
            return props.getProperty(key, "");
        }

        public QuorumPeer getQuorumPeer() {
            return this.main.quorumPeer;
        }

        public void deleteBaseDir() {
            ClientBase.recursiveDelete(this.baseDir);
        }

        public int getMyid() {
            return this.myid;
        }

        public int getClientPort() {
            return this.clientPort;
        }

        public String getQuorumCfgSection() {
            return this.quorumCfgSection;
        }

        public Map<String, String> getOtherConfigs() {
            return this.otherConfigs;
        }

        public File getConfFile() {
            return this.confFile;
        }
    }

    public static class TestQPMain
    extends QuorumPeerMain {
        public void shutdown() {
            if (this.quorumPeer != null) {
                QuorumBase.shutdown(this.quorumPeer);
            }
        }
    }
}

