/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.GetACLRequest;
import org.apache.zookeeper.proto.GetACLResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class FinalRequestProcessorTest {
    private List<ACL> testACLs = new ArrayList<ACL>();
    private final Record[] responseRecord = new Record[1];
    private final ReplyHeader[] replyHeaders = new ReplyHeader[1];
    private ServerCnxn cnxn;
    private ByteBuffer bb;
    private FinalRequestProcessor processor;

    @BeforeEach
    public void setUp() throws KeeperException.NoNodeException, IOException {
        this.testACLs.clear();
        this.testACLs.addAll(Arrays.asList(new ACL(31, new Id("digest", "user:secrethash")), new ACL(16, new Id("digest", "adminuser:adminsecret")), new ACL(1, new Id("world", "anyone"))));
        ZooKeeperServer zks = new ZooKeeperServer();
        ZKDatabase db = (ZKDatabase)Mockito.mock(ZKDatabase.class);
        String testPath = "/testPath";
        Mockito.when((Object)db.getNode((String)ArgumentMatchers.eq((Object)testPath))).thenReturn((Object)new DataNode());
        Mockito.when((Object)db.getACL((String)ArgumentMatchers.eq((Object)testPath), (Stat)ArgumentMatchers.any(Stat.class))).thenReturn(this.testACLs);
        Mockito.when((Object)db.aclForNode((DataNode)ArgumentMatchers.any(DataNode.class))).thenReturn(this.testACLs);
        zks.setZKDatabase(db);
        this.processor = new FinalRequestProcessor(zks);
        this.cnxn = (ServerCnxn)Mockito.mock(ServerCnxn.class);
        ((ServerCnxn)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) {
                ((FinalRequestProcessorTest)FinalRequestProcessorTest.this).replyHeaders[0] = (ReplyHeader)invocationOnMock.getArgument(0);
                ((FinalRequestProcessorTest)FinalRequestProcessorTest.this).responseRecord[0] = (Record)invocationOnMock.getArgument(1);
                return null;
            }
        }).when((Object)this.cnxn)).sendResponse((ReplyHeader)ArgumentMatchers.any(), (Record)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        GetACLRequest getACLRequest = new GetACLRequest();
        getACLRequest.setPath(testPath);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        getACLRequest.serialize((OutputArchive)boa, "request");
        baos.close();
        this.bb = ByteBuffer.wrap(baos.toByteArray());
    }

    @Test
    public void testACLDigestHashHiding_NoAuth_WorldCanRead() {
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, new ArrayList());
        this.processor.processRequest(r);
        this.assertMasked(true);
    }

    @Test
    public void testACLDigestHashHiding_NoAuth_NoWorld() {
        this.testACLs.remove(2);
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, new ArrayList());
        this.processor.processRequest(r);
        MatcherAssert.assertThat((Object)KeeperException.Code.get((int)this.replyHeaders[0].getErr()), (Matcher)Matchers.equalTo((Object)KeeperException.Code.NOAUTH));
    }

    @Test
    public void testACLDigestHashHiding_UserCanRead() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "otheruser:somesecrethash"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(true);
    }

    @Test
    public void testACLDigestHashHiding_UserCanAll() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "user:secrethash"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(false);
    }

    @Test
    public void testACLDigestHashHiding_AdminUser() {
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "adminuser:adminsecret"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        this.assertMasked(false);
    }

    @Test
    public void testACLDigestHashHiding_OnlyAdmin() {
        this.testACLs.clear();
        this.testACLs.addAll(Arrays.asList(new ACL(1, new Id("digest", "user:secrethash")), new ACL(16, new Id("digest", "adminuser:adminsecret"))));
        ArrayList<Id> authInfo = new ArrayList<Id>();
        authInfo.add(new Id("digest", "adminuser:adminsecret"));
        Request r = new Request(this.cnxn, 0L, 0, 6, this.bb, authInfo);
        this.processor.processRequest(r);
        Assertions.assertTrue((boolean)(this.responseRecord[0] instanceof GetACLResponse), (String)"Not a GetACL response. Auth failed?");
        GetACLResponse rsp = (GetACLResponse)this.responseRecord[0];
        MatcherAssert.assertThat((String)"Number of ACLs in the response are different", (Object)rsp.getAcl().size(), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((String)"Password hash mismatch in the response", (Object)((ACL)rsp.getAcl().get(0)).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        MatcherAssert.assertThat((String)"Password hash mismatch in the response", (Object)((ACL)rsp.getAcl().get(1)).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
    }

    private void assertMasked(boolean masked) {
        Assertions.assertTrue((boolean)(this.responseRecord[0] instanceof GetACLResponse), (String)"Not a GetACL response. Auth failed?");
        GetACLResponse rsp = (GetACLResponse)this.responseRecord[0];
        MatcherAssert.assertThat((String)"Number of ACLs in the response are different", (Object)rsp.getAcl().size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(0)).getPerms(), (Matcher)Matchers.equalTo((Object)31));
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(0)).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        if (masked) {
            MatcherAssert.assertThat((String)"Password hash is not masked in the response", (Object)((ACL)rsp.getAcl().get(0)).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:x"));
        } else {
            MatcherAssert.assertThat((String)"Password hash mismatch in the response", (Object)((ACL)rsp.getAcl().get(0)).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        }
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(1)).getPerms(), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(1)).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        if (masked) {
            MatcherAssert.assertThat((String)"Password hash is not masked in the response", (Object)((ACL)rsp.getAcl().get(1)).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:x"));
        } else {
            MatcherAssert.assertThat((String)"Password hash mismatch in the response", (Object)((ACL)rsp.getAcl().get(1)).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
        }
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(2)).getPerms(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(2)).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"world"));
        MatcherAssert.assertThat((String)"Invalid ACL list in the response", (Object)((ACL)rsp.getAcl().get(2)).getId().getId(), (Matcher)Matchers.equalTo((Object)"anyone"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getPerms(), (Matcher)Matchers.equalTo((Object)31));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(0).getId().getId(), (Matcher)Matchers.equalTo((Object)"user:secrethash"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getPerms(), (Matcher)Matchers.equalTo((Object)16));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"digest"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(1).getId().getId(), (Matcher)Matchers.equalTo((Object)"adminuser:adminsecret"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getPerms(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getId().getScheme(), (Matcher)Matchers.equalTo((Object)"world"));
        MatcherAssert.assertThat((String)"Original ACL list has been modified", (Object)this.testACLs.get(2).getId().getId(), (Matcher)Matchers.equalTo((Object)"anyone"));
    }
}

