/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.RuntimeMetricsUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;

public final class Threads {
    static final Threads INSTANCE = new Threads();
    static final AttributeKey<Boolean> DAEMON = AttributeKey.booleanKey((String)"daemon");

    public static void registerObservers(OpenTelemetry openTelemetry) {
        INSTANCE.registerObservers(openTelemetry, ManagementFactory.getThreadMXBean());
    }

    void registerObservers(OpenTelemetry openTelemetry, ThreadMXBean threadBean) {
        Meter meter = RuntimeMetricsUtil.getMeter(openTelemetry);
        meter.upDownCounterBuilder("process.runtime.jvm.threads.count").setDescription("Number of executing threads").setUnit("1").buildWithCallback(observableMeasurement -> {
            observableMeasurement.record((long)threadBean.getDaemonThreadCount(), Attributes.builder().put(DAEMON, (Object)true).build());
            observableMeasurement.record((long)(threadBean.getThreadCount() - threadBean.getDaemonThreadCount()), Attributes.builder().put(DAEMON, (Object)false).build());
        });
    }

    private Threads() {
    }
}

