/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.statelib.api.checkpoint.CheckpointStore;
import org.apache.bookkeeper.statelib.api.exceptions.StateStoreException;
import org.apache.bookkeeper.statelib.impl.rocksdb.RocksUtils;
import org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.CheckpointInfo;
import org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.RocksdbCheckpointTask;
import org.apache.bookkeeper.stream.proto.kv.store.CheckpointMetadata;
import org.rocksdb.Checkpoint;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksCheckpointer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RocksCheckpointer.class);
    private final String dbName;
    private final File dbPath;
    private final Checkpoint checkpoint;
    private final CheckpointStore checkpointStore;
    private final boolean removeLocalCheckpointAfterSuccessfulCheckpoint;
    private final boolean removeRemoteCheckpointsAfterSuccessfulCheckpoint;
    private final boolean checkpointChecksumEnable;
    private final boolean checkpointChecksumCompatible;

    public static CheckpointMetadata restore(String dbName, File dbPath, CheckpointStore checkpointStore) throws StateStoreException, TimeoutException {
        CheckpointInfo checkpoint = RocksCheckpointer.getLatestCheckpoint(dbName, checkpointStore);
        return RocksCheckpointer.restore(checkpoint, dbName, dbPath, checkpointStore);
    }

    public static CheckpointMetadata restore(CheckpointInfo checkpoint, String dbName, File dbPath, CheckpointStore checkpointStore) throws StateStoreException, TimeoutException {
        checkpoint.restore(dbName, dbPath, checkpointStore);
        RocksCheckpointer.cleanupLocalCheckpoints(dbPath, checkpoint.getId());
        return checkpoint.getMetadata();
    }

    private static void cleanupLocalCheckpoints(File dbPath, String checkpointToExclude) {
        String[] checkpoints;
        File checkpointsDir = new File(dbPath, "checkpoints");
        for (String checkpoint : checkpoints = checkpointsDir.list()) {
            if (checkpoint.equals(checkpointToExclude)) continue;
            try {
                MoreFiles.deleteRecursively((Path)Paths.get(checkpointsDir.getAbsolutePath(), checkpoint), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            }
            catch (IOException ioe) {
                log.warn("Failed to remove unused checkpoint {} from {}", new Object[]{checkpoint, checkpointsDir, ioe});
            }
        }
    }

    private static CheckpointInfo getLatestCheckpoint(String dbPrefix, CheckpointStore checkpointStore) {
        List<CheckpointInfo> checkpoints = RocksCheckpointer.getCheckpoints(dbPrefix, checkpointStore);
        if (checkpoints.size() <= 0) {
            throw new RuntimeException("Checkpoint list can't be empty");
        }
        return checkpoints.get(0);
    }

    public static List<CheckpointInfo> getCheckpoints(String dbPrefix, CheckpointStore store) {
        List<String> files;
        String remoteCheckpointsPath = RocksUtils.getDestCheckpointsPath(dbPrefix);
        ArrayList<CheckpointInfo> result = new ArrayList<CheckpointInfo>();
        result.add(CheckpointInfo.nullCheckpoint());
        try {
            files = store.listFiles(remoteCheckpointsPath);
        }
        catch (IOException e) {
            log.warn("No remote checkpoints available. Starting with nullCheckpoint", (Throwable)e);
            return result;
        }
        for (String checkpointId : files) {
            String metadataPath = RocksUtils.getDestCheckpointMetadataPath(dbPrefix, checkpointId);
            try {
                InputStream is = store.openInputStream(metadataPath);
                try {
                    result.add(new CheckpointInfo(checkpointId, is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (FileNotFoundException fnfe) {
                log.error("Metadata is corrupt for the checkpoint {}. Skipping it.", (Object)checkpointId);
            }
            catch (IOException e) {
                log.error("IO exception {}, Skipping it", (Object)checkpointId, (Object)e);
            }
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    public RocksCheckpointer(String dbName, File dbPath, RocksDB rocksDB, CheckpointStore checkpointStore, boolean removeLocalCheckpointAfterSuccessfulCheckpoint, boolean removeRemoteCheckpointsAfterSuccessfulCheckpoint, boolean checkpointChecksumEnable, boolean checkpointChecksumCompatible) {
        this.dbName = dbName;
        this.dbPath = dbPath;
        this.checkpoint = Checkpoint.create((RocksDB)rocksDB);
        this.checkpointStore = checkpointStore;
        this.removeLocalCheckpointAfterSuccessfulCheckpoint = removeLocalCheckpointAfterSuccessfulCheckpoint;
        this.removeRemoteCheckpointsAfterSuccessfulCheckpoint = removeRemoteCheckpointsAfterSuccessfulCheckpoint;
        this.checkpointChecksumEnable = checkpointChecksumEnable;
        this.checkpointChecksumCompatible = checkpointChecksumCompatible;
    }

    public String checkpointAtTxid(byte[] txid) throws StateStoreException {
        RocksdbCheckpointTask task = new RocksdbCheckpointTask(this.dbName, this.checkpoint, new File(this.dbPath, "checkpoints"), this.checkpointStore, this.removeLocalCheckpointAfterSuccessfulCheckpoint, this.removeRemoteCheckpointsAfterSuccessfulCheckpoint, this.checkpointChecksumEnable, this.checkpointChecksumCompatible);
        return task.checkpoint(txid);
    }

    @Override
    public void close() {
    }
}

