/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.helpers;

import org.apache.bookkeeper.client.api.BookKeeper;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientCommand<ClientFlagsT extends CliFlags>
extends BKCommand<ClientFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(ClientCommand.class);

    protected ClientCommand(CliSpec<ClientFlagsT> spec) {
        super(spec);
    }

    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, ClientFlagsT cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration();
        clientConf.loadConf(conf);
        if (null != serviceURI) {
            clientConf.setMetadataServiceUri(serviceURI.getUri().toString());
        }
        return this.apply(clientConf, cmdFlags);
    }

    public boolean apply(ServerConfiguration conf, ClientFlagsT cmdFlags) {
        ClientConfiguration clientConf = new ClientConfiguration(conf);
        return this.apply(clientConf, cmdFlags);
    }

    protected boolean apply(ClientConfiguration conf, ClientFlagsT cmdFlags) {
        boolean bl;
        block8: {
            BookKeeper bk = BookKeeper.newBuilder(conf).build();
            try {
                this.run(bk, cmdFlags);
                bl = true;
                if (bk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bk != null) {
                        try {
                            bk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to process command '{}'", (Object)this.name(), (Object)e);
                    return false;
                }
            }
            bk.close();
        }
        return bl;
    }

    protected abstract void run(BookKeeper var1, ClientFlagsT var2) throws Exception;
}

