/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands;

import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.stream.cli.commands.AbstractStreamCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdminCommand<ClientFlagsT extends CliFlags>
extends AbstractStreamCommand<ClientFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(AdminCommand.class);

    protected AdminCommand(CliSpec<ClientFlagsT> spec) {
        super(spec);
    }

    @Override
    protected boolean doApply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags bkFlags, ClientFlagsT cmdFlags) {
        boolean bl;
        block8: {
            StorageClientSettings settings = StorageClientSettings.newBuilder().clientName("bkctl").serviceUri(serviceURI.getUri().toString()).build();
            StorageAdminClient admin = StorageClientBuilder.newBuilder().withSettings(settings).buildAdmin();
            try {
                this.run(admin, bkFlags, cmdFlags);
                bl = true;
                if (admin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (admin != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to process stream admin command", (Throwable)e);
                    this.spec.console().println("Failed to process stream admin command");
                    e.printStackTrace(this.spec.console());
                    return false;
                }
            }
            admin.close();
        }
        return bl;
    }

    protected abstract void run(StorageAdminClient var1, BKFlags var2, ClientFlagsT var3) throws Exception;
}

