/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.util.PortForwarder;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;

public class ObserverMasterTestBase
extends QuorumPeerTestBase
implements Watcher {
    protected CountDownLatch latch;
    protected ZooKeeper zk;
    protected int CLIENT_PORT_QP1;
    protected int CLIENT_PORT_QP2;
    protected int CLIENT_PORT_OBS;
    protected int OM_PORT;
    protected QuorumPeerTestBase.MainThread q1;
    protected QuorumPeerTestBase.MainThread q2;
    protected QuorumPeerTestBase.MainThread q3;
    protected WatchedEvent lastEvent = null;

    protected PortForwarder setUp(int omProxyPort, Boolean testObserverMaster) throws IOException {
        String extraCfgs;
        ClientBase.setupTestEnv();
        int PORT_QP1 = PortAssignment.unique();
        int PORT_QP2 = PortAssignment.unique();
        int PORT_OBS = PortAssignment.unique();
        int PORT_QP_LE1 = PortAssignment.unique();
        int PORT_QP_LE2 = PortAssignment.unique();
        int PORT_OBS_LE = PortAssignment.unique();
        this.CLIENT_PORT_QP1 = PortAssignment.unique();
        this.CLIENT_PORT_QP2 = PortAssignment.unique();
        this.CLIENT_PORT_OBS = PortAssignment.unique();
        this.OM_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PORT_QP1 + ":" + PORT_QP_LE1 + ";" + this.CLIENT_PORT_QP1 + "\nserver.2=127.0.0.1:" + PORT_QP2 + ":" + PORT_QP_LE2 + ";" + this.CLIENT_PORT_QP2 + "\nserver.3=127.0.0.1:" + PORT_OBS + ":" + PORT_OBS_LE + ":observer;" + this.CLIENT_PORT_OBS;
        String string = extraCfgs = testObserverMaster != false ? String.format("observerMasterPort=%d%n", this.OM_PORT) : "";
        String extraCfgsObs = testObserverMaster != false ? String.format("observerMasterPort=%d%n", omProxyPort <= 0 ? this.OM_PORT : omProxyPort) : "";
        PortForwarder forwarder = null;
        if (testObserverMaster.booleanValue() && omProxyPort >= 0) {
            forwarder = new PortForwarder(omProxyPort, this.OM_PORT);
        }
        this.q1 = new QuorumPeerTestBase.MainThread(1, this.CLIENT_PORT_QP1, quorumCfgSection, extraCfgs);
        this.q2 = new QuorumPeerTestBase.MainThread(2, this.CLIENT_PORT_QP2, quorumCfgSection, extraCfgs);
        this.q3 = new QuorumPeerTestBase.MainThread(3, this.CLIENT_PORT_OBS, quorumCfgSection, extraCfgsObs);
        this.q1.start();
        this.q2.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 1 being up");
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 2 being up");
        return forwarder;
    }

    protected void shutdown() throws InterruptedException {
        LOG.info("Shutting down all servers");
        this.zk.close();
        this.q1.shutdown();
        this.q2.shutdown();
        this.q3.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP1, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server 1 to shut down");
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_QP2, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server 2 to shut down");
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.CLIENT_PORT_OBS, ClientBase.CONNECTION_TIMEOUT), (String)"Waiting for server 3 to shut down");
    }

    @Override
    public void process(WatchedEvent event) {
        this.lastEvent = event;
        if (this.latch != null) {
            this.latch.countDown();
        }
        LOG.info("Latch got event :: {}", (Object)event);
    }
}

