/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.ExistsRequest;
import org.apache.zookeeper.proto.ExistsResponse;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.util.OSMXBean;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientTest.class);
    private boolean skipACL = System.getProperty("zookeeper.skipACL", "no").equals("yes");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPing() throws Exception {
        TestableZooKeeper zkIdle = null;
        TestableZooKeeper zkWatchCreator = null;
        try {
            int i;
            ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
            zkIdle = this.createClient(watcher, this.hostPort, 10000);
            zkWatchCreator = this.createClient();
            for (i = 0; i < 10; ++i) {
                zkWatchCreator.create("/" + i, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            for (i = 0; i < 10; ++i) {
                zkIdle.exists("/" + i, true);
            }
            for (i = 0; i < 10; ++i) {
                Thread.sleep(1000L);
                zkWatchCreator.delete("/" + i, -1);
            }
            zkIdle.exists("/0", false);
        }
        finally {
            if (zkIdle != null) {
                zkIdle.close();
            }
            if (zkWatchCreator != null) {
                zkWatchCreator.close();
            }
        }
    }

    @Test
    public void testClientwithoutWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.performClientTest(false);
    }

    @Test
    public void testClientWithWatcherObj() throws IOException, InterruptedException, KeeperException {
        this.performClientTest(true);
    }

    @Test
    public void testTestability() throws Exception {
        TestableZooKeeper zk = this.createClient();
        try {
            LOG.info("{}", (Object)zk.testableLocalSocketAddress());
            LOG.info("{}", (Object)zk.testableRemoteSocketAddress());
            LOG.info("{}", (Object)zk.toString());
        }
        finally {
            zk.close(CONNECTION_TIMEOUT);
            LOG.info("{}", (Object)zk.testableLocalSocketAddress());
            LOG.info("{}", (Object)zk.testableRemoteSocketAddress());
            LOG.info("{}", (Object)zk.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testACLs() throws Exception {
        try (TestableZooKeeper zk = null;){
            ArrayList<ACL> testACL;
            zk = this.createClient();
            try {
                zk.create("/acltest", new byte[0], ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
                Assertions.fail((String)"Should have received an invalid acl error");
            }
            catch (KeeperException.InvalidACLException e) {
                LOG.info("Test successful, invalid acl received : {}", (Object)e.getMessage());
            }
            try {
                testACL = new ArrayList<ACL>();
                testACL.add(new ACL(31, ZooDefs.Ids.AUTH_IDS));
                testACL.add(new ACL(31, new Id("ip", "127.0.0.1/8")));
                zk.create("/acltest", new byte[0], testACL, CreateMode.PERSISTENT);
                Assertions.fail((String)"Should have received an invalid acl error");
            }
            catch (KeeperException.InvalidACLException e) {
                LOG.info("Test successful, invalid acl received : {}", (Object)e.getMessage());
            }
            try {
                testACL = new ArrayList();
                testACL.add(new ACL(31, new Id()));
                zk.create("/nullidtest", new byte[0], testACL, CreateMode.PERSISTENT);
                Assertions.fail((String)"Should have received an invalid acl error");
            }
            catch (KeeperException.InvalidACLException e) {
                LOG.info("Test successful, invalid acl received : {}", (Object)e.getMessage());
            }
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            testACL = new ArrayList();
            testACL.add(new ACL(31, new Id("auth", "")));
            testACL.add(new ACL(2, new Id("ip", "127.0.0.1")));
            zk.create("/acltest", new byte[0], testACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "ben:passwd2".getBytes());
            if (this.skipACL) {
                try {
                    zk.getData("/acltest", false, null);
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Badauth reads should succeed with skipACL.");
                }
            } else {
                try {
                    zk.getData("/acltest", false, null);
                    Assertions.fail((String)"Should have received a permission error");
                }
                catch (KeeperException e) {
                    Assertions.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)e.code());
                }
            }
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.getData("/acltest", false, null);
            zk.setACL("/acltest", ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
            zk.close();
            zk = this.createClient();
            zk.getData("/acltest", false, null);
            List acls = zk.getACL("/acltest", new Stat());
            Assertions.assertEquals((int)1, (int)acls.size());
            Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)acls);
            acls = zk.getACL("/acltest", null);
            Assertions.assertEquals((int)1, (int)acls.size());
            Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)acls);
            zk.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullAuthId() throws Exception {
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            ArrayList<ACL> testACL = new ArrayList<ACL>();
            testACL.add(new ACL(31, new Id("auth", null)));
            zk.create("/acltest", new byte[0], testACL, CreateMode.PERSISTENT);
            zk.close();
            zk = this.createClient();
            zk.addAuthInfo("digest", "ben:passwd2".getBytes());
            if (this.skipACL) {
                try {
                    zk.getData("/acltest", false, null);
                }
                catch (KeeperException e) {
                    Assertions.fail((String)"Badauth reads should succeed with skipACL.");
                }
            } else {
                try {
                    zk.getData("/acltest", false, null);
                    Assertions.fail((String)"Should have received a permission error");
                }
                catch (KeeperException e) {
                    Assertions.assertEquals((Object)KeeperException.Code.NOAUTH, (Object)e.code());
                }
            }
            zk.addAuthInfo("digest", "ben:passwd".getBytes());
            zk.getData("/acltest", false, null);
            zk.setACL("/acltest", ZooDefs.Ids.OPEN_ACL_UNSAFE, -1);
            zk.close();
            zk = this.createClient();
            zk.getData("/acltest", false, null);
            List acls = zk.getACL("/acltest", new Stat());
            Assertions.assertEquals((int)1, (int)acls.size());
            Assertions.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)acls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutipleWatcherObjs() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = this.createClient(new ClientBase.CountdownWatcher(), this.hostPort);){
            WatchedEvent event;
            int i;
            MyWatcher[] watchers = new MyWatcher[100];
            MyWatcher[] watchers2 = new MyWatcher[watchers.length];
            for (int i2 = 0; i2 < watchers.length; ++i2) {
                watchers[i2] = new MyWatcher();
                watchers2[i2] = new MyWatcher();
                zk.create("/foo-" + i2, ("foodata" + i2).getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            Stat stat = new Stat();
            for (i = 0; i < watchers.length; ++i) {
                Assertions.assertNotNull((Object)zk.getData("/foo-" + i, watchers[i], stat));
            }
            for (i = 0; i < watchers.length; ++i) {
                Assertions.assertNotNull((Object)zk.exists("/foo-" + i, watchers[i]));
            }
            for (i = 0; i < watchers.length; ++i) {
                zk.setData("/foo-" + i, ("foodata2-" + i).getBytes(), -1);
                zk.setData("/foo-" + i, ("foodata3-" + i).getBytes(), -1);
            }
            for (i = 0; i < watchers.length; ++i) {
                event = watchers[i].events.poll(10L, TimeUnit.SECONDS);
                Assertions.assertEquals((Object)("/foo-" + i), (Object)event.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
                Assertions.assertEquals((int)0, (int)watchers[i].events.size());
            }
            for (i = 0; i < watchers.length; ++i) {
                Assertions.assertNotNull((Object)zk.getData("/foo-" + i, watchers[i], stat));
                Assertions.assertNotNull((Object)zk.exists("/foo-" + i, watchers[i]));
            }
            for (i = 0; i < watchers.length; ++i) {
                zk.setData("/foo-" + i, ("foodata4-" + i).getBytes(), -1);
                zk.setData("/foo-" + i, ("foodata5-" + i).getBytes(), -1);
            }
            for (i = 0; i < watchers.length; ++i) {
                event = watchers[i].events.poll(10L, TimeUnit.SECONDS);
                Assertions.assertEquals((Object)("/foo-" + i), (Object)event.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
                Assertions.assertEquals((int)0, (int)watchers[i].events.size());
            }
            for (i = 0; i < watchers.length; ++i) {
                Assertions.assertNotNull((Object)zk.getData("/foo-" + i, watchers[i], stat));
                Assertions.assertNotNull((Object)zk.exists("/foo-" + i, watchers2[i]));
            }
            for (i = 0; i < watchers.length; ++i) {
                zk.setData("/foo-" + i, ("foodata6-" + i).getBytes(), -1);
                zk.setData("/foo-" + i, ("foodata7-" + i).getBytes(), -1);
            }
            for (i = 0; i < watchers.length; ++i) {
                event = watchers[i].events.poll(10L, TimeUnit.SECONDS);
                Assertions.assertEquals((Object)("/foo-" + i), (Object)event.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
                Assertions.assertEquals((int)0, (int)watchers[i].events.size());
                WatchedEvent event2 = watchers2[i].events.poll(10L, TimeUnit.SECONDS);
                Assertions.assertEquals((Object)("/foo-" + i), (Object)event2.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event2.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event2.getState());
                Assertions.assertEquals((int)0, (int)watchers2[i].events.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performClientTest(boolean withWatcherObj) throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = null;){
            String name;
            int i;
            MyWatcher watcher = new MyWatcher();
            zk = this.createClient(watcher, this.hostPort);
            LOG.info("Before create /benwashere");
            zk.create("/benwashere", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("After create /benwashere");
            try {
                zk.setData("/benwashere", "hi".getBytes(), 57);
                Assertions.fail((String)"Should have gotten BadVersion exception");
            }
            catch (KeeperException.BadVersionException badVersionException) {
            }
            catch (KeeperException e) {
                Assertions.fail((String)"Should have gotten BadVersion exception");
            }
            LOG.info("Before delete /benwashere");
            zk.delete("/benwashere", 0);
            LOG.info("After delete /benwashere");
            zk.close();
            Thread.sleep(2000L);
            zk = this.createClient(watcher, this.hostPort);
            LOG.info("Before delete /");
            try {
                zk.delete("/", -1);
                Assertions.fail((String)"deleted root!");
            }
            catch (KeeperException.BadArgumentsException e) {
                // empty catch block
            }
            Stat stat = new Stat();
            zk.create("/pat", "Pat was here".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Before create /ben");
            zk.create("/pat/ben", "Ben was here".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Before getChildren /pat");
            List children = zk.getChildren("/pat", false);
            Assertions.assertEquals((int)1, (int)children.size());
            Assertions.assertEquals((Object)"ben", children.get(0));
            List children2 = zk.getChildren("/pat", false, null);
            Assertions.assertEquals((Object)children, (Object)children2);
            String value = new String(zk.getData("/pat/ben", false, stat));
            Assertions.assertEquals((Object)"Ben was here", (Object)value);
            try {
                if (withWatcherObj) {
                    Assertions.assertEquals(null, (Object)zk.exists("/frog", watcher));
                } else {
                    Assertions.assertEquals(null, (Object)zk.exists("/frog", true));
                }
                LOG.info("Comment: asseting passed for frog setting /");
            }
            catch (KeeperException.NoNodeException noNodeException) {
                // empty catch block
            }
            zk.create("/frog", "hi".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            LOG.info("Comment: checking for events length {}", (Object)watcher.events.size());
            WatchedEvent event = watcher.events.poll(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"/frog", (Object)event.getPath());
            Assertions.assertEquals((Object)Watcher.Event.EventType.NodeCreated, (Object)event.getType());
            Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
            zk.getChildren("/pat/ben", true);
            for (i = 0; i < 10; ++i) {
                zk.create("/pat/ben/" + i + "-", Integer.toString(i).getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
            children = zk.getChildren("/pat/ben", false);
            Collections.sort(children);
            Assertions.assertEquals((int)10, (int)children.size());
            for (i = 0; i < 10; ++i) {
                name = (String)children.get(i);
                Assertions.assertTrue((boolean)name.startsWith(i + "-"), (String)"starts with -");
                byte[] b = withWatcherObj ? zk.getData("/pat/ben/" + name, watcher, stat) : zk.getData("/pat/ben/" + name, true, stat);
                Assertions.assertEquals((Object)Integer.toString(i), (Object)new String(b));
                zk.setData("/pat/ben/" + name, "new".getBytes(), stat.getVersion());
                stat = withWatcherObj ? zk.exists("/pat/ben/" + name, watcher) : zk.exists("/pat/ben/" + name, true);
                zk.delete("/pat/ben/" + name, stat.getVersion());
            }
            event = watcher.events.poll(10L, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"/pat/ben", (Object)event.getPath());
            Assertions.assertEquals((Object)Watcher.Event.EventType.NodeChildrenChanged, (Object)event.getType());
            Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
            for (i = 0; i < 10; ++i) {
                event = watcher.events.poll(10L, TimeUnit.SECONDS);
                name = (String)children.get(i);
                Assertions.assertEquals((Object)("/pat/ben/" + name), (Object)event.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDataChanged, (Object)event.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
                event = watcher.events.poll(10L, TimeUnit.SECONDS);
                Assertions.assertEquals((Object)("/pat/ben/" + name), (Object)event.getPath());
                Assertions.assertEquals((Object)Watcher.Event.EventType.NodeDeleted, (Object)event.getType());
                Assertions.assertEquals((Object)Watcher.Event.KeeperState.SyncConnected, (Object)event.getState());
            }
            zk.create("/good@path", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.create("/duplicate", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            try {
                zk.create("/duplicate", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                Assertions.fail((String)"duplicate create allowed");
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequentialNodeNames() throws IOException, InterruptedException, KeeperException {
        String path = "/SEQUENCE";
        String file = "TEST";
        String filepath = path + "/" + file;
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.create(path, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.create(filepath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            List children = zk.getChildren(path, false);
            Assertions.assertEquals((int)1, (int)children.size());
            Assertions.assertEquals((Object)(file + "0000000000"), children.get(0));
            zk.create(filepath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            children = zk.getChildren(path, false);
            Assertions.assertEquals((int)2, (int)children.size());
            Assertions.assertTrue((boolean)children.contains(file + "0000000001"), (String)"contains child 1");
            zk.create(filepath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            children = zk.getChildren(path, false);
            Assertions.assertEquals((int)3, (int)children.size());
            Assertions.assertTrue((boolean)children.contains(file + "0000000002"), (String)"contains child 2");
            for (int i = children.size(); i < 105; ++i) {
                zk.create(filepath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            }
            children = zk.getChildren(path, false);
            Assertions.assertTrue((boolean)children.contains(file + "0000000104"), (String)"contains child 104");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSequentialNodeData() throws Exception {
        String queue_handle = "/queue";
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.create(queue_handle, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            zk.create(queue_handle + "/element", "0".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            zk.create(queue_handle + "/element", "1".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            List children = zk.getChildren(queue_handle, true);
            Assertions.assertEquals((int)children.size(), (int)2);
            String child1 = (String)children.get(0);
            String child2 = (String)children.get(1);
            int compareResult = child1.compareTo(child2);
            Assertions.assertNotSame((Object)compareResult, (Object)0);
            if (compareResult >= 0) {
                String temp = child1;
                child1 = child2;
                child2 = temp;
            }
            String child1data = new String(zk.getData(queue_handle + "/" + child1, false, null));
            String child2data = new String(zk.getData(queue_handle + "/" + child2, false, null));
            Assertions.assertEquals((Object)child1data, (Object)"0");
            Assertions.assertEquals((Object)child2data, (Object)"1");
        }
    }

    @Test
    public void testLargeNodeData() throws Exception {
        String queue_handle = "/large";
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.create(queue_handle, new byte[500000], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
    }

    private void verifyCreateFails(String path, ZooKeeper zk) throws Exception {
        try {
            zk.create(path, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Assertions.fail((String)("bad path \"" + path + "\" not caught"));
    }

    @Test
    public void testPathValidation() throws Exception {
        TestableZooKeeper zk = this.createClient();
        this.verifyCreateFails(null, (ZooKeeper)zk);
        this.verifyCreateFails("", (ZooKeeper)zk);
        this.verifyCreateFails("//", (ZooKeeper)zk);
        this.verifyCreateFails("///", (ZooKeeper)zk);
        this.verifyCreateFails("////", (ZooKeeper)zk);
        this.verifyCreateFails("/.", (ZooKeeper)zk);
        this.verifyCreateFails("/..", (ZooKeeper)zk);
        this.verifyCreateFails("/./", (ZooKeeper)zk);
        this.verifyCreateFails("/../", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/./", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/../", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/.", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/..", (ZooKeeper)zk);
        this.verifyCreateFails("/./.", (ZooKeeper)zk);
        this.verifyCreateFails("/../..", (ZooKeeper)zk);
        this.verifyCreateFails("/\u0001foo", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/bar/", (ZooKeeper)zk);
        this.verifyCreateFails("/foo//bar", (ZooKeeper)zk);
        this.verifyCreateFails("/foo/bar//", (ZooKeeper)zk);
        this.verifyCreateFails("foo", (ZooKeeper)zk);
        this.verifyCreateFails("a", (ZooKeeper)zk);
        zk.create("/createseqpar", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zk.create("/createseqpar/", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        zk.create("/createseqpar/", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        zk.create("/createseqpar/.", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        zk.create("/createseqpar/..", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        try {
            zk.create("/createseqpar//", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            Assertions.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            zk.create("/createseqpar/./", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            Assertions.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            zk.create("/createseqpar/../", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
            Assertions.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PrepRequestProcessor.setFailCreate((boolean)true);
        try {
            zk.create("/m", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            Assertions.assertTrue((boolean)false);
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
            // empty catch block
        }
        PrepRequestProcessor.setFailCreate((boolean)false);
        zk.create("/.foo", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/.f.", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/..f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/..f..", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f.c", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f@f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/.f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/f.", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/..f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/f..", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/.f/f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/f/f./f", null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    @Test
    public void testDeleteWithChildren() throws Exception {
        TestableZooKeeper zk = this.createClient();
        zk.create("/parent", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/parent/child", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        try {
            zk.delete("/parent", -1);
            Assertions.fail((String)"Should have received a not equals message");
        }
        catch (KeeperException e) {
            Assertions.assertEquals((Object)KeeperException.Code.NOTEMPTY, (Object)e.code());
        }
        zk.delete("/parent/child", -1);
        zk.delete("/parent", -1);
        zk.close();
    }

    @Test
    public void testClientCleanup() throws Throwable {
        int i;
        OSMXBean osMbean = new OSMXBean();
        if (!osMbean.getUnix()) {
            LOG.warn("skipping testClientCleanup, only available on Unix");
            return;
        }
        int threadCount = 3;
        int clientCount = 10;
        long initialFdCount = osMbean.getOpenFileDescriptorCount();
        VerifyClientCleanup[] threads = new VerifyClientCleanup[3];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new VerifyClientCleanup("VCC" + i, 10);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join(CONNECTION_TIMEOUT);
            Assertions.assertTrue((threads[i].current == threads[i].count ? 1 : 0) != 0);
        }
        long currentCount = osMbean.getOpenFileDescriptorCount();
        String logmsg = "open fds after test ({}) are not significantly higher than before ({})";
        if (currentCount > initialFdCount + 10L) {
            LOG.error("open fds after test ({}) are not significantly higher than before ({})", (Object)currentCount, (Object)initialFdCount);
        } else {
            LOG.info("open fds after test ({}) are not significantly higher than before ({})", (Object)currentCount, (Object)initialFdCount);
        }
    }

    @Test
    public void testNonExistingOpCode() throws Exception {
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        Watcher watcher = new Watcher(){

            public synchronized void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    clientDisconnected.countDown();
                }
            }
        };
        TestableZooKeeper zk = new TestableZooKeeper(this.hostPort, CONNECTION_TIMEOUT, watcher);
        String path = "/m1";
        RequestHeader h = new RequestHeader();
        h.setType(888);
        ExistsRequest request = new ExistsRequest();
        request.setPath("/m1");
        request.setWatch(false);
        ExistsResponse response = new ExistsResponse();
        ReplyHeader r = zk.submitRequest(h, (Record)request, (Record)response, null);
        Assertions.assertEquals((int)r.getErr(), (int)KeeperException.Code.UNIMPLEMENTED.intValue());
        Assertions.assertTrue((boolean)clientDisconnected.await(5000L, TimeUnit.MILLISECONDS), (String)"failed to disconnect");
        zk.close();
    }

    @Test
    public void testTryWithResources() throws Exception {
        TestableZooKeeper zooKeeper;
        try (TestableZooKeeper zk = this.createClient();){
            zooKeeper = zk;
            Assertions.assertTrue((boolean)zooKeeper.getState().isAlive());
        }
        Assertions.assertFalse((boolean)zooKeeper.getState().isAlive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCXidRollover() throws Exception {
        try (TestableZooKeeper zk = null;){
            zk = this.createClient();
            zk.setXid(0x7FFFFFF5);
            zk.create("/testnode", "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (int i = 0; i < 20; ++i) {
                CountDownLatch latch = new CountDownLatch(1);
                AtomicInteger rc = new AtomicInteger(0);
                zk.setData("/testnode", "".getBytes(), -1, (retcode, path, ctx, stat) -> {
                    rc.set(retcode);
                    latch.countDown();
                }, null);
                Assertions.assertTrue((boolean)latch.await(zk.getSessionTimeout(), TimeUnit.MILLISECONDS), (String)"setData should complete within 5s");
                Assertions.assertEquals((int)KeeperException.Code.OK.intValue(), (int)rc.get(), (String)"setData should have succeeded");
            }
            zk.delete("/testnode", -1);
            Assertions.assertTrue((zk.checkXid() > 0 ? 1 : 0) != 0, (String)"xid should be positive");
        }
    }

    private class VerifyClientCleanup
    extends Thread {
        int count;
        int current;

        VerifyClientCleanup(String name, int count) {
            super(name);
            this.current = 0;
            this.count = count;
        }

        @Override
        public void run() {
            try {
                while (this.current < this.count) {
                    TestableZooKeeper zk = ClientTest.this.createClient();
                    zk.close(ClientBase.CONNECTION_TIMEOUT);
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("test failed", t);
            }
        }
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

        private MyWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            super.process(event);
            if (event.getType() != Watcher.Event.EventType.None) {
                try {
                    this.events.put(event);
                }
                catch (InterruptedException e) {
                    LOG.warn("ignoring interrupt during event.put");
                }
            }
        }
    }
}

