/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.util.JvmPauseMonitor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class JvmPauseMonitorTest {
    private final Long sleepTime = 100L;
    private final Long infoTH = -1L;
    private final Long warnTH = -1L;
    private JvmPauseMonitor pauseMonitor;

    @Test
    @Timeout(value=5L)
    public void testJvmPauseMonitorExceedInfoThreshold() throws InterruptedException {
        QuorumPeerConfig qpConfig = (QuorumPeerConfig)Mockito.mock(QuorumPeerConfig.class);
        Mockito.when((Object)qpConfig.getJvmPauseSleepTimeMs()).thenReturn((Object)this.sleepTime);
        Mockito.when((Object)qpConfig.getJvmPauseInfoThresholdMs()).thenReturn((Object)this.infoTH);
        this.pauseMonitor = new JvmPauseMonitor(qpConfig);
        this.pauseMonitor.serviceStart();
        Assertions.assertEquals((Long)this.sleepTime, (Long)this.pauseMonitor.sleepTimeMs);
        Assertions.assertEquals((Long)this.infoTH, (Long)this.pauseMonitor.infoThresholdMs);
        while (this.pauseMonitor.getNumGcInfoThresholdExceeded() == 0L) {
            Thread.sleep(200L);
        }
    }

    @Test
    @Timeout(value=5L)
    public void testJvmPauseMonitorExceedWarnThreshold() throws InterruptedException {
        QuorumPeerConfig qpConfig = (QuorumPeerConfig)Mockito.mock(QuorumPeerConfig.class);
        Mockito.when((Object)qpConfig.getJvmPauseSleepTimeMs()).thenReturn((Object)this.sleepTime);
        Mockito.when((Object)qpConfig.getJvmPauseWarnThresholdMs()).thenReturn((Object)this.warnTH);
        this.pauseMonitor = new JvmPauseMonitor(qpConfig);
        this.pauseMonitor.serviceStart();
        Assertions.assertEquals((Long)this.sleepTime, (Long)this.pauseMonitor.sleepTimeMs);
        Assertions.assertEquals((Long)this.warnTH, (Long)this.pauseMonitor.warnThresholdMs);
        while (this.pauseMonitor.getNumGcWarnThresholdExceeded() == 0L) {
            Thread.sleep(200L);
        }
    }

    @AfterEach
    public void teardown() {
        this.pauseMonitor.serviceStop();
    }
}

