/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum.auth;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.kerby.kerberos.kerb.keytab.Keytab;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.zookeeper.server.quorum.auth.KerberosSecurityTestcase;
import org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import org.apache.zookeeper.server.quorum.auth.MiniKdc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MiniKdcTest
extends KerberosSecurityTestcase {
    @Test
    @Timeout(value=60L)
    public void testMiniKdcStart() {
        MiniKdc kdc = MiniKdcTest.getKdc();
        Assertions.assertNotSame((Object)0, (Object)kdc.getPort());
    }

    @Test
    @Timeout(value=60L)
    public void testKeytabGen() throws Exception {
        MiniKdc kdc = MiniKdcTest.getKdc();
        File workDir = MiniKdcTest.getWorkDir();
        kdc.createPrincipal(new File(workDir, "keytab"), "foo/bar", "bar/foo");
        List principalNameList = Keytab.loadKeytab((File)new File(workDir, "keytab")).getPrincipals();
        HashSet<String> principals = new HashSet<String>();
        for (PrincipalName principalName : principalNameList) {
            principals.add(principalName.getName());
        }
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("foo/bar@" + kdc.getRealm(), "bar/foo@" + kdc.getRealm())), principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testKerberosLogin() throws Exception {
        MiniKdc kdc = MiniKdcTest.getKdc();
        File workDir = MiniKdcTest.getWorkDir();
        LoginContext loginContext = null;
        try {
            String principal = "foo";
            File keytab = new File(workDir, "foo.keytab");
            kdc.createPrincipal(keytab, principal);
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosTestUtils.KerberosConfiguration.createClientConfig(principal, keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assertions.assertEquals((int)1, (int)subject.getPrincipals().size());
            Assertions.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assertions.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
            subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosTestUtils.KerberosConfiguration.createServerConfig(principal, keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assertions.assertEquals((int)1, (int)subject.getPrincipals().size());
            Assertions.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assertions.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
        }
        finally {
            if (loginContext != null && loginContext.getSubject() != null && !loginContext.getSubject().getPrincipals().isEmpty()) {
                loginContext.logout();
            }
        }
    }
}

