/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.configuration.Configuration;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestZooKeeperClientBuilder;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.ZooKeeperClientUtils;
import org.apache.distributedlog.callback.LogSegmentNamesListener;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.BKNamespaceDriver;
import org.apache.distributedlog.impl.ZKLogSegmentMetadataStore;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZKLogSegmentMetadataStore
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestZKLogSegmentMetadataStore.class);
    private static final int zkSessionTimeoutMs = 2000;
    @Rule
    public TestName runtime = new TestName();
    protected final DistributedLogConfiguration baseConf = new DistributedLogConfiguration();
    protected ZooKeeperClient zkc;
    protected ZKLogSegmentMetadataStore lsmStore;
    protected OrderedScheduler scheduler;
    protected URI uri;
    protected String rootZkPath;

    private LogSegmentMetadata createLogSegment(long logSegmentSequenceNumber) {
        return this.createLogSegment(logSegmentSequenceNumber, 99L);
    }

    private LogSegmentMetadata createLogSegment(long logSegmentSequenceNumber, long lastEntryId) {
        return DLMTestUtil.completedLogSegment("/" + this.runtime.getMethodName(), logSegmentSequenceNumber, logSegmentSequenceNumber, 1L, 100, logSegmentSequenceNumber, lastEntryId, 0L, LogSegmentMetadata.LEDGER_METADATA_CURRENT_LAYOUT_VERSION);
    }

    @Override
    @Before
    public void setup() throws Exception {
        this.zkc = TestZooKeeperClientBuilder.newBuilder().uri(this.createDLMURI("/")).sessionTimeoutMs(2000).build();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test-zk-logsegment-metadata-store").numThreads(1).build();
        DistributedLogConfiguration conf = new DistributedLogConfiguration();
        conf.addConfiguration((Configuration)this.baseConf);
        this.uri = this.createDLMURI("/" + this.runtime.getMethodName());
        this.lsmStore = new ZKLogSegmentMetadataStore(conf, this.zkc, this.scheduler);
        this.zkc.get().create("/" + this.runtime.getMethodName(), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.rootZkPath = "/" + this.runtime.getMethodName();
    }

    @Override
    @After
    public void teardown() throws Exception {
        if (null != this.zkc) {
            this.zkc.close();
        }
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    @Test(timeout=60000L)
    public void testCreateLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment + " should be created"), (Object)this.zkc.get().exists(segment.getZkPath(), false));
        LogSegmentMetadata segment2 = this.createLogSegment(1L);
        Transaction createTxn2 = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn2, segment2, null);
        try {
            Utils.ioResult((CompletableFuture)createTxn2.execute());
            Assert.fail((String)"Should fail if log segment exists");
        }
        catch (Throwable t) {
            Assert.assertTrue((String)"Should throw NodeExistsException if log segment exists", (boolean)(t instanceof ZKException));
            ZKException zke = (ZKException)t;
            Assert.assertEquals((String)"Should throw NodeExistsException if log segment exists", (Object)KeeperException.Code.NODEEXISTS, (Object)zke.getKeeperExceptionCode());
        }
    }

    @Test(timeout=60000L)
    public void testDeleteLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment + " should be created"), (Object)this.zkc.get().exists(segment.getZkPath(), false));
        Transaction deleteTxn = this.lsmStore.transaction();
        this.lsmStore.deleteLogSegment(deleteTxn, segment, null);
        Utils.ioResult((CompletableFuture)deleteTxn.execute());
        Assert.assertNull((String)("LogSegment " + segment + " should be deleted"), (Object)this.zkc.get().exists(segment.getZkPath(), false));
    }

    @Test(timeout=60000L)
    public void testDeleteNonExistentLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L);
        Transaction deleteTxn = this.lsmStore.transaction();
        this.lsmStore.deleteLogSegment(deleteTxn, segment, null);
        try {
            Utils.ioResult((CompletableFuture)deleteTxn.execute());
            Assert.fail((String)"Should fail deletion if log segment doesn't exist");
        }
        catch (Throwable t) {
            Assert.assertTrue((String)"Should throw NoNodeException if log segment doesn't exist", (boolean)(t instanceof ZKException));
            ZKException zke = (ZKException)t;
            Assert.assertEquals((String)"Should throw NoNodeException if log segment doesn't exist", (Object)KeeperException.Code.NONODE, (Object)zke.getKeeperExceptionCode());
        }
    }

    @Test(timeout=60000L)
    public void testUpdateNonExistentLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L);
        Transaction updateTxn = this.lsmStore.transaction();
        this.lsmStore.updateLogSegment(updateTxn, segment);
        try {
            Utils.ioResult((CompletableFuture)updateTxn.execute());
            Assert.fail((String)"Should fail update if log segment doesn't exist");
        }
        catch (Throwable t) {
            Assert.assertTrue((String)"Should throw NoNodeException if log segment doesn't exist", (boolean)(t instanceof ZKException));
            ZKException zke = (ZKException)t;
            Assert.assertEquals((String)"Should throw NoNodeException if log segment doesn't exist", (Object)KeeperException.Code.NONODE, (Object)zke.getKeeperExceptionCode());
        }
    }

    @Test(timeout=60000L)
    public void testUpdateLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L, 99L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment + " should be created"), (Object)this.zkc.get().exists(segment.getZkPath(), false));
        LogSegmentMetadata modifiedSegment = this.createLogSegment(1L, 999L);
        Transaction updateTxn = this.lsmStore.transaction();
        this.lsmStore.updateLogSegment(updateTxn, modifiedSegment);
        Utils.ioResult((CompletableFuture)updateTxn.execute());
        LogSegmentMetadata readSegment = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)LogSegmentMetadata.read((ZooKeeperClient)this.zkc, (String)segment.getZkPath(), (boolean)true));
        Assert.assertEquals((String)"Last entry id should be changed from 99L to 999L", (long)999L, (long)readSegment.getLastEntryId());
    }

    @Test(timeout=60000L)
    public void testCreateDeleteLogSegmentSuccess() throws Exception {
        LogSegmentMetadata segment1 = this.createLogSegment(1L);
        LogSegmentMetadata segment2 = this.createLogSegment(2L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment1, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment1 + " should be created"), (Object)this.zkc.get().exists(segment1.getZkPath(), false));
        Transaction createDeleteTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createDeleteTxn, segment2, null);
        this.lsmStore.deleteLogSegment(createDeleteTxn, segment1, null);
        Utils.ioResult((CompletableFuture)createDeleteTxn.execute());
        Assert.assertNull((String)("LogSegment " + segment1 + " should be deleted"), (Object)this.zkc.get().exists(segment1.getZkPath(), false));
        Assert.assertNotNull((String)("LogSegment " + segment2 + " should be created"), (Object)this.zkc.get().exists(segment2.getZkPath(), false));
    }

    @Test(timeout=60000L)
    public void testCreateDeleteLogSegmentFailure() throws Exception {
        LogSegmentMetadata segment1 = this.createLogSegment(1L);
        LogSegmentMetadata segment2 = this.createLogSegment(2L);
        LogSegmentMetadata segment3 = this.createLogSegment(3L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment1, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment1 + " should be created"), (Object)this.zkc.get().exists(segment1.getZkPath(), false));
        Transaction createDeleteTxn = this.lsmStore.transaction();
        this.lsmStore.deleteLogSegment(createDeleteTxn, segment1, null);
        this.lsmStore.deleteLogSegment(createDeleteTxn, segment2, null);
        this.lsmStore.createLogSegment(createDeleteTxn, segment3, null);
        try {
            Utils.ioResult((CompletableFuture)createDeleteTxn.execute());
            Assert.fail((String)"Should fail transaction if one operation failed");
        }
        catch (Throwable t) {
            Assert.assertTrue((String)"Transaction is aborted", (boolean)(t instanceof ZKException));
            ZKException zke = (ZKException)t;
            Assert.assertEquals((String)"Transaction is aborted", (Object)KeeperException.Code.NONODE, (Object)zke.getKeeperExceptionCode());
        }
        Assert.assertNotNull((String)("LogSegment " + segment1 + " should not be deleted"), (Object)this.zkc.get().exists(segment1.getZkPath(), false));
        Assert.assertNull((String)("LogSegment " + segment3 + " should be created"), (Object)this.zkc.get().exists(segment3.getZkPath(), false));
    }

    @Test(timeout=60000L)
    public void testGetLogSegment() throws Exception {
        LogSegmentMetadata segment = this.createLogSegment(1L, 99L);
        Transaction createTxn = this.lsmStore.transaction();
        this.lsmStore.createLogSegment(createTxn, segment, null);
        Utils.ioResult((CompletableFuture)createTxn.execute());
        Assert.assertNotNull((String)("LogSegment " + segment + " should be created"), (Object)this.zkc.get().exists(segment.getZkPath(), false));
        LogSegmentMetadata readSegment = (LogSegmentMetadata)Utils.ioResult((CompletableFuture)this.lsmStore.getLogSegment(segment.getZkPath()));
        Assert.assertEquals((String)"Log segment should match", (Object)segment, (Object)readSegment);
    }

    @Test(timeout=60000L)
    public void testGetLogSegmentNames() throws Exception {
        Transaction createTxn = this.lsmStore.transaction();
        ArrayList createdSegments = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 0; i < 10; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            createdSegments.add(segment);
            this.lsmStore.createLogSegment(createTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)createTxn.execute());
        String rootPath = "/" + this.runtime.getMethodName();
        List children = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(children);
        Assert.assertEquals((String)"Should find 10 log segments", (long)10L, (long)children.size());
        List logSegmentNames = (List)((Versioned)Utils.ioResult((CompletableFuture)this.lsmStore.getLogSegmentNames(rootPath, null))).getValue();
        Collections.sort(logSegmentNames);
        Assert.assertEquals((String)"Should find 10 log segments", (long)10L, (long)logSegmentNames.size());
        Assert.assertEquals((Object)children, (Object)logSegmentNames);
        ArrayList getFutures = Lists.newArrayListWithExpectedSize((int)10);
        for (int i = 0; i < 10; ++i) {
            getFutures.add(this.lsmStore.getLogSegment(rootPath + "/" + (String)logSegmentNames.get(i)));
        }
        List segments = (List)Utils.ioResult((CompletableFuture)FutureUtils.collect((List)getFutures));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals(createdSegments.get(i), segments.get(i));
        }
    }

    @Test(timeout=60000L)
    public void testRegisterListenerAfterLSMStoreClosed() throws Exception {
        this.lsmStore.close();
        LogSegmentMetadata segment = this.createLogSegment(1L);
        this.lsmStore.getLogSegmentNames(segment.getZkPath(), new LogSegmentNamesListener(){

            public void onSegmentsUpdated(Versioned<List<String>> segments) {
            }

            public void onLogStreamDeleted() {
            }
        });
        Assert.assertTrue((String)"No listener is registered", (boolean)this.lsmStore.listeners.isEmpty());
    }

    @Test(timeout=60000L)
    public void testLogSegmentNamesListener() throws Exception {
        int numSegments = 3;
        Transaction createTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(createTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)createTxn.execute());
        String rootPath = "/" + this.runtime.getMethodName();
        List children = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(children);
        final AtomicInteger numNotifications = new AtomicInteger(0);
        final ArrayList segmentLists = Lists.newArrayListWithExpectedSize((int)2);
        LogSegmentNamesListener listener = new LogSegmentNamesListener(){

            public void onSegmentsUpdated(Versioned<List<String>> segments) {
                logger.info("Received segments : {}", segments);
                segmentLists.add((List)segments.getValue());
                numNotifications.incrementAndGet();
            }

            public void onLogStreamDeleted() {
            }
        };
        this.lsmStore.getLogSegmentNames(rootPath, listener);
        Assert.assertEquals((long)1L, (long)this.lsmStore.listeners.size());
        Assert.assertTrue((String)"Should contain listener", (boolean)this.lsmStore.listeners.containsKey(rootPath));
        Assert.assertTrue((String)"Should contain listener", (boolean)((Map)this.lsmStore.listeners.get(rootPath)).containsKey(listener));
        while (numNotifications.get() < 1) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive one segment list update", (long)1L, (long)numNotifications.get());
        List firstSegmentList = (List)segmentLists.get(0);
        Collections.sort(firstSegmentList);
        Assert.assertEquals((String)"List of segments should be same", (Object)children, (Object)firstSegmentList);
        logger.info("Create another {} segments.", (Object)numSegments);
        Transaction anotherCreateTxn = this.lsmStore.transaction();
        for (int i = numSegments; i < 2 * numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(anotherCreateTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)anotherCreateTxn.execute());
        List newChildren = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(newChildren);
        logger.info("All log segments become {}", (Object)newChildren);
        while (numNotifications.get() < 2) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive second segment list update", (long)2L, (long)numNotifications.get());
        List secondSegmentList = (List)segmentLists.get(1);
        Collections.sort(secondSegmentList);
        Assert.assertEquals((String)"List of segments should be updated", (long)(2 * numSegments), (long)secondSegmentList.size());
        Assert.assertEquals((String)"List of segments should be updated", (Object)newChildren, (Object)secondSegmentList);
    }

    @Test(timeout=60000L)
    public void testLogSegmentNamesListenerOnDeletion() throws Exception {
        int numSegments = 3;
        Transaction createTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(createTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)createTxn.execute());
        String rootPath = "/" + this.runtime.getMethodName();
        List children = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(children);
        final AtomicInteger numNotifications = new AtomicInteger(0);
        final ArrayList segmentLists = Lists.newArrayListWithExpectedSize((int)2);
        LogSegmentNamesListener listener = new LogSegmentNamesListener(){

            public void onSegmentsUpdated(Versioned<List<String>> segments) {
                logger.info("Received segments : {}", segments);
                segmentLists.add((List)segments.getValue());
                numNotifications.incrementAndGet();
            }

            public void onLogStreamDeleted() {
            }
        };
        this.lsmStore.getLogSegmentNames(rootPath, listener);
        Assert.assertEquals((long)1L, (long)this.lsmStore.listeners.size());
        Assert.assertTrue((String)"Should contain listener", (boolean)this.lsmStore.listeners.containsKey(rootPath));
        Assert.assertTrue((String)"Should contain listener", (boolean)((Map)this.lsmStore.listeners.get(rootPath)).containsKey(listener));
        while (numNotifications.get() < 1) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive one segment list update", (long)1L, (long)numNotifications.get());
        List firstSegmentList = (List)segmentLists.get(0);
        Collections.sort(firstSegmentList);
        Assert.assertEquals((String)"List of segments should be same", (Object)children, (Object)firstSegmentList);
        Transaction deleteTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.deleteLogSegment(deleteTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)deleteTxn.execute());
        List newChildren = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(newChildren);
        while (numNotifications.get() < 2) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive second segment list update", (long)2L, (long)numNotifications.get());
        List secondSegmentList = (List)segmentLists.get(1);
        Collections.sort(secondSegmentList);
        Assert.assertEquals((String)"List of segments should be updated", (long)0L, (long)secondSegmentList.size());
        Assert.assertEquals((String)"List of segments should be updated", (Object)newChildren, (Object)secondSegmentList);
        this.zkc.get().delete(rootPath, -1);
        while (!this.lsmStore.listeners.isEmpty()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertTrue((String)"listener should be removed after root path is deleted", (boolean)this.lsmStore.listeners.isEmpty());
    }

    @Test(timeout=60000L)
    public void testLogSegmentNamesListenerOnSessionExpired() throws Exception {
        int numSegments = 3;
        Transaction createTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(createTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)createTxn.execute());
        String rootPath = "/" + this.runtime.getMethodName();
        List children = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(children);
        final AtomicInteger numNotifications = new AtomicInteger(0);
        final ArrayList segmentLists = Lists.newArrayListWithExpectedSize((int)2);
        LogSegmentNamesListener listener = new LogSegmentNamesListener(){

            public void onSegmentsUpdated(Versioned<List<String>> segments) {
                logger.info("Received segments : {}", segments);
                segmentLists.add((List)segments.getValue());
                numNotifications.incrementAndGet();
            }

            public void onLogStreamDeleted() {
            }
        };
        this.lsmStore.getLogSegmentNames(rootPath, listener);
        Assert.assertEquals((long)1L, (long)this.lsmStore.listeners.size());
        Assert.assertTrue((String)"Should contain listener", (boolean)this.lsmStore.listeners.containsKey(rootPath));
        Assert.assertTrue((String)"Should contain listener", (boolean)((Map)this.lsmStore.listeners.get(rootPath)).containsKey(listener));
        while (numNotifications.get() < 1) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive one segment list update", (long)1L, (long)numNotifications.get());
        List firstSegmentList = (List)segmentLists.get(0);
        Collections.sort(firstSegmentList);
        Assert.assertEquals((String)"List of segments should be same", (Object)children, (Object)firstSegmentList);
        ZooKeeperClientUtils.expireSession(this.zkc, BKNamespaceDriver.getZKServersFromDLUri((URI)this.uri), conf.getZKSessionTimeoutMilliseconds());
        logger.info("Create another {} segments.", (Object)numSegments);
        Transaction anotherCreateTxn = this.lsmStore.transaction();
        for (int i = numSegments; i < 2 * numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(anotherCreateTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)anotherCreateTxn.execute());
        List newChildren = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(newChildren);
        logger.info("All log segments become {}", (Object)newChildren);
        while (numNotifications.get() < 2) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive third segment list update", (long)2L, (long)numNotifications.get());
        List thirdSegmentList = (List)segmentLists.get(1);
        Collections.sort(thirdSegmentList);
        Assert.assertEquals((String)"List of segments should be updated", (long)(2 * numSegments), (long)thirdSegmentList.size());
        Assert.assertEquals((String)"List of segments should be updated", (Object)newChildren, (Object)thirdSegmentList);
    }

    @Test(timeout=60000L)
    public void testLogSegmentNamesListenerOnDeletingLogStream() throws Exception {
        int numSegments = 3;
        Transaction createTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.createLogSegment(createTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)createTxn.execute());
        String rootPath = "/" + this.runtime.getMethodName();
        List children = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(children);
        final AtomicInteger numNotifications = new AtomicInteger(0);
        final ArrayList segmentLists = Lists.newArrayListWithExpectedSize((int)2);
        final CountDownLatch deleteLatch = new CountDownLatch(1);
        LogSegmentNamesListener listener = new LogSegmentNamesListener(){

            public void onSegmentsUpdated(Versioned<List<String>> segments) {
                logger.info("Received segments : {}", segments);
                segmentLists.add((List)segments.getValue());
                numNotifications.incrementAndGet();
            }

            public void onLogStreamDeleted() {
                deleteLatch.countDown();
            }
        };
        this.lsmStore.getLogSegmentNames(rootPath, listener);
        Assert.assertEquals((long)1L, (long)this.lsmStore.listeners.size());
        Assert.assertTrue((String)"Should contain listener", (boolean)this.lsmStore.listeners.containsKey(rootPath));
        Assert.assertTrue((String)"Should contain listener", (boolean)((Map)this.lsmStore.listeners.get(rootPath)).containsKey(listener));
        while (numNotifications.get() < 1) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive one segment list update", (long)1L, (long)numNotifications.get());
        List firstSegmentList = (List)segmentLists.get(0);
        Collections.sort(firstSegmentList);
        Assert.assertEquals((String)"List of segments should be same", (Object)children, (Object)firstSegmentList);
        Transaction deleteTxn = this.lsmStore.transaction();
        for (int i = 0; i < numSegments; ++i) {
            LogSegmentMetadata segment = this.createLogSegment(i);
            this.lsmStore.deleteLogSegment(deleteTxn, segment, null);
        }
        Utils.ioResult((CompletableFuture)deleteTxn.execute());
        List newChildren = this.zkc.get().getChildren(rootPath, false);
        Collections.sort(newChildren);
        while (numNotifications.get() < 2) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertEquals((String)"Should receive second segment list update", (long)2L, (long)numNotifications.get());
        List secondSegmentList = (List)segmentLists.get(1);
        Collections.sort(secondSegmentList);
        Assert.assertEquals((String)"List of segments should be updated", (long)0L, (long)secondSegmentList.size());
        Assert.assertEquals((String)"List of segments should be updated", (Object)newChildren, (Object)secondSegmentList);
        this.zkc.get().delete(rootPath, -1);
        while (!this.lsmStore.listeners.isEmpty()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        Assert.assertTrue((String)"listener should be removed after root path is deleted", (boolean)this.lsmStore.listeners.isEmpty());
        deleteLatch.await();
    }

    @Test(timeout=60000L)
    public void testStoreMaxLogSegmentSequenceNumber() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(0L));
        final CompletableFuture result = new CompletableFuture();
        LogMetadata metadata = (LogMetadata)Mockito.mock(LogMetadata.class);
        Mockito.when((Object)metadata.getLogSegmentsPath()).thenReturn((Object)this.rootZkPath);
        this.lsmStore.storeMaxLogSegmentSequenceNumber(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        Utils.ioResult((CompletableFuture)updateTxn.execute());
        Assert.assertEquals((long)1L, (long)((LongVersion)Utils.ioResult(result)).getLongVersion());
        Stat stat = new Stat();
        byte[] data = this.zkc.get().getData(this.rootZkPath, false, stat);
        Assert.assertEquals((long)999L, (long)DLUtils.deserializeLogSegmentSequenceNumber((byte[])data));
        Assert.assertEquals((long)1L, (long)stat.getVersion());
    }

    @Test(timeout=60000L)
    public void testStoreMaxLogSegmentSequenceNumberBadVersion() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(10L));
        final CompletableFuture result = new CompletableFuture();
        LogMetadata metadata = (LogMetadata)Mockito.mock(LogMetadata.class);
        Mockito.when((Object)metadata.getLogSegmentsPath()).thenReturn((Object)this.rootZkPath);
        this.lsmStore.storeMaxLogSegmentSequenceNumber(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        try {
            Utils.ioResult((CompletableFuture)updateTxn.execute());
            Assert.fail((String)"Should fail on storing log segment sequence number if providing bad version");
        }
        catch (ZKException zke) {
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)zke.getKeeperExceptionCode());
        }
        try {
            Utils.ioResult(result);
            Assert.fail((String)"Should fail on storing log segment sequence number if providing bad version");
        }
        catch (ZKException ze) {
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)ze.getKeeperExceptionCode());
        }
        Stat stat = new Stat();
        byte[] data = this.zkc.get().getData(this.rootZkPath, false, stat);
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)data.length);
    }

    @Test(timeout=60000L)
    public void testStoreMaxLogSegmentSequenceNumberOnNonExistentPath() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(10L));
        final CompletableFuture result = new CompletableFuture();
        String nonExistentPath = this.rootZkPath + "/non-existent";
        LogMetadata metadata = (LogMetadata)Mockito.mock(LogMetadata.class);
        Mockito.when((Object)metadata.getLogSegmentsPath()).thenReturn((Object)nonExistentPath);
        this.lsmStore.storeMaxLogSegmentSequenceNumber(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        try {
            Utils.ioResult((CompletableFuture)updateTxn.execute());
            Assert.fail((String)"Should fail on storing log segment sequence number if path doesn't exist");
        }
        catch (ZKException zke) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)zke.getKeeperExceptionCode());
        }
        try {
            Utils.ioResult(result);
            Assert.fail((String)"Should fail on storing log segment sequence number if path doesn't exist");
        }
        catch (ZKException ke) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)ke.getKeeperExceptionCode());
        }
    }

    @Test(timeout=60000L)
    public void testStoreMaxTxnId() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(0L));
        final CompletableFuture result = new CompletableFuture();
        LogMetadataForWriter metadata = (LogMetadataForWriter)Mockito.mock(LogMetadataForWriter.class);
        Mockito.when((Object)metadata.getMaxTxIdPath()).thenReturn((Object)this.rootZkPath);
        this.lsmStore.storeMaxTxnId(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        Utils.ioResult((CompletableFuture)updateTxn.execute());
        Assert.assertEquals((long)1L, (long)((LongVersion)Utils.ioResult(result)).getLongVersion());
        Stat stat = new Stat();
        byte[] data = this.zkc.get().getData(this.rootZkPath, false, stat);
        Assert.assertEquals((long)999L, (long)DLUtils.deserializeTransactionId((byte[])data));
        Assert.assertEquals((long)1L, (long)stat.getVersion());
    }

    @Test(timeout=60000L)
    public void testStoreMaxTxnIdBadVersion() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(10L));
        final CompletableFuture result = new CompletableFuture();
        LogMetadataForWriter metadata = (LogMetadataForWriter)Mockito.mock(LogMetadataForWriter.class);
        Mockito.when((Object)metadata.getMaxTxIdPath()).thenReturn((Object)this.rootZkPath);
        this.lsmStore.storeMaxTxnId(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        try {
            Utils.ioResult((CompletableFuture)updateTxn.execute());
            Assert.fail((String)"Should fail on storing log record transaction id if providing bad version");
        }
        catch (ZKException zke) {
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)zke.getKeeperExceptionCode());
        }
        try {
            Utils.ioResult(result);
            Assert.fail((String)"Should fail on storing log record transaction id if providing bad version");
        }
        catch (ZKException ze) {
            Assert.assertEquals((Object)KeeperException.Code.BADVERSION, (Object)ze.getKeeperExceptionCode());
        }
        Stat stat = new Stat();
        byte[] data = this.zkc.get().getData(this.rootZkPath, false, stat);
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)data.length);
    }

    @Test(timeout=60000L)
    public void testStoreMaxTxnIdOnNonExistentPath() throws Exception {
        Transaction updateTxn = this.lsmStore.transaction();
        Versioned value = new Versioned((Object)999L, (Version)new LongVersion(10L));
        final CompletableFuture result = new CompletableFuture();
        String nonExistentPath = this.rootZkPath + "/non-existent";
        LogMetadataForWriter metadata = (LogMetadataForWriter)Mockito.mock(LogMetadataForWriter.class);
        Mockito.when((Object)metadata.getMaxTxIdPath()).thenReturn((Object)nonExistentPath);
        this.lsmStore.storeMaxTxnId(updateTxn, metadata, value, (Transaction.OpListener)new Transaction.OpListener<Version>(){

            public void onCommit(Version r) {
                result.complete(r);
            }

            public void onAbort(Throwable t) {
                result.completeExceptionally(t);
            }
        });
        try {
            Utils.ioResult((CompletableFuture)updateTxn.execute());
            Assert.fail((String)"Should fail on storing log record transaction id if path doesn't exist");
        }
        catch (ZKException zke) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)zke.getKeeperExceptionCode());
        }
        try {
            Utils.ioResult(result);
            Assert.fail((String)"Should fail on storing log record transaction id if path doesn't exist");
        }
        catch (ZKException ze) {
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)ze.getKeeperExceptionCode());
        }
    }
}

