/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestRollLogSegments;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnId
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestRollLogSegments.class);

    @Test
    public void testRecoveryAfterBookieCrash() throws Exception {
        BKAsyncLogWriter writer;
        BKDistributedLogManager dlm2;
        String name = "txnid-after-crash";
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setEnsembleSize(5).setWriteQuorumSize(5).setAckQuorumSize(5).setLogSegmentRollingIntervalMinutes(0).setLogSegmentRollingConcurrency(-1).setMaxLogSegmentBytes(400000L);
        bkutil.addBookie();
        bkutil.addBookie();
        try {
            dlm2 = this.createNewDLM(conf, name);
            try {
                writer = dlm2.startAsyncLogSegmentNonPartitioned();
                try {
                    writer.write(DLMTestUtil.getLogRecordInstance(1L, 100000)).join();
                    writer.write(DLMTestUtil.getLogRecordInstance(2L, 100000)).join();
                    bkutil.removeBookie();
                    bkutil.removeBookie();
                    try {
                        writer.write(DLMTestUtil.getLogRecordInstance(3L, 100000)).join();
                        Assert.fail((String)"Shouldn't have succeeded");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    writer.write(DLMTestUtil.getLogRecordInstance(4L, 100000)).join();
                    Assert.fail((String)"Shouldn't be able to write");
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            finally {
                if (dlm2 != null) {
                    dlm2.close();
                }
            }
        }
        catch (Exception dlm2) {
            // empty catch block
        }
        bkutil.addBookie();
        bkutil.addBookie();
        dlm2 = this.createNewDLM(conf, name);
        try {
            writer = dlm2.startAsyncLogSegmentNonPartitioned();
            try {
                long firstTxid = dlm2.getLastTxId() + 1L;
                for (int i = 0; i < 20; ++i) {
                    logger.info("Writing entry {}", (Object)i);
                    writer.write(DLMTestUtil.getLogRecordInstance(firstTxid + (long)i, 100000)).join();
                    Thread.sleep(100L);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (dlm2 != null) {
                dlm2.close();
            }
        }
    }
}

