/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import io.grpc.ExperimentalApi;
import io.grpc.services.MetricRecorderHelper;
import io.grpc.services.MetricReport;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9006")
public final class MetricRecorder {
    private volatile ConcurrentHashMap<String, Double> metricsData = new ConcurrentHashMap();
    private volatile double cpuUtilization;
    private volatile double applicationUtilization;
    private volatile double memoryUtilization;
    private volatile double qps;
    private volatile double eps;

    public static MetricRecorder newInstance() {
        return new MetricRecorder();
    }

    private MetricRecorder() {
    }

    public void putUtilizationMetric(String key, double value) {
        if (!MetricRecorderHelper.isUtilizationValid(value)) {
            return;
        }
        this.metricsData.put(key, value);
    }

    public void setAllUtilizationMetrics(Map<String, Double> metrics) {
        this.metricsData = new ConcurrentHashMap<String, Double>(metrics);
    }

    public void removeUtilizationMetric(String key) {
        this.metricsData.remove(key);
    }

    public void setCpuUtilizationMetric(double value) {
        if (!MetricRecorderHelper.isCpuOrApplicationUtilizationValid(value)) {
            return;
        }
        this.cpuUtilization = value;
    }

    public void clearCpuUtilizationMetric() {
        this.cpuUtilization = 0.0;
    }

    public void setApplicationUtilizationMetric(double value) {
        if (!MetricRecorderHelper.isCpuOrApplicationUtilizationValid(value)) {
            return;
        }
        this.applicationUtilization = value;
    }

    public void clearApplicationUtilizationMetric() {
        this.applicationUtilization = 0.0;
    }

    public void setMemoryUtilizationMetric(double value) {
        if (!MetricRecorderHelper.isUtilizationValid(value)) {
            return;
        }
        this.memoryUtilization = value;
    }

    public void clearMemoryUtilizationMetric() {
        this.memoryUtilization = 0.0;
    }

    public void setQpsMetric(double value) {
        if (!MetricRecorderHelper.isRateValid(value)) {
            return;
        }
        this.qps = value;
    }

    public void clearQpsMetric() {
        this.qps = 0.0;
    }

    public void setEpsMetric(double value) {
        if (!MetricRecorderHelper.isRateValid(value)) {
            return;
        }
        this.eps = value;
    }

    public void clearEpsMetric() {
        this.eps = 0.0;
    }

    MetricReport getMetricReport() {
        return new MetricReport(this.cpuUtilization, this.applicationUtilization, this.memoryUtilization, this.qps, this.eps, Collections.emptyMap(), Collections.unmodifiableMap(this.metricsData));
    }
}

