/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands;

import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.stream.cli.commands.AbstractStreamCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientCommand<ClientFlagsT extends CliFlags>
extends AbstractStreamCommand<ClientFlagsT> {
    private static final Logger log = LoggerFactory.getLogger(ClientCommand.class);

    protected ClientCommand(CliSpec<ClientFlagsT> spec) {
        super(spec);
    }

    @Override
    protected boolean doApply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, ClientFlagsT cmdFlags) {
        boolean bl;
        block8: {
            StorageClientSettings settings = StorageClientSettings.newBuilder().clientName("bkctl").serviceUri(serviceURI.getUri().toString()).build();
            StorageClient client = StorageClientBuilder.newBuilder().withSettings(settings).withNamespace(globalFlags.namespace).build();
            try {
                this.run(client, cmdFlags);
                bl = true;
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Failed to process commands under namespace '{}'", (Object)globalFlags.namespace, (Object)e);
                    this.spec.console().println("Failed to process stream admin command");
                    e.printStackTrace(this.spec.console());
                    return false;
                }
            }
            client.close();
        }
        return bl;
    }

    protected abstract void run(StorageClient var1, ClientFlagsT var2) throws Exception;
}

