/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBufAllocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShimFactory;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.PortManager;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookKeeper
implements AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalBookKeeper.class);
    public static final int CONNECTION_TIMEOUT = 30000;
    int numberOfBookies;
    private static String zooKeeperDefaultHost = "127.0.0.1";
    private static int zooKeeperDefaultPort = 2181;
    private static int zkSessionTimeOut = 5000;
    private static String defaultLocalBookiesConfigDir = "/tmp/localbookies-config";
    List<LocalBookie> localBookies;
    ZooKeeperServerShim zks;
    String zkHost;
    int zkPort;
    String dirSuffix;
    ByteBufAllocatorWithOomHandler allocator;
    private ServerConfiguration baseConf;
    File localBookiesConfigDir;
    List<File> dirsToCleanUp;
    boolean stopOnExit;

    private static String newMetadataServiceUri(String zkServers, int port, String layout, String ledgerPath) {
        return "zk+" + layout + "://" + zkServers + ":" + port + ledgerPath;
    }

    public LocalBookKeeper(int numberOfBookies, ServerConfiguration baseConf, String localBookiesConfigDirName, boolean stopOnExit, String dirSuffix, String zkHost, int zkPort) {
        this.numberOfBookies = numberOfBookies;
        this.localBookiesConfigDir = new File(localBookiesConfigDirName);
        this.baseConf = baseConf;
        this.localBookies = new ArrayList<LocalBookie>();
        this.stopOnExit = stopOnExit;
        this.dirSuffix = dirSuffix;
        this.zkHost = zkHost;
        this.zkPort = zkPort;
        this.dirsToCleanUp = new ArrayList<File>();
        LOG.info("Running {} bookie(s) on zk ensemble = '{}:{}'.", new Object[]{this.numberOfBookies, zooKeeperDefaultHost, zooKeeperDefaultPort});
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort) throws IOException {
        File zkTmpDir = IOUtils.createTempDir("zookeeper", "localbookkeeper");
        return LocalBookKeeper.runZookeeper(maxCC, zookeeperPort, zkTmpDir);
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort, File zkDir) throws IOException {
        LOG.info("Starting ZK server");
        ZooKeeperServerShim server = ZooKeeperServerShimFactory.createServer(zkDir, zkDir, zookeeperPort, maxCC);
        server.start();
        boolean b = LocalBookKeeper.waitForServerUp(InetAddress.getLoopbackAddress().getHostAddress() + ":" + zookeeperPort, 30000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ZooKeeper server up: {}", (Object)b);
        }
        return server;
    }

    private void initializeZookeeper() throws IOException {
        LOG.info("Instantiate ZK Client");
        try (ZooKeeperClient zkc = ZooKeeperClient.newBuilder().connectString(this.zkHost + ":" + this.zkPort).sessionTimeoutMs(zkSessionTimeOut).build();){
            String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.baseConf);
            ZkUtils.createFullPathOptimistic(zkc, zkLedgersRootPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ArrayList multiOps = Lists.newArrayListWithExpectedSize((int)2);
            multiOps.add(Op.create((String)(zkLedgersRootPath + "/" + "available"), (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            multiOps.add(Op.create((String)(zkLedgersRootPath + "/" + "available" + "/" + "readonly"), (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            zkc.multi(multiOps);
        }
        catch (KeeperException e) {
            LOG.error("Exception while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
    }

    private static void cleanupDirectories(List<File> dirs) throws IOException {
        for (File dir : dirs) {
            FileUtils.deleteDirectory((File)dir);
        }
    }

    private void runBookies() throws Exception {
        LOG.info("Starting Bookie(s)");
        if (this.localBookiesConfigDir.exists() && this.localBookiesConfigDir.isFile()) {
            throw new IOException("Unable to create LocalBookiesConfigDir, since there is a file at " + this.localBookiesConfigDir.getAbsolutePath());
        }
        if (!this.localBookiesConfigDir.exists() && !this.localBookiesConfigDir.mkdirs()) {
            throw new IOException("Unable to create LocalBookiesConfigDir - " + this.localBookiesConfigDir.getAbsolutePath());
        }
        this.allocator = BookieResources.createAllocator(this.baseConf);
        for (int i = 0; i < this.numberOfBookies; ++i) {
            this.runBookie(i);
        }
        ServerConfiguration baseConfWithCorrectZKServers = new ServerConfiguration((ServerConfiguration)((Object)this.baseConf.clone()));
        if (null == this.baseConf.getMetadataServiceUriUnchecked()) {
            baseConfWithCorrectZKServers.setMetadataServiceUri(this.baseConf.getMetadataServiceUri());
        }
        this.serializeLocalBookieConfig(baseConfWithCorrectZKServers, "baseconf.conf");
    }

    private void runBookie(int bookieIndex) throws Exception {
        File journalDirs;
        if (null == this.baseConf.getJournalDirNameWithoutDefault()) {
            journalDirs = IOUtils.createTempDir("localbookkeeper" + bookieIndex, this.dirSuffix);
            this.dirsToCleanUp.add(journalDirs);
        } else {
            journalDirs = new File(this.baseConf.getJournalDirName(), "bookie" + bookieIndex);
        }
        if (journalDirs.exists()) {
            if (journalDirs.isDirectory()) {
                FileUtils.deleteDirectory((File)journalDirs);
            } else if (!journalDirs.delete()) {
                throw new IOException("Couldn't cleanup bookie journal dir " + journalDirs);
            }
        }
        if (!journalDirs.mkdirs()) {
            throw new IOException("Couldn't create bookie journal dir " + journalDirs);
        }
        String[] ledgerDirs = this.baseConf.getLedgerDirWithoutDefault();
        if (null == ledgerDirs || 0 == ledgerDirs.length) {
            ledgerDirs = new String[]{journalDirs.getPath()};
        } else {
            for (int l = 0; l < ledgerDirs.length; ++l) {
                File dir = new File(ledgerDirs[l], "bookie" + bookieIndex);
                if (dir.exists()) {
                    if (dir.isDirectory()) {
                        FileUtils.deleteDirectory((File)dir);
                    } else if (!dir.delete()) {
                        throw new IOException("Couldn't cleanup bookie ledger dir " + dir);
                    }
                }
                if (!dir.mkdirs()) {
                    throw new IOException("Couldn't create bookie ledger dir " + dir);
                }
                this.dirsToCleanUp.add(dir);
                ledgerDirs[l] = dir.getPath();
            }
        }
        ServerConfiguration conf = new ServerConfiguration((ServerConfiguration)((Object)this.baseConf.clone()));
        conf.setBookiePort(PortManager.nextFreePort());
        if (null == this.baseConf.getMetadataServiceUriUnchecked()) {
            conf.setMetadataServiceUri(this.baseConf.getMetadataServiceUri());
        }
        conf.setJournalDirName(journalDirs.getPath());
        conf.setLedgerDirNames(ledgerDirs);
        String fileName = BookieImpl.getBookieId(conf).toString() + ".conf";
        this.serializeLocalBookieConfig(conf, fileName);
        LocalBookie b = new LocalBookie(conf);
        b.start();
        this.localBookies.add(b);
    }

    private void setZooKeeperShim(ZooKeeperServerShim zks, File zkTmpDir) {
        this.zks = zks;
        this.dirsToCleanUp.add(zkTmpDir);
    }

    public static LocalBookKeeper getLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, ServerConfiguration conf) throws Exception {
        return LocalBookKeeper.getLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, true, "test", null, defaultLocalBookiesConfigDir);
    }

    private static LocalBookKeeper getLocalBookiesInternal(ServerConfiguration conf, String zkHost, int zkPort, int numBookies, boolean shouldStartZK, boolean stopOnExit, String dirSuffix, String zkDataDir, String localBookiesConfigDirName) throws Exception {
        conf.setMetadataServiceUri(LocalBookKeeper.newMetadataServiceUri(zkHost, zkPort, conf.getLedgerManagerLayoutStringFromFactoryClass(), conf.getZkLedgersRootPath()));
        LocalBookKeeper lb = new LocalBookKeeper(numBookies, conf, localBookiesConfigDirName, stopOnExit, dirSuffix, zkHost, zkPort);
        if (shouldStartZK) {
            File zkDataDirFile = null;
            if (zkDataDir != null) {
                zkDataDirFile = new File(zkDataDir);
                if (zkDataDirFile.exists() && zkDataDirFile.isFile()) {
                    throw new IOException("Unable to create zkDataDir, since there is a file at " + zkDataDirFile.getAbsolutePath());
                }
                if (!zkDataDirFile.exists() && !zkDataDirFile.mkdirs()) {
                    throw new IOException("Unable to create zkDataDir - " + zkDataDirFile.getAbsolutePath());
                }
            }
            File zkTmpDir = IOUtils.createTempDir("zookeeper", dirSuffix, zkDataDirFile);
            lb.setZooKeeperShim(LocalBookKeeper.runZookeeper(1000, zkPort, zkTmpDir), zkTmpDir);
        }
        return lb;
    }

    private void serializeLocalBookieConfig(ServerConfiguration localBookieConfig, String fileName) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileName) || fileName.contains("..") || fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Invalid filename: " + fileName);
        }
        File localBookieConfFile = new File(this.localBookiesConfigDir, fileName);
        if (localBookieConfFile.exists() && !localBookieConfFile.delete()) {
            throw new IOException("Unable to delete the existing LocalBookieConfigFile - " + localBookieConfFile.getAbsolutePath());
        }
        if (!localBookieConfFile.createNewFile()) {
            throw new IOException("Unable to create new File - " + localBookieConfFile.getAbsolutePath());
        }
        Iterator keys = localBookieConfig.getKeys();
        try (PrintWriter writer = new PrintWriter(localBookieConfFile, "UTF-8");){
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String[] values = localBookieConfig.getStringArray(key);
                StringBuilder concatenatedValue = new StringBuilder(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    concatenatedValue.append(",").append(values[i]);
                }
                writer.println(key + "=" + concatenatedValue);
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        try {
            if (args.length < 1) {
                LocalBookKeeper.usage();
                System.exit(-1);
            }
            int numBookies = 0;
            try {
                numBookies = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Unrecognized number-of-bookies: {}", (Object)args[0]);
                LocalBookKeeper.usage();
                System.exit(-1);
            }
            ServerConfiguration conf = new ServerConfiguration();
            conf.setAllowLoopback(true);
            if (args.length >= 2) {
                String confFile = args[1];
                try {
                    conf.loadConf(new File(confFile).toURI().toURL());
                    LOG.info("Using configuration file {}", (Object)confFile);
                }
                catch (Exception e) {
                    LOG.warn("Error loading configuration file {}", (Object)confFile, (Object)e);
                }
            }
            String zkDataDir = null;
            if (args.length >= 3) {
                zkDataDir = args[2];
            }
            String localBookiesConfigDirName = defaultLocalBookiesConfigDir;
            if (args.length >= 4) {
                localBookiesConfigDirName = args[3];
            }
            LocalBookKeeper lb = LocalBookKeeper.getLocalBookiesInternal(conf, zooKeeperDefaultHost, zooKeeperDefaultPort, numBookies, true, false, "test", zkDataDir, localBookiesConfigDirName);
            try {
                try {
                    lb.start();
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw ie;
                }
            }
            catch (Throwable throwable) {
                if (lb != null) {
                    try {
                        lb.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOG.error("Exiting LocalBookKeeper because of exception in main method", (Throwable)e);
            System.exit(-1);
            return;
        }
    }

    private static void usage() {
        System.err.println("Usage: LocalBookKeeper number-of-bookies [path to bookie config] [path to create ZK data directory at] [path to LocalBookiesConfigDir]");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try (Socket sock = new Socket(host, port);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), StandardCharsets.UTF_8));){
                OutputStream outstream = sock.getOutputStream();
                outstream.write("stat".getBytes(StandardCharsets.UTF_8));
                outstream.flush();
                String line = reader.readLine();
                if (line != null && line.startsWith("Zookeeper version:")) {
                    LOG.info("Server UP");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void start() throws Exception {
        this.initializeZookeeper();
        this.runBookies();
    }

    public void addBookie() throws Exception {
        int bookieIndex = this.localBookies.size() + 1;
        this.runBookie(bookieIndex);
    }

    public void removeBookie() throws Exception {
        int index = this.localBookies.size() - 1;
        LocalBookie bookie = this.localBookies.get(index);
        bookie.shutdown();
        this.localBookies.remove(index);
    }

    public void shutdownBookies() throws Exception {
        for (LocalBookie b : this.localBookies) {
            b.shutdown();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.stopOnExit) {
            this.shutdownBookies();
            if (null != this.zks) {
                this.zks.stop();
            }
        }
        LocalBookKeeper.cleanupDirectories(this.dirsToCleanUp);
    }

    private static BookieServiceInfo buildBookieServiceInfo(ComponentInfoPublisher componentInfoPublisher) {
        List<BookieServiceInfo.Endpoint> endpoints = componentInfoPublisher.getEndpoints().values().stream().map(e -> new BookieServiceInfo.Endpoint(e.getId(), e.getPort(), e.getHost(), e.getProtocol(), e.getAuth(), e.getExtensions())).collect(Collectors.toList());
        return new BookieServiceInfo(componentInfoPublisher.getProperties(), endpoints);
    }

    private class LocalBookie {
        final BookieServer server;
        final Bookie bookie;
        final MetadataBookieDriver metadataDriver;
        final RegistrationManager registrationManager;
        final LedgerManagerFactory lmFactory;
        final LedgerManager ledgerManager;

        LocalBookie(ServerConfiguration conf) throws Exception {
            this.metadataDriver = BookieResources.createMetadataDriver(conf, (StatsLogger)NullStatsLogger.INSTANCE);
            this.registrationManager = this.metadataDriver.createRegistrationManager();
            this.lmFactory = this.metadataDriver.getLedgerManagerFactory();
            this.ledgerManager = this.lmFactory.newLedgerManager();
            DiskChecker diskChecker = BookieResources.createDiskChecker(conf);
            LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager(conf, diskChecker, (StatsLogger)NullStatsLogger.INSTANCE);
            LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager(conf, diskChecker, (StatsLogger)NullStatsLogger.INSTANCE, ledgerDirsManager);
            LedgerStorage storage = BookieResources.createLedgerStorage(conf, this.ledgerManager, ledgerDirsManager, indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)LocalBookKeeper.this.allocator);
            UncleanShutdownDetectionImpl shutdownManager = new UncleanShutdownDetectionImpl(ledgerDirsManager);
            ComponentInfoPublisher componentInfoPublisher = new ComponentInfoPublisher();
            Supplier<BookieServiceInfo> bookieServiceInfoProvider = () -> LocalBookKeeper.buildBookieServiceInfo(componentInfoPublisher);
            componentInfoPublisher.startupFinished();
            this.bookie = new BookieImpl(conf, this.registrationManager, storage, diskChecker, ledgerDirsManager, indexDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)LocalBookKeeper.this.allocator, bookieServiceInfoProvider);
            this.server = new BookieServer(conf, this.bookie, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)LocalBookKeeper.this.allocator, shutdownManager);
        }

        void start() throws Exception {
            this.server.start();
        }

        void shutdown() throws Exception {
            this.server.shutdown();
            this.ledgerManager.close();
            this.lmFactory.close();
            this.registrationManager.close();
            this.metadataDriver.close();
        }
    }
}

