/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NIOServerCnxnFactoryTest {
    private InetSocketAddress listenAddress;
    private NIOServerCnxnFactory factory;

    @BeforeEach
    public void setUp() throws IOException {
        this.listenAddress = new InetSocketAddress(PortAssignment.unique());
        this.factory = new NIOServerCnxnFactory();
        this.factory.configure(this.listenAddress, 100);
    }

    @AfterEach
    public void tearDown() {
        if (this.factory != null) {
            this.factory.shutdown();
        }
    }

    @Test
    public void testStartupWithoutStart_SocketAlreadyBound() throws IOException {
        Assertions.assertThrows(SocketException.class, () -> {
            ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
        });
    }

    @Test
    public void testStartupWithStart_SocketAlreadyBound() throws IOException {
        Assertions.assertThrows(SocketException.class, () -> {
            this.factory.start();
            ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
        });
    }

    @Test
    public void testShutdownWithoutStart_SocketReleased() throws IOException {
        this.factory.shutdown();
        this.factory = null;
        ServerSocket ss = new ServerSocket(this.listenAddress.getPort());
        ss.close();
    }
}

