/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import jline.internal.Log;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509TestContext;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.embedded.ZookeeperServeInfo;
import org.apache.zookeeper.test.ClientBase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSSLReloadTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientSSLReloadTest.class);
    private X509TestContext x509TestContext1;
    private X509TestContext x509TestContext2;
    private File dir1;
    private File dir2;
    private File keyStoreFile1;
    private File trustStoreFile1;
    private File keyStoreFile2;
    private File trustStoreFile2;

    @BeforeEach
    public void setup() throws Exception {
        this.dir1 = ClientBase.createEmptyTestDir();
        this.dir2 = ClientBase.createEmptyTestDir();
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.x509TestContext1 = X509TestContext.newBuilder().setTempDir(this.dir1).setKeyStoreKeyType(X509KeyType.EC).setTrustStoreKeyType(X509KeyType.EC).build();
        this.x509TestContext2 = X509TestContext.newBuilder().setTempDir(this.dir2).setKeyStoreKeyType(X509KeyType.EC).setTrustStoreKeyType(X509KeyType.EC).build();
        this.keyStoreFile1 = this.x509TestContext1.getKeyStoreFile(KeyStoreFileType.PEM);
        this.trustStoreFile1 = this.x509TestContext1.getTrustStoreFile(KeyStoreFileType.PEM);
        this.keyStoreFile2 = this.x509TestContext2.getKeyStoreFile(KeyStoreFileType.PEM);
        this.trustStoreFile2 = this.x509TestContext2.getTrustStoreFile(KeyStoreFileType.PEM);
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
    }

    @AfterEach
    public void teardown() throws Exception {
        try {
            FileUtils.deleteDirectory((File)this.dir1);
            FileUtils.deleteDirectory((File)this.dir2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Security.removeProvider("BC");
    }

    @Test
    public void certficateReloadTest() throws Exception {
        Properties configZookeeper = this.getServerConfig();
        try (ZooKeeperServerEmbedded zkServer = ZooKeeperServerEmbedded.builder().baseDir(this.dir1.toPath()).configuration(configZookeeper).exitHandler(ExitHandler.LOG_ONLY).build();){
            ZookeeperServeInfo.ServerInfo status;
            zkServer.start();
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(zkServer.getConnectionString(), 60000L));
            for (int i = 0; !(i >= 100 || (status = ZookeeperServeInfo.getStatus("StandaloneServer*")).isLeader() && status.isStandaloneMode()); ++i) {
                Thread.sleep(100L);
            }
            ZookeeperServeInfo.ServerInfo status2 = ZookeeperServeInfo.getStatus("StandaloneServer*");
            Assertions.assertTrue((boolean)status2.isLeader());
            Assertions.assertTrue((boolean)status2.isStandaloneMode());
            CountDownLatch l = new CountDownLatch(1);
            ZKClientConfig zKClientConfig = this.getZKClientConfig();
            try (ZooKeeper zk = new ZooKeeper(zkServer.getSecureConnectionString(), 60000, event -> {
                switch (event.getState()) {
                    case SyncConnected: {
                        l.countDown();
                    }
                }
            }, zKClientConfig);){
                Assertions.assertTrue((boolean)zk.getClientConfig().getBoolean("zookeeper.client.secure"));
                Assertions.assertTrue((boolean)l.await(10L, TimeUnit.SECONDS));
            }
            Log.info((Object[])new Object[]{"Updating keyStore & trustStore files !!!!"});
            FileUtils.writeStringToFile((File)this.keyStoreFile1, (String)FileUtils.readFileToString((File)this.keyStoreFile2, (Charset)StandardCharsets.US_ASCII), (Charset)StandardCharsets.US_ASCII, (boolean)false);
            FileUtils.writeStringToFile((File)this.trustStoreFile1, (String)FileUtils.readFileToString((File)this.trustStoreFile2, (Charset)StandardCharsets.US_ASCII), (Charset)StandardCharsets.US_ASCII, (boolean)false);
            for (int i = 0; i < 5; ++i) {
                CountDownLatch l2 = new CountDownLatch(1);
                Thread.sleep(5000L);
                try (ZooKeeper zk = new ZooKeeper(zkServer.getSecureConnectionString(), 60000, event -> {
                    switch (event.getState()) {
                        case SyncConnected: {
                            l.countDown();
                        }
                    }
                }, zKClientConfig);){
                    if (l2.await(5L, TimeUnit.SECONDS)) continue;
                    LOG.error("Unable to connect to zk server");
                    break;
                }
            }
            zKClientConfig.setProperty("zookeeper.ssl.keyStore.location", this.keyStoreFile2.getAbsolutePath());
            zKClientConfig.setProperty("zookeeper.ssl.trustStore.location", this.trustStoreFile2.getAbsolutePath());
            zKClientConfig.setProperty("zookeeper.ssl.keyStore.type", "PEM");
            zKClientConfig.setProperty("zookeeper.ssl.trustStore.type", "PEM");
            CountDownLatch l3 = new CountDownLatch(1);
            try (ZooKeeper zk = new ZooKeeper(zkServer.getSecureConnectionString(), 60000, event -> {
                switch (event.getState()) {
                    case SyncConnected: {
                        l3.countDown();
                    }
                }
            }, zKClientConfig);){
                Assertions.assertTrue((boolean)zk.getClientConfig().getBoolean("zookeeper.client.secure"));
                Assertions.assertTrue((boolean)l3.await(10L, TimeUnit.SECONDS));
            }
        }
    }

    private Properties getServerConfig() {
        int clientPort = PortAssignment.unique();
        int clientSecurePort = PortAssignment.unique();
        Properties configZookeeper = new Properties();
        configZookeeper.put("clientPort", clientPort + "");
        configZookeeper.put("secureClientPort", clientSecurePort + "");
        configZookeeper.put("host", "localhost");
        configZookeeper.put("ticktime", "4000");
        configZookeeper.put("client.certReload", "true");
        configZookeeper.put("ssl.keyStore.location", this.keyStoreFile1.getAbsolutePath());
        configZookeeper.put("ssl.trustStore.location", this.trustStoreFile1.getAbsolutePath());
        configZookeeper.put("ssl.keyStore.type", "PEM");
        configZookeeper.put("ssl.trustStore.type", "PEM");
        configZookeeper.put("serverCnxnFactory", NettyServerCnxnFactory.class.getName());
        return configZookeeper;
    }

    private ZKClientConfig getZKClientConfig() throws IOException {
        File clientKeyStore = this.x509TestContext1.getKeyStoreFile(KeyStoreFileType.JKS);
        File clientTrustStore = this.x509TestContext1.getTrustStoreFile(KeyStoreFileType.JKS);
        ZKClientConfig zKClientConfig = new ZKClientConfig();
        zKClientConfig.setProperty("zookeeper.client.secure", "true");
        zKClientConfig.setProperty("zookeeper.ssl.keyStore.location", clientKeyStore.getAbsolutePath());
        zKClientConfig.setProperty("zookeeper.ssl.trustStore.location", clientTrustStore.getAbsolutePath());
        zKClientConfig.setProperty("zookeeper.ssl.keyStore.type", "JKS");
        zKClientConfig.setProperty("zookeeper.ssl.trustStore.type", "JKS");
        zKClientConfig.setProperty("zookeeper.clientCnxnSocket", ClientCnxnSocketNetty.class.getName());
        return zKClientConfig;
    }
}

