/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.util.ArrayList;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneTest
extends QuorumPeerTestBase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(StandaloneTest.class);

    @BeforeEach
    public void setup() {
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
    }

    @Test
    public void testNoDynamicConfig() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(-1, CLIENT_PORT, "", false);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    @Test
    public void testClientPortInDynamicFile() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;" + CLIENT_PORT + "\n";
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(1, quorumCfgSection);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    @Test
    public void testClientPortInStaticFile() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String quorumCfgSection = "server.1=127.0.0.1:" + PortAssignment.unique() + ":" + PortAssignment.unique() + ":participant;" + CLIENT_PORT + "\n";
        QuorumPeerTestBase.MainThread mt = new QuorumPeerTestBase.MainThread(1, quorumCfgSection, false);
        this.verifyStandalone(mt, CLIENT_PORT);
    }

    void verifyStandalone(QuorumPeerTestBase.MainThread mt, int clientPort) throws InterruptedException {
        mt.start();
        try {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server 1 being up");
        }
        finally {
            Assertions.assertFalse((boolean)mt.isQuorumPeerRunning(), (String)"Error- MainThread started in Quorum Mode!");
            mt.shutdown();
        }
    }

    @Test
    public void testStandaloneReconfigFails() throws Exception {
        ClientBase.setupTestEnv();
        int CLIENT_PORT = PortAssignment.unique();
        String HOSTPORT = "127.0.0.1:" + CLIENT_PORT;
        File tmpDir = ClientBase.createTmpDir();
        ZooKeeperServer zks = new ZooKeeperServer(tmpDir, tmpDir, 3000);
        ServerCnxnFactory f = ServerCnxnFactory.createFactory((int)CLIENT_PORT, (int)-1);
        f.startup(zks);
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being up ");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        ZooKeeperAdmin zkAdmin = new ZooKeeperAdmin(HOSTPORT, ClientBase.CONNECTION_TIMEOUT, (Watcher)watcher);
        watcher.waitForConnected(ClientBase.CONNECTION_TIMEOUT);
        ArrayList<String> joiners = new ArrayList<String>();
        joiners.add("server.2=localhost:1234:1235;1236");
        try {
            zkAdmin.addAuthInfo("digest", "super:test".getBytes());
            zkAdmin.reconfigure(joiners, null, null, -1L, new Stat());
            Assertions.fail((String)"Reconfiguration in standalone should trigger UnimplementedException");
        }
        catch (KeeperException.UnimplementedException unimplementedException) {
            // empty catch block
        }
        zk.close();
        zks.shutdown();
        f.shutdown();
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown(HOSTPORT, ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server being down ");
    }
}

