/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.jute.Record;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.SetDataTxn;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ZooKeeperServerBeanTest {
    @BeforeEach
    public void setup() {
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
    }

    @AfterEach
    public void teardown() throws Exception {
        System.clearProperty("zookeeper.serverCnxnFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTxnLogElapsedSyncTime() throws IOException {
        File tmpDir = ClientBase.createEmptyTestDir();
        FileTxnSnapLog fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZooKeeperServer zks = new ZooKeeperServer();
        zks.setTxnLogFactory(fileTxnSnapLog);
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        long elapsedTime = serverBean.getTxnLogElapsedSyncTime();
        Assertions.assertEquals((long)-1L, (long)elapsedTime);
        TxnHeader hdr = new TxnHeader(1L, 1, 1L, 1L, 5);
        SetDataTxn txn = new SetDataTxn("/foo", new byte[0], 1);
        Request req = new Request(0L, 0, 0, hdr, (Record)txn, 0L);
        try {
            zks.getTxnLogFactory().append(req);
            zks.getTxnLogFactory().commit();
            elapsedTime = serverBean.getTxnLogElapsedSyncTime();
            Assertions.assertNotEquals((long)-1L, (long)elapsedTime);
            Assertions.assertEquals((long)elapsedTime, (long)serverBean.getTxnLogElapsedSyncTime());
        }
        finally {
            fileTxnSnapLog.close();
        }
    }

    @Test
    public void testGetSecureClientPort() throws IOException {
        ZooKeeperServer zks = new ZooKeeperServer();
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        String result = serverBean.getSecureClientPort();
        Assertions.assertEquals((Object)"", (Object)result);
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        int secureClientPort = 8443;
        InetSocketAddress address = new InetSocketAddress(secureClientPort);
        cnxnFactory.configure(address, 5, -1, true);
        zks.setSecureServerCnxnFactory(cnxnFactory);
        result = serverBean.getSecureClientPort();
        Assertions.assertEquals((Object)Integer.toString(secureClientPort), (Object)result);
        cnxnFactory.shutdown();
    }

    @Test
    public void testGetSecureClientAddress() throws IOException {
        ZooKeeperServer zks = new ZooKeeperServer();
        ZooKeeperServerBean serverBean = new ZooKeeperServerBean(zks);
        String result = serverBean.getSecureClientPort();
        Assertions.assertEquals((Object)"", (Object)result);
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        int secureClientPort = 8443;
        InetSocketAddress address = new InetSocketAddress(secureClientPort);
        cnxnFactory.configure(address, 5, -1, true);
        zks.setSecureServerCnxnFactory(cnxnFactory);
        result = serverBean.getSecureClientAddress();
        String ipv4 = "0.0.0.0:" + secureClientPort;
        String ipv6 = "0:0:0:0:0:0:0:0:" + secureClientPort;
        Assertions.assertTrue((result.equals(ipv4) || result.equals(ipv6) ? 1 : 0) != 0);
        cnxnFactory.shutdown();
    }
}

