/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.zookeeper.PortAssignment;

public class QuorumServerConfigBuilder {
    private final Map<Integer, Integer> clientIds = new HashMap<Integer, Integer>();
    private final Map<Integer, List<ServerAddress>> serverAddresses = new HashMap<Integer, List<ServerAddress>>();
    private final String hostName;
    private final int numberOfServers;

    public QuorumServerConfigBuilder(String hostName, int numberOfServers, int numberOfServerAddresses) {
        this.numberOfServers = numberOfServers;
        this.hostName = hostName;
        for (int serverId = 0; serverId < numberOfServers; ++serverId) {
            this.clientIds.put(serverId, PortAssignment.unique());
            ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
            this.serverAddresses.put(serverId, addresses);
            for (int serverAddressId = 0; serverAddressId < numberOfServerAddresses; ++serverAddressId) {
                addresses.add(new ServerAddress(hostName));
            }
        }
    }

    public QuorumServerConfigBuilder(QuorumServerConfigBuilder otherBuilder) {
        this.numberOfServers = otherBuilder.clientIds.size();
        this.clientIds.putAll(otherBuilder.clientIds);
        this.hostName = otherBuilder.hostName;
        for (int i : otherBuilder.serverAddresses.keySet()) {
            List clonedServerAddresses = otherBuilder.serverAddresses.get(i).stream().map(ServerAddress::clone).collect(Collectors.toList());
            this.serverAddresses.put(i, clonedServerAddresses);
        }
    }

    public int getClientPort(int serverId) {
        return this.clientIds.get(serverId);
    }

    public ServerAddress getServerAddress(int serverId, int addressId) {
        return this.serverAddresses.get(serverId).get(addressId);
    }

    public QuorumServerConfigBuilder changeHostName(int serverId, int addressId, String hostName) {
        this.serverAddresses.get(serverId).get(addressId).setHost(hostName);
        return this;
    }

    public QuorumServerConfigBuilder changeQuorumPort(int serverId, int addressId, int quorumPort) {
        this.serverAddresses.get(serverId).get(addressId).setQuorumPort(quorumPort);
        return this;
    }

    public QuorumServerConfigBuilder changeElectionPort(int serverId, int addressId, int electionPort) {
        this.serverAddresses.get(serverId).get(addressId).setElectionPort(electionPort);
        return this;
    }

    public QuorumServerConfigBuilder addNewServerAddress(int serverId) {
        this.serverAddresses.get(serverId).add(new ServerAddress(this.hostName));
        return this;
    }

    public QuorumServerConfigBuilder deleteLastServerAddress(int serverId) {
        this.serverAddresses.get(serverId).remove(this.serverAddresses.get(serverId).size() - 1);
        return this;
    }

    public String build() {
        return String.join((CharSequence)"\n", this.buildAsStringList());
    }

    public List<String> buildAsStringList() {
        ArrayList<String> result = new ArrayList<String>(this.numberOfServers);
        for (int serverId = 0; serverId < this.numberOfServers; ++serverId) {
            String s = this.serverAddresses.get(serverId).stream().map(ServerAddress::toString).collect(Collectors.joining("|"));
            result.add(String.format("server.%d=%s;%d", serverId, s, this.clientIds.get(serverId)));
        }
        return result;
    }

    public static class ServerAddress {
        private String host;
        private int quorumPort;
        private int electionPort;

        private ServerAddress(String host) {
            this(host, PortAssignment.unique(), PortAssignment.unique());
        }

        private ServerAddress(String host, int quorumPort, int electionPort) {
            this.host = host;
            this.quorumPort = quorumPort;
            this.electionPort = electionPort;
        }

        public String getHost() {
            return this.host;
        }

        private void setHost(String host) {
            this.host = host;
        }

        private void setQuorumPort(int quorumPort) {
            this.quorumPort = quorumPort;
        }

        private void setElectionPort(int electionPort) {
            this.electionPort = electionPort;
        }

        public ServerAddress clone() {
            return new ServerAddress(this.host, this.quorumPort, this.electionPort);
        }

        public String toString() {
            return String.format("%s:%d:%d", this.host, this.quorumPort, this.electionPort);
        }
    }
}

