/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.op;

import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import org.apache.bookkeeper.api.kv.op.CompareOp;
import org.apache.bookkeeper.api.kv.op.CompareResult;
import org.apache.bookkeeper.api.kv.op.CompareTarget;

class CompareOpImpl<K, V>
implements CompareOp<K, V> {
    private final Recycler.Handle<CompareOpImpl<K, V>> handle;
    private CompareTarget target;
    private CompareResult result;
    private K key;
    private V value;
    private long revision;

    CompareOpImpl(Recycler.Handle<CompareOpImpl<K, V>> handle) {
        this.handle = handle;
    }

    CompareOpImpl<K, V> key(K key) {
        ReferenceCountUtil.release(this.key);
        this.key = ReferenceCountUtil.retain(key);
        return this;
    }

    CompareOpImpl<K, V> value(V value) {
        ReferenceCountUtil.release(this.value);
        this.value = ReferenceCountUtil.retain(value);
        return this;
    }

    @Override
    public void close() {
        this.target = null;
        this.result = null;
        ReferenceCountUtil.release(this.key);
        this.key = null;
        ReferenceCountUtil.release(this.value);
        this.value = null;
        this.revision = -1L;
    }

    public Recycler.Handle<CompareOpImpl<K, V>> handle() {
        return this.handle;
    }

    @Override
    public CompareTarget target() {
        return this.target;
    }

    @Override
    public CompareResult result() {
        return this.result;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public long revision() {
        return this.revision;
    }

    CompareOpImpl<K, V> target(CompareTarget target) {
        this.target = target;
        return this;
    }

    CompareOpImpl<K, V> result(CompareResult result) {
        this.result = result;
        return this;
    }

    CompareOpImpl<K, V> revision(long revision) {
        this.revision = revision;
        return this;
    }

    public String toString() {
        return "CompareOpImpl(target=" + (Object)((Object)this.target()) + ", result=" + (Object)((Object)this.result()) + ", key=" + this.key() + ", value=" + this.value() + ", revision=" + this.revision() + ")";
    }
}

