/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.Time;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;

public class ZooKeeperTestClient
extends ZKTestCase
implements Watcher {
    protected String hostPort = "127.0.0.1:22801";
    protected static final String dirOnZK = "/test_dir";
    protected String testDirOnZK = "/test_dir/" + Time.currentElapsedTime();
    LinkedBlockingQueue<WatchedEvent> events = new LinkedBlockingQueue();

    private WatchedEvent getEvent(int numTries) throws InterruptedException {
        WatchedEvent event = null;
        for (int i = 0; i < numTries; ++i) {
            System.out.println("i = " + i);
            event = this.events.poll(10L, TimeUnit.SECONDS);
            if (event != null) break;
            Thread.sleep(5000L);
        }
        return event;
    }

    private void deleteZKDir(ZooKeeper zk, String nodeName) throws IOException, InterruptedException, KeeperException {
        List c2;
        Stat stat = zk.exists(nodeName, false);
        if (stat == null) {
            return;
        }
        List children1 = zk.getChildren(nodeName, false);
        if (!children1.equals(c2 = zk.getChildren(nodeName, false, stat))) {
            Assertions.fail((String)"children lists from getChildren()/getChildren2() do not match");
        }
        if (!stat.equals((Object)stat)) {
            Assertions.fail((String)"stats from exists()/getChildren2() do not match");
        }
        if (children1.size() == 0) {
            zk.delete(nodeName, -1);
            return;
        }
        for (String n : children1) {
            this.deleteZKDir(zk, n);
        }
    }

    private void checkRoot() throws IOException, InterruptedException {
        ZooKeeper zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
        try {
            zk.create(dirOnZK, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
        }
        catch (KeeperException ke) {
            Assertions.fail((String)("Unexpected exception code for create /test_dir: " + ke.getMessage()));
        }
        try {
            zk.create(this.testDirOnZK, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException ke) {
        }
        catch (KeeperException ke) {
            Assertions.fail((String)("Unexpected exception code for create " + this.testDirOnZK + ": " + ke.getMessage()));
        }
        zk.close();
    }

    private void enode_test_1() throws IOException, InterruptedException, KeeperException {
        Stat stat;
        ZooKeeper zk;
        String nodeName;
        block8: {
            this.checkRoot();
            String parentName = this.testDirOnZK;
            nodeName = parentName + "/enode_abc";
            zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
            stat = zk.exists(parentName, false);
            if (stat == null) {
                try {
                    zk.create(parentName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException ke) {
                    Assertions.fail((String)("Creating node " + parentName + ke.getMessage()));
                }
            }
            try {
                zk.create(nodeName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            catch (KeeperException ke) {
                boolean valid;
                KeeperException.Code code = ke.code();
                boolean bl = valid = code == KeeperException.Code.NODEEXISTS;
                if (valid) break block8;
                Assertions.fail((String)("Unexpected exception code for createin: " + ke.getMessage()));
            }
        }
        stat = zk.exists(nodeName, false);
        if (stat == null) {
            Assertions.fail((String)("node " + nodeName + " should exist"));
        }
        System.out.println("Closing client with sessionid: 0x" + Long.toHexString(zk.getSessionId()));
        zk.close();
        zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
        for (int i = 0; i < 10; ++i) {
            System.out.println("i = " + i);
            stat = zk.exists(nodeName, false);
            if (stat == null) {
                System.out.println("node " + nodeName + " is gone after reconnection close!");
                break;
            }
            System.out.println("node " + nodeName + " should not exist after reconnection close");
            Thread.sleep(5000L);
        }
        this.deleteZKDir(zk, nodeName);
        zk.close();
    }

    private void enode_test_2() throws IOException, InterruptedException, KeeperException {
        WatchedEvent event;
        List firstGen2;
        List firstGen1;
        Stat stat_node;
        ZooKeeper zk_1;
        ZooKeeper zk;
        String nodeName;
        String parentName;
        block33: {
            boolean valid;
            block32: {
                block31: {
                    block30: {
                        Stat stat;
                        Stat stat_parent;
                        block29: {
                            this.checkRoot();
                            parentName = this.testDirOnZK;
                            nodeName = parentName + "/enode_abc";
                            zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
                            zk_1 = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
                            stat_parent = zk_1.exists(parentName, false);
                            if (stat_parent == null) {
                                try {
                                    zk.create(parentName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                                }
                                catch (KeeperException ke) {
                                    Assertions.fail((String)("Creating node " + parentName + ke.getMessage()));
                                }
                            }
                            if ((stat_node = zk_1.exists(nodeName, false)) != null) {
                                try {
                                    zk.delete(nodeName, -1);
                                }
                                catch (KeeperException ke) {
                                    boolean valid2;
                                    KeeperException.Code code = ke.code();
                                    boolean bl = valid2 = code == KeeperException.Code.NONODE || code == KeeperException.Code.NOTEMPTY;
                                    if (valid2) break block29;
                                    Assertions.fail((String)("Unexpected exception code for delete: " + ke.getMessage()));
                                }
                            }
                        }
                        if (!(firstGen1 = zk_1.getChildren(parentName, true)).equals(firstGen2 = zk_1.getChildren(parentName, true, stat = new Stat()))) {
                            Assertions.fail((String)"children lists from getChildren()/getChildren2() do not match");
                        }
                        if (!stat_parent.equals((Object)stat)) {
                            Assertions.fail((String)"stat from exists()/getChildren() do not match");
                        }
                        try {
                            zk.create(nodeName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        }
                        catch (KeeperException ke) {
                            boolean valid3;
                            KeeperException.Code code = ke.code();
                            boolean bl = valid3 = code == KeeperException.Code.NODEEXISTS;
                            if (valid3) break block30;
                            Assertions.fail((String)("Unexpected exception code for createin: " + ke.getMessage()));
                        }
                    }
                    Thread.sleep(5000L);
                    event = this.events.poll(10L, TimeUnit.SECONDS);
                    if (event == null) {
                        throw new IOException("No event was delivered promptly");
                    }
                    if (event.getType() != Watcher.Event.EventType.NodeChildrenChanged || !event.getPath().equalsIgnoreCase(parentName)) {
                        Assertions.fail((String)("Unexpected event was delivered: " + event.toString()));
                    }
                    if ((stat_node = zk_1.exists(nodeName, false)) == null) {
                        Assertions.fail((String)("node " + nodeName + " should exist"));
                    }
                    try {
                        zk.delete(parentName, -1);
                        Assertions.fail((String)("Should be impossible to delete a non-empty node " + parentName));
                    }
                    catch (KeeperException ke) {
                        KeeperException.Code code = ke.code();
                        boolean bl = valid = code == KeeperException.Code.NOTEMPTY;
                        if (valid) break block31;
                        Assertions.fail((String)("Unexpected exception code for delete: " + code));
                    }
                }
                try {
                    zk.create(nodeName + "/def", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                    Assertions.fail((String)("Should be impossible to create child off Ephemeral node " + nodeName));
                }
                catch (KeeperException ke) {
                    KeeperException.Code code = ke.code();
                    boolean bl = valid = code == KeeperException.Code.NOCHILDRENFOREPHEMERALS;
                    if (valid) break block32;
                    Assertions.fail((String)("Unexpected exception code for createin: " + code));
                }
            }
            try {
                List children1 = zk.getChildren(nodeName, false);
                List children2 = zk.getChildren(nodeName, false, null);
                if (!children1.equals(children2)) {
                    Assertions.fail((String)"children lists from getChildren()/getChildren2() does not match");
                }
                if (children1.size() > 0) {
                    Assertions.fail((String)("ephemeral node " + nodeName + " should not have children"));
                }
            }
            catch (KeeperException ke) {
                KeeperException.Code code = ke.code();
                boolean bl = valid = code == KeeperException.Code.NONODE;
                if (valid) break block33;
                Assertions.fail((String)("Unexpected exception code for createin: " + code));
            }
        }
        firstGen1 = zk_1.getChildren(parentName, true);
        firstGen2 = zk_1.getChildren(parentName, true, null);
        if (!firstGen1.equals(firstGen2)) {
            Assertions.fail((String)"children list from getChildren()/getChildren2() does not match");
        }
        if ((stat_node = zk_1.exists(nodeName, true)) == null) {
            Assertions.fail((String)("node " + nodeName + " should exist"));
        }
        System.out.println("session id of zk: " + zk.getSessionId());
        System.out.println("session id of zk_1: " + zk_1.getSessionId());
        zk.close();
        zk_1.exists("nosuchnode", false);
        event = this.getEvent(10);
        if (event == null) {
            throw new Error("First event was not delivered promptly");
        }
        if (!(event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equalsIgnoreCase(parentName) || event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equalsIgnoreCase(nodeName))) {
            System.out.print(parentName + " " + Watcher.Event.EventType.NodeChildrenChanged + " " + nodeName + " " + Watcher.Event.EventType.NodeDeleted);
            Assertions.fail((String)("Unexpected first event was delivered: " + event.toString()));
        }
        if ((event = this.getEvent(10)) == null) {
            throw new Error("Second event was not delivered promptly");
        }
        if (!(event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equalsIgnoreCase(parentName) || event.getType() == Watcher.Event.EventType.NodeDeleted && event.getPath().equalsIgnoreCase(nodeName))) {
            System.out.print(parentName + " " + Watcher.Event.EventType.NodeChildrenChanged + " " + nodeName + " " + Watcher.Event.EventType.NodeDeleted);
            Assertions.fail((String)("Unexpected second event was delivered: " + event.toString()));
        }
        firstGen1 = zk_1.getChildren(parentName, false);
        stat_node = zk_1.exists(nodeName, false);
        if (stat_node != null) {
            Assertions.fail((String)("node " + nodeName + " should have been deleted"));
        }
        if (firstGen1.contains(nodeName)) {
            Assertions.fail((String)("node " + nodeName + " should not be a children"));
        }
        this.deleteZKDir(zk_1, nodeName);
        zk_1.close();
    }

    private void delete_create_get_set_test_1() throws IOException, InterruptedException, KeeperException {
        String nodeName;
        ZooKeeper zk;
        block15: {
            boolean valid;
            KeeperException.Code code;
            block14: {
                block13: {
                    block12: {
                        boolean valid2;
                        KeeperException.Code code2;
                        block11: {
                            this.checkRoot();
                            zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
                            String parentName = this.testDirOnZK;
                            nodeName = parentName + "/benwashere";
                            try {
                                zk.delete(nodeName, -1);
                            }
                            catch (KeeperException ke) {
                                code2 = ke.code();
                                boolean bl = valid2 = code2 == KeeperException.Code.NONODE || code2 == KeeperException.Code.NOTEMPTY;
                                if (valid2) break block11;
                                Assertions.fail((String)("Unexpected exception code for delete: " + ke.getMessage()));
                            }
                        }
                        try {
                            zk.create(nodeName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        }
                        catch (KeeperException ke) {
                            code2 = ke.code();
                            boolean bl = valid2 = code2 == KeeperException.Code.NODEEXISTS;
                            if (valid2) break block12;
                            Assertions.fail((String)("Unexpected exception code for create: " + ke.getMessage()));
                        }
                    }
                    try {
                        zk.setData(nodeName, "hi".getBytes(), 5700);
                        Assertions.fail((String)"Should have gotten BadVersion exception");
                    }
                    catch (KeeperException ke) {
                        if (ke.code() == KeeperException.Code.BADVERSION) break block13;
                        Assertions.fail((String)"Should have gotten BadVersion exception");
                    }
                }
                zk.setData(nodeName, "hi".getBytes(), -1);
                Stat st = new Stat();
                byte[] bytes = zk.getData(nodeName, false, st);
                String retrieved = new String(bytes);
                if (!"hi".equals(retrieved)) {
                    Assertions.fail((String)("The retrieved data [" + retrieved + "] is differented than the expected [hi]"));
                }
                try {
                    zk.delete(nodeName, 6800);
                    Assertions.fail((String)"Should have gotten BadVersion exception");
                }
                catch (KeeperException ke) {
                    code = ke.code();
                    boolean bl = valid = code == KeeperException.Code.NOTEMPTY || code == KeeperException.Code.BADVERSION;
                    if (valid) break block14;
                    Assertions.fail((String)("Unexpected exception code for delete: " + ke.getMessage()));
                }
            }
            try {
                zk.delete(nodeName, -1);
            }
            catch (KeeperException ke) {
                code = ke.code();
                boolean bl = valid = code == KeeperException.Code.NOTEMPTY;
                if (valid) break block15;
                Assertions.fail((String)("Unexpected exception code for delete: " + code));
            }
        }
        this.deleteZKDir(zk, nodeName);
        zk.close();
    }

    private void deleteNodeIfExists(ZooKeeper zk, String nodeName) throws InterruptedException {
        block2: {
            try {
                zk.delete(nodeName, -1);
            }
            catch (KeeperException ke) {
                boolean valid;
                KeeperException.Code code = ke.code();
                boolean bl = valid = code == KeeperException.Code.NONODE || code == KeeperException.Code.NOTEMPTY;
                if (valid) break block2;
                Assertions.fail((String)("Unexpected exception code for delete: " + ke.getMessage()));
            }
        }
    }

    private void create_get_stat_test() throws IOException, InterruptedException, KeeperException {
        this.checkRoot();
        ZooKeeper zk = new ZooKeeper(this.hostPort, 10000, (Watcher)this);
        String parentName = this.testDirOnZK;
        String nodeName = parentName + "/create_with_stat_tmp";
        this.deleteNodeIfExists(zk, nodeName);
        this.deleteNodeIfExists(zk, nodeName + "_2");
        Stat stat = new Stat();
        zk.create(nodeName, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat);
        Assertions.assertNotNull((Object)stat);
        Assertions.assertTrue((stat.getCzxid() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((stat.getCtime() > 0L ? 1 : 0) != 0);
        Stat stat2 = new Stat();
        zk.create(nodeName + "_2", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, stat2);
        Assertions.assertNotNull((Object)stat2);
        Assertions.assertTrue((stat2.getCzxid() > stat.getCzxid() ? 1 : 0) != 0);
        Assertions.assertTrue((stat2.getCtime() > stat.getCtime() ? 1 : 0) != 0);
        this.deleteNodeIfExists(zk, nodeName);
        this.deleteNodeIfExists(zk, nodeName + "_2");
        zk.close();
    }

    public void my_test_1() throws IOException, InterruptedException, KeeperException {
        this.enode_test_1();
        this.enode_test_2();
        this.delete_create_get_set_test_1();
        this.create_get_stat_test();
    }

    public synchronized void process(WatchedEvent event) {
        try {
            System.out.println("Got an event " + event.toString());
            this.events.put(event);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ZooKeeperTestClient zktc = new ZooKeeperTestClient();
        try {
            zktc.my_test_1();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

