/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.coder;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Serializable;

public interface Coder<T>
extends Serializable {
    default public ByteBuf encodeBuf(T value) {
        int len = this.getSerializedSize(value);
        ByteBuf buffer = Unpooled.buffer((int)len, (int)len);
        buffer.setIndex(0, 0);
        this.encode(value, buffer);
        return buffer;
    }

    default public byte[] encode(T value) {
        byte[] data = new byte[this.getSerializedSize(value)];
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        buf.setIndex(0, 0);
        this.encode(value, buf);
        return data;
    }

    public void encode(T var1, ByteBuf var2);

    public int getSerializedSize(T var1);

    public T decode(ByteBuf var1);

    default public T decode(byte[] data) {
        return this.decode(Unpooled.wrappedBuffer((byte[])data));
    }
}

