/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.QuorumBase;
import org.apache.zookeeper.test.ThrottledOpHelper;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ThrottledOpQuorumTest
extends QuorumBase {
    @BeforeAll
    public static void applyMockUps() {
        ThrottledOpHelper.applyMockUps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrottledOpLeader() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = null;){
            zk = this.createClient("localhost:" + this.getLeaderClientPort());
            ZooKeeperServer zs = this.getLeaderQuorumPeer().getActiveServer();
            ThrottledOpHelper test = new ThrottledOpHelper();
            test.testThrottledOp((ZooKeeper)zk, zs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrottledAclLeader() throws Exception {
        try (TestableZooKeeper zk = null;){
            zk = this.createClient("localhost:" + this.getLeaderClientPort());
            ZooKeeperServer zs = this.getLeaderQuorumPeer().getActiveServer();
            ThrottledOpHelper test = new ThrottledOpHelper();
            test.testThrottledAcl((ZooKeeper)zk, zs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrottledOpFollower() throws IOException, InterruptedException, KeeperException {
        try (TestableZooKeeper zk = null;){
            int clientPort = this.getLeaderClientPort() == this.portClient1 ? this.portClient2 : this.portClient1;
            zk = this.createClient("localhost:" + clientPort);
            QuorumPeer qp = this.getLeaderClientPort() == this.portClient1 ? this.s2 : this.s1;
            ZooKeeperServer zs = qp.getActiveServer();
            ThrottledOpHelper test = new ThrottledOpHelper();
            test.testThrottledOp((ZooKeeper)zk, zs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrottledAclFollower() throws Exception {
        try (TestableZooKeeper zk = null;){
            int clientPort = this.getLeaderClientPort() == this.portClient1 ? this.portClient2 : this.portClient1;
            zk = this.createClient("localhost:" + clientPort);
            QuorumPeer qp = this.getLeaderClientPort() == this.portClient1 ? this.s2 : this.s1;
            ZooKeeperServer zs = qp.getActiveServer();
            ThrottledOpHelper test = new ThrottledOpHelper();
            test.testThrottledAcl((ZooKeeper)zk, zs);
        }
    }
}

