/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.bookkeeper.bookie.AbstractLogCompactor;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.BufferedChannelBase;
import org.apache.bookkeeper.bookie.BufferedReadChannel;
import org.apache.bookkeeper.bookie.EntryLogManager;
import org.apache.bookkeeper.bookie.EntryLogManagerForEntryLogPerLedger;
import org.apache.bookkeeper.bookie.EntryLogManagerForSingleEntryLog;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.EntryLoggerAllocator;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.CompactionEntryLog;
import org.apache.bookkeeper.bookie.storage.EntryLogScanner;
import org.apache.bookkeeper.bookie.storage.EntryLogger;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.HardLink;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.collections.ConcurrentLongLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntryLogger
implements EntryLogger {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntryLogger.class);
    @VisibleForTesting
    static final int UNINITIALIZED_LOG_ID = -57005;
    private final LedgerDirsManager ledgerDirsManager;
    private final boolean entryLogPerLedgerEnabled;
    final RecentEntryLogsStatus recentlyCreatedEntryLogsStatus;
    private final Object compactionLogLock = new Object();
    private volatile BufferedLogChannel compactionLogChannel;
    final EntryLoggerAllocator entryLoggerAllocator;
    private final EntryLogManager entryLogManager;
    private final CopyOnWriteArrayList<EntryLogListener> listeners = new CopyOnWriteArrayList();
    private static final int HEADER_V0 = 0;
    private static final int HEADER_V1 = 1;
    static final int HEADER_CURRENT_VERSION = 1;
    static final int LOGFILE_HEADER_SIZE = 1024;
    final ByteBuf logfileHeader = Unpooled.buffer((int)1024);
    static final int HEADER_VERSION_POSITION = 4;
    static final int LEDGERS_MAP_OFFSET_POSITION = 8;
    static final int LEDGERS_MAP_HEADER_SIZE = 24;
    static final int LEDGERS_MAP_ENTRY_SIZE = 16;
    static final int LEDGERS_MAP_MAX_BATCH_SIZE = 10000;
    static final long INVALID_LID = -1L;
    static final long LEDGERS_MAP_ENTRY_ID = -2L;
    static final int MIN_SANE_ENTRY_SIZE = 16;
    static final long MB = 0x100000L;
    private final int maxSaneEntrySize;
    private final ByteBufAllocator allocator;
    final ServerConfiguration conf;
    private final ThreadLocal<Map<Long, BufferedReadChannel>> logid2Channel = new ThreadLocal<Map<Long, BufferedReadChannel>>(){

        @Override
        public Map<Long, BufferedReadChannel> initialValue() {
            return new MapMaker().concurrencyLevel(1).weakValues().makeMap();
        }
    };
    private final ConcurrentMap<Long, FileChannel> logid2FileChannel = new ConcurrentHashMap<Long, FileChannel>();
    private final FastThreadLocal<ByteBuf> sizeBuffer = new FastThreadLocal<ByteBuf>(){

        protected ByteBuf initialValue() throws Exception {
            return Unpooled.buffer((int)20);
        }
    };

    public DefaultEntryLogger(ServerConfiguration conf) throws IOException {
        this(conf, new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold())));
    }

    public DefaultEntryLogger(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager) throws IOException {
        this(conf, ledgerDirsManager, null, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    public DefaultEntryLogger(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, EntryLogListener listener, StatsLogger statsLogger, ByteBufAllocator allocator) throws IOException {
        this.maxSaneEntrySize = conf.getNettyMaxFrameSizeBytes() - 500;
        this.allocator = allocator;
        this.ledgerDirsManager = ledgerDirsManager;
        this.conf = conf;
        this.entryLogPerLedgerEnabled = conf.isEntryLogPerLedgerEnabled();
        if (listener != null) {
            this.addListener(listener);
        }
        this.logfileHeader.writeBytes("BKLO".getBytes(StandardCharsets.UTF_8));
        this.logfileHeader.writeInt(1);
        this.logfileHeader.writerIndex(1024);
        long logId = -1L;
        for (File dir : ledgerDirsManager.getAllLedgerDirs()) {
            if (!dir.exists()) {
                throw new FileNotFoundException("Entry log directory '" + dir + "' does not exist");
            }
            long lastLogId = this.getLastLogId(dir);
            if (lastLogId <= logId) continue;
            logId = lastLogId;
        }
        this.recentlyCreatedEntryLogsStatus = new RecentEntryLogsStatus(logId + 1L);
        this.entryLoggerAllocator = new EntryLoggerAllocator(conf, ledgerDirsManager, this.recentlyCreatedEntryLogsStatus, logId, allocator);
        this.entryLogManager = this.entryLogPerLedgerEnabled ? new EntryLogManagerForEntryLogPerLedger(conf, ledgerDirsManager, this.entryLoggerAllocator, this.listeners, this.recentlyCreatedEntryLogsStatus, statsLogger) : new EntryLogManagerForSingleEntryLog(conf, ledgerDirsManager, this.entryLoggerAllocator, this.listeners, this.recentlyCreatedEntryLogsStatus);
    }

    EntryLogManager getEntryLogManager() {
        return this.entryLogManager;
    }

    void addListener(EntryLogListener listener) {
        if (null != listener) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readFromLogChannel(long entryLogId, BufferedReadChannel channel, ByteBuf buff, long pos) throws IOException {
        BufferedLogChannel bc = this.entryLogManager.getCurrentLogIfPresent(entryLogId);
        if (null != bc) {
            BufferedLogChannel bufferedLogChannel = bc;
            synchronized (bufferedLogChannel) {
                if (pos + (long)buff.writableBytes() >= bc.getFileChannelPosition()) {
                    return bc.read(buff, pos);
                }
            }
        }
        return channel.read(buff, pos);
    }

    public BufferedReadChannel putInReadChannels(long logId, BufferedReadChannel bc) {
        Map<Long, BufferedReadChannel> threadMap = this.logid2Channel.get();
        return threadMap.put(logId, bc);
    }

    public void removeFromChannelsAndClose(long logId) {
        FileChannel fileChannel = (FileChannel)this.logid2FileChannel.remove(logId);
        if (null != fileChannel) {
            try {
                fileChannel.close();
            }
            catch (IOException e) {
                LOG.warn("Exception while closing channel for log file:" + logId);
            }
        }
    }

    public BufferedReadChannel getFromChannels(long logId) {
        return this.logid2Channel.get().get(logId);
    }

    @VisibleForTesting
    long getLeastUnflushedLogId() {
        return this.recentlyCreatedEntryLogsStatus.getLeastUnflushedLogId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getFlushedLogIds() {
        HashSet<Long> logIds = new HashSet<Long>();
        RecentEntryLogsStatus recentEntryLogsStatus = this.recentlyCreatedEntryLogsStatus;
        synchronized (recentEntryLogsStatus) {
            for (File dir : this.ledgerDirsManager.getAllLedgerDirs()) {
                File[] files;
                if (!dir.exists() || !dir.isDirectory() || (files = dir.listFiles(file -> file.getName().endsWith(".log"))) == null || files.length <= 0) continue;
                for (File f : files) {
                    long logId = DefaultEntryLogger.fileName2LogId(f.getName());
                    if (!this.recentlyCreatedEntryLogsStatus.isFlushedLogId(logId)) continue;
                    logIds.add(logId);
                }
            }
        }
        return logIds;
    }

    long getPreviousAllocatedEntryLogId() {
        return this.entryLoggerAllocator.getPreallocatedLogId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getCurCompactionLogFile() {
        Object object = this.compactionLogLock;
        synchronized (object) {
            if (this.compactionLogChannel == null) {
                return null;
            }
            return this.compactionLogChannel.getLogFile();
        }
    }

    void prepareSortedLedgerStorageCheckpoint(long numBytesFlushed) throws IOException {
        this.entryLogManager.prepareSortedLedgerStorageCheckpoint(numBytesFlushed);
    }

    void prepareEntryMemTableFlush() {
        this.entryLogManager.prepareEntryMemTableFlush();
    }

    boolean commitEntryMemTableFlush() throws IOException {
        return this.entryLogManager.commitEntryMemTableFlush();
    }

    EntryLoggerAllocator getEntryLoggerAllocator() {
        return this.entryLoggerAllocator;
    }

    @Override
    public boolean removeEntryLog(long entryLogId) {
        File entryLogFile;
        this.removeFromChannelsAndClose(entryLogId);
        try {
            entryLogFile = this.findFile(entryLogId);
        }
        catch (FileNotFoundException e) {
            LOG.error("Trying to delete an entryLog file that could not be found: " + entryLogId + ".log");
            return false;
        }
        if (!entryLogFile.delete()) {
            LOG.warn("Could not delete entry log file {}", (Object)entryLogFile);
        }
        return true;
    }

    private long getLastLogId(File dir) {
        long id = this.readLastLogId(dir);
        if (id > 0L) {
            return id;
        }
        File[] logFiles = dir.listFiles(file -> file.getName().endsWith(".log"));
        ArrayList<Long> logs = new ArrayList<Long>();
        if (logFiles != null) {
            for (File lf : logFiles) {
                long logId = DefaultEntryLogger.fileName2LogId(lf.getName());
                logs.add(logId);
            }
        }
        if (0 == logs.size()) {
            return -1L;
        }
        Collections.sort(logs);
        return (Long)logs.get(logs.size() - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastLogId(File f) {
        FileInputStream fis;
        try {
            fis = new FileInputStream(new File(f, "lastId"));
        }
        catch (FileNotFoundException e) {
            return -1L;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));){
            String lastIdString = br.readLine();
            long l = Long.parseLong(lastIdString, 16);
            return l;
        }
        catch (IOException | NumberFormatException e) {
            return -1L;
        }
    }

    void checkpoint() throws IOException {
        this.entryLogManager.checkpoint();
    }

    @Override
    public void flush() throws IOException {
        this.entryLogManager.flush();
    }

    long addEntry(long ledger, ByteBuffer entry) throws IOException {
        return this.entryLogManager.addEntry(ledger, Unpooled.wrappedBuffer((ByteBuffer)entry), true);
    }

    long addEntry(long ledger, ByteBuf entry, boolean rollLog) throws IOException {
        return this.entryLogManager.addEntry(ledger, entry, rollLog);
    }

    @Override
    public long addEntry(long ledger, ByteBuf entry) throws IOException {
        return this.entryLogManager.addEntry(ledger, entry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addEntryForCompaction(long ledgerId, ByteBuf entry) throws IOException {
        Object object = this.compactionLogLock;
        synchronized (object) {
            int entrySize = entry.readableBytes() + 4;
            if (this.compactionLogChannel == null) {
                this.createNewCompactionLog();
            }
            ByteBuf sizeBuffer = (ByteBuf)this.sizeBuffer.get();
            sizeBuffer.clear();
            sizeBuffer.writeInt(entry.readableBytes());
            this.compactionLogChannel.write(sizeBuffer);
            long pos = this.compactionLogChannel.position();
            this.compactionLogChannel.write(entry);
            this.compactionLogChannel.registerWrittenEntry(ledgerId, entrySize);
            return this.compactionLogChannel.getLogId() << 32 | pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushCompactionLog() throws IOException {
        Object object = this.compactionLogLock;
        synchronized (object) {
            if (this.compactionLogChannel == null) {
                throw new IOException("Failed to flush compaction log which has already been removed.");
            }
            this.compactionLogChannel.appendLedgersMap();
            this.compactionLogChannel.flushAndForceWrite(false);
            LOG.info("Flushed compaction log file {} with logId {}.", (Object)this.compactionLogChannel.getLogFile(), (Object)this.compactionLogChannel.getLogId());
            this.compactionLogChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewCompactionLog() throws IOException {
        Object object = this.compactionLogLock;
        synchronized (object) {
            if (this.compactionLogChannel == null) {
                this.compactionLogChannel = this.entryLogManager.createNewLogForCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCurCompactionLog() {
        Object object = this.compactionLogLock;
        synchronized (object) {
            if (this.compactionLogChannel != null) {
                if (!this.compactionLogChannel.getLogFile().delete()) {
                    LOG.warn("Could not delete compaction log file {}", (Object)this.compactionLogChannel.getLogFile());
                }
                try {
                    this.compactionLogChannel.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close file channel for compaction log {}", (Object)this.compactionLogChannel.getLogId(), (Object)e);
                }
                this.compactionLogChannel = null;
            }
        }
    }

    static long logIdForOffset(long offset) {
        return offset >> 32;
    }

    static long posForOffset(long location) {
        return location & 0xFFFFFFFFL;
    }

    private BufferedReadChannel getFCForEntryInternal(long ledgerId, long entryId, long entryLogId, long pos) throws EntryLookupException, IOException {
        try {
            return this.getChannelForLogId(entryLogId);
        }
        catch (FileNotFoundException e) {
            throw new EntryLookupException.MissingLogFileException(ledgerId, entryId, entryLogId, pos);
        }
    }

    private ByteBuf readEntrySize(long ledgerId, long entryId, long entryLogId, long pos, BufferedReadChannel fc) throws EntryLookupException, IOException {
        ByteBuf sizeBuff = (ByteBuf)this.sizeBuffer.get();
        sizeBuff.clear();
        long entrySizePos = pos - 4L;
        try {
            if (this.readFromLogChannel(entryLogId, fc, sizeBuff, entrySizePos) != sizeBuff.capacity()) {
                throw new EntryLookupException.MissingEntryException(ledgerId, entryId, entryLogId, entrySizePos);
            }
        }
        catch (AsynchronousCloseException | BufferedChannelBase.BufferedChannelClosedException e) {
            throw new EntryLookupException.MissingLogFileException(ledgerId, entryId, entryLogId, entrySizePos);
        }
        return sizeBuff;
    }

    void checkEntry(long ledgerId, long entryId, long location) throws EntryLookupException, IOException {
        long entryLogId = DefaultEntryLogger.logIdForOffset(location);
        long pos = DefaultEntryLogger.posForOffset(location);
        BufferedReadChannel fc = this.getFCForEntryInternal(ledgerId, entryId, entryLogId, pos);
        ByteBuf sizeBuf = this.readEntrySize(ledgerId, entryId, entryLogId, pos, fc);
        this.validateEntry(ledgerId, entryId, entryLogId, pos, sizeBuf);
    }

    private void validateEntry(long ledgerId, long entryId, long entryLogId, long pos, ByteBuf sizeBuff) throws IOException, EntryLookupException {
        int entrySize = sizeBuff.readInt();
        if (entrySize > this.maxSaneEntrySize) {
            LOG.warn("Sanity check failed for entry size of " + entrySize + " at location " + pos + " in " + entryLogId);
        }
        if (entrySize < 16) {
            LOG.error("Read invalid entry length {}", (Object)entrySize);
            throw new EntryLookupException.InvalidEntryLengthException(ledgerId, entryId, entryLogId, pos);
        }
        long thisLedgerId = sizeBuff.getLong(4);
        long thisEntryId = sizeBuff.getLong(12);
        if (thisLedgerId != ledgerId || thisEntryId != entryId) {
            throw new EntryLookupException.WrongEntryException(thisEntryId, thisLedgerId, ledgerId, entryId, entryLogId, pos);
        }
    }

    @Override
    public ByteBuf readEntry(long ledgerId, long entryId, long entryLocation) throws IOException, Bookie.NoEntryException {
        return this.internalReadEntry(ledgerId, entryId, entryLocation, true);
    }

    @Override
    public ByteBuf readEntry(long location) throws IOException, Bookie.NoEntryException {
        return this.internalReadEntry(location, -1L, -1L, false);
    }

    private ByteBuf internalReadEntry(long ledgerId, long entryId, long location, boolean validateEntry) throws IOException, Bookie.NoEntryException {
        long entryLogId = DefaultEntryLogger.logIdForOffset(location);
        long pos = DefaultEntryLogger.posForOffset(location);
        BufferedReadChannel fc = null;
        int entrySize = -1;
        try {
            fc = this.getFCForEntryInternal(ledgerId, entryId, entryLogId, pos);
            ByteBuf sizeBuff = this.readEntrySize(ledgerId, entryId, entryLogId, pos, fc);
            entrySize = sizeBuff.getInt(0);
            if (validateEntry) {
                this.validateEntry(ledgerId, entryId, entryLogId, pos, sizeBuff);
            }
        }
        catch (EntryLookupException e) {
            throw new IOException("Bad entry read from log file id: " + entryLogId, e);
        }
        ByteBuf data = this.allocator.buffer(entrySize, entrySize);
        int rc = this.readFromLogChannel(entryLogId, fc, data, pos);
        if (rc != entrySize) {
            ReferenceCountUtil.release((Object)data);
            throw new IOException("Bad entry read from log file id: " + entryLogId, new EntryLookupException("Short read for " + ledgerId + "@" + entryId + " in " + entryLogId + "@" + pos + "(" + rc + "!=" + entrySize + ")"));
        }
        data.writerIndex(entrySize);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Header getHeaderForLogId(long entryLogId) throws IOException {
        BufferedReadChannel bc = this.getChannelForLogId(entryLogId);
        ByteBuf headers = this.allocator.directBuffer(1024);
        try {
            bc.read(headers, 0L);
            headers.readInt();
            int headerVersion = headers.readInt();
            if (headerVersion < 0 || headerVersion > 1) {
                LOG.info("Unknown entry log header version for log {}: {}", (Object)entryLogId, (Object)headerVersion);
            }
            long ledgersMapOffset = headers.readLong();
            int ledgersCount = headers.readInt();
            Header header = new Header(headerVersion, ledgersMapOffset, ledgersCount);
            return header;
        }
        finally {
            ReferenceCountUtil.release((Object)headers);
        }
    }

    private BufferedReadChannel getChannelForLogId(long entryLogId) throws IOException {
        BufferedReadChannel fc = this.getFromChannels(entryLogId);
        if (fc != null) {
            return fc;
        }
        File file = this.findFile(entryLogId);
        FileChannel newFc = new RandomAccessFile(file, "r").getChannel();
        FileChannel oldFc = this.logid2FileChannel.putIfAbsent(entryLogId, newFc);
        if (null != oldFc) {
            newFc.close();
            newFc = oldFc;
        }
        fc = new BufferedReadChannel(newFc, this.conf.getReadBufferBytes());
        this.putInReadChannels(entryLogId, fc);
        return fc;
    }

    @Override
    public boolean logExists(long logId) {
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File f = new File(d, Long.toHexString(logId) + ".log");
            if (!f.exists()) continue;
            return true;
        }
        return false;
    }

    public Set<Long> getEntryLogsSet() throws IOException {
        TreeSet entryLogs = Sets.newTreeSet();
        FilenameFilter logFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".log");
            }
        };
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File[] files = d.listFiles(logFileFilter);
            if (files == null) {
                throw new IOException("Failed to get list of files in directory " + d);
            }
            for (File f : files) {
                Long entryLogId = Long.parseLong(f.getName().split(".log")[0], 16);
                entryLogs.add(entryLogId);
            }
        }
        return entryLogs;
    }

    private File findFile(long logId) throws FileNotFoundException {
        for (File d : this.ledgerDirsManager.getAllLedgerDirs()) {
            File f = new File(d, Long.toHexString(logId) + ".log");
            if (!f.exists()) continue;
            return f;
        }
        throw new FileNotFoundException("No file for log " + Long.toHexString(logId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanEntryLog(long entryLogId, EntryLogScanner scanner) throws IOException {
        BufferedReadChannel bc;
        ByteBuf headerBuffer = Unpooled.buffer((int)12);
        try {
            bc = this.getChannelForLogId(entryLogId);
        }
        catch (IOException e) {
            LOG.warn("Failed to get channel to scan entry log: " + entryLogId + ".log");
            throw e;
        }
        long pos = 1024L;
        ByteBuf data = this.allocator.directBuffer(0x100000);
        try {
            while (pos < bc.size()) {
                if (this.readFromLogChannel(entryLogId, bc, headerBuffer, pos) != headerBuffer.capacity()) {
                    LOG.warn("Short read for entry size from entrylog {}", (Object)entryLogId);
                    return;
                }
                long offset = pos++;
                int entrySize = headerBuffer.readInt();
                if (entrySize <= 0) {
                    headerBuffer.clear();
                    continue;
                }
                long ledgerId = headerBuffer.readLong();
                headerBuffer.clear();
                pos += 4L;
                if (ledgerId == -1L || !scanner.accept(ledgerId)) {
                    pos += (long)entrySize;
                    continue;
                }
                data.clear();
                data.capacity(entrySize);
                int rc = this.readFromLogChannel(entryLogId, bc, data, pos);
                if (rc != entrySize) {
                    LOG.warn("Short read for ledger entry from entryLog {}@{} ({} != {})", new Object[]{entryLogId, pos, rc, entrySize});
                    return;
                }
                scanner.process(ledgerId, offset, data);
                pos += (long)entrySize;
            }
        }
        finally {
            ReferenceCountUtil.release((Object)data);
        }
    }

    @Override
    public EntryLogMetadata getEntryLogMetadata(long entryLogId, AbstractLogCompactor.Throttler throttler) throws IOException {
        try {
            return this.extractEntryLogMetadataFromIndex(entryLogId);
        }
        catch (Exception e) {
            LOG.info("Failed to get ledgers map index from: {}.log : {}", (Object)entryLogId, (Object)e.getMessage());
            return this.extractEntryLogMetadataByScanning(entryLogId, throttler);
        }
    }

    EntryLogMetadata extractEntryLogMetadataFromIndex(long entryLogId) throws IOException {
        Header header = this.getHeaderForLogId(entryLogId);
        if (header.version < 1) {
            throw new IOException("Old log file header without ledgers map on entryLogId " + entryLogId);
        }
        if (header.ledgersMapOffset == 0L) {
            throw new IOException("No ledgers map index found on entryLogId " + entryLogId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Recovering ledgers maps for log {} at offset: {}", (Object)entryLogId, (Object)header.ledgersMapOffset);
        }
        BufferedReadChannel bc = this.getChannelForLogId(entryLogId);
        EntryLogMetadata meta = new EntryLogMetadata(entryLogId);
        int maxMapSize = 160024;
        ByteBuf ledgersMap = this.allocator.directBuffer(160024);
        try {
            int ledgersMapSize;
            for (long offset = header.ledgersMapOffset; offset < bc.size(); offset += (long)(ledgersMapSize + 4)) {
                ((ByteBuf)this.sizeBuffer.get()).clear();
                bc.read((ByteBuf)this.sizeBuffer.get(), offset);
                ledgersMapSize = ((ByteBuf)this.sizeBuffer.get()).readInt();
                if (ledgersMapSize <= 0) {
                    break;
                }
                ledgersMap.clear();
                bc.read(ledgersMap, offset + 4L, ledgersMapSize);
                long lid = ledgersMap.readLong();
                if (lid != -1L) {
                    throw new IOException("Cannot deserialize ledgers map from ledger " + lid);
                }
                long entryId = ledgersMap.readLong();
                if (entryId != -2L) {
                    throw new IOException("Cannot deserialize ledgers map from entryId " + entryId);
                }
                int ledgersCount = ledgersMap.readInt();
                for (int i = 0; i < ledgersCount; ++i) {
                    long ledgerId = ledgersMap.readLong();
                    long size = ledgersMap.readLong();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Recovering ledgers maps for log {} -- Found ledger: {} with size: {}", new Object[]{entryLogId, ledgerId, size});
                    }
                    meta.addLedgerSize(ledgerId, size);
                }
                if (!ledgersMap.isReadable()) continue;
                throw new IOException("Invalid entry size when reading ledgers map");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException(e);
        }
        finally {
            ReferenceCountUtil.release((Object)ledgersMap);
        }
        if (meta.getLedgersMap().size() != (long)header.ledgersCount) {
            throw new IOException("Not all ledgers were found in ledgers map index. expected: " + header.ledgersCount + " -- found: " + meta.getLedgersMap().size() + " -- entryLogId: " + entryLogId);
        }
        return meta;
    }

    private EntryLogMetadata extractEntryLogMetadataByScanning(long entryLogId, final AbstractLogCompactor.Throttler throttler) throws IOException {
        final EntryLogMetadata meta = new EntryLogMetadata(entryLogId);
        this.scanEntryLog(entryLogId, new EntryLogScanner(){

            @Override
            public void process(long ledgerId, long offset, ByteBuf entry) throws IOException {
                if (throttler != null) {
                    throttler.acquire(entry.readableBytes());
                }
                meta.addLedgerSize(ledgerId, entry.readableBytes() + 4);
            }

            @Override
            public boolean accept(long ledgerId) {
                return ledgerId >= 0L;
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved entry log meta data entryLogId: {}, meta: {}", (Object)entryLogId, (Object)meta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LOG.info("Stopping EntryLogger");
        try {
            this.flush();
            for (FileChannel fc : this.logid2FileChannel.values()) {
                fc.close();
            }
            this.logid2FileChannel.clear();
            this.entryLogManager.close();
            Object object = this.compactionLogLock;
            synchronized (object) {
                if (this.compactionLogChannel != null) {
                    this.compactionLogChannel.close();
                    this.compactionLogChannel = null;
                }
            }
        }
        catch (IOException ie) {
            LOG.error("Error flush entry log during shutting down, which may cause entry log corrupted.", (Throwable)ie);
        }
        finally {
            for (FileChannel fc : this.logid2FileChannel.values()) {
                IOUtils.close(LOG, (Closeable)fc);
            }
            this.entryLogManager.forceClose();
            Object object = this.compactionLogLock;
            synchronized (object) {
                IOUtils.close(LOG, (Closeable)this.compactionLogChannel);
            }
        }
        this.entryLoggerAllocator.stop();
    }

    protected LedgerDirsManager getLedgerDirsManager() {
        return this.ledgerDirsManager;
    }

    static long fileName2LogId(String fileName) {
        if (fileName != null && fileName.contains(".")) {
            fileName = fileName.split("\\.")[0];
        }
        try {
            return Long.parseLong(fileName, 16);
        }
        catch (Exception nfe) {
            LOG.error("Invalid log file name {} found when trying to convert to logId.", (Object)fileName, (Object)nfe);
            return -1L;
        }
    }

    static String logId2HexString(long logId) {
        return Long.toHexString(logId);
    }

    @Override
    public CompactionEntryLog newCompactionLog(long logToCompact) throws IOException {
        this.createNewCompactionLog();
        File compactingLogFile = this.getCurCompactionLogFile();
        long compactionLogId = DefaultEntryLogger.fileName2LogId(compactingLogFile.getName());
        File compactedLogFile = DefaultEntryLogger.compactedLogFileFromCompacting(compactingLogFile, logToCompact);
        File finalLogFile = new File(compactingLogFile.getParentFile(), compactingLogFile.getName().substring(0, compactingLogFile.getName().indexOf(".log") + 4));
        return new EntryLoggerCompactionEntryLog(compactionLogId, logToCompact, compactingLogFile, compactedLogFile, finalLogFile);
    }

    @Override
    public Collection<CompactionEntryLog> incompleteCompactionLogs() {
        List<File> ledgerDirs = this.ledgerDirsManager.getAllLedgerDirs();
        ArrayList<CompactionEntryLog> compactionLogs = new ArrayList<CompactionEntryLog>();
        for (File dir : ledgerDirs) {
            File[] compactedPhaseFiles;
            File[] compactingPhaseFiles = dir.listFiles(file -> file.getName().endsWith(".log.compacting"));
            if (compactingPhaseFiles != null) {
                for (File file2 : compactingPhaseFiles) {
                    if (!file2.delete()) continue;
                    LOG.info("Deleted failed compaction file {}", (Object)file2);
                }
            }
            if ((compactedPhaseFiles = dir.listFiles(file -> file.getName().endsWith(".compacted"))) == null) continue;
            for (File compactedFile : compactedPhaseFiles) {
                LOG.info("Found compacted log file {} has partially flushed index, recovering index.", (Object)compactedFile);
                File compactingLogFile = new File(compactedFile.getParentFile(), "doesntexist");
                long compactionLogId = -1L;
                long compactedLogId = -1L;
                String[] parts = compactedFile.getName().split(Pattern.quote("."));
                boolean valid = true;
                if (parts.length != 4) {
                    valid = false;
                } else {
                    try {
                        compactionLogId = Long.parseLong(parts[0], 16);
                        compactedLogId = Long.parseLong(parts[2], 16);
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                }
                if (!valid) {
                    LOG.info("Invalid compacted file found ({}), deleting", (Object)compactedFile);
                    if (compactedFile.delete()) continue;
                    LOG.warn("Couldn't delete invalid compacted file ({})", (Object)compactedFile);
                    continue;
                }
                File finalLogFile = new File(compactedFile.getParentFile(), compactionLogId + ".log");
                compactionLogs.add(new EntryLoggerCompactionEntryLog(compactionLogId, compactedLogId, compactingLogFile, compactedFile, finalLogFile));
            }
        }
        return compactionLogs;
    }

    private static File compactedLogFileFromCompacting(File compactionLogFile, long compactingLogId) {
        File dir = compactionLogFile.getParentFile();
        String filename = compactionLogFile.getName();
        String newSuffix = ".log." + DefaultEntryLogger.logId2HexString(compactingLogId) + ".compacted";
        String hardLinkFilename = filename.replace(".log.compacting", newSuffix);
        return new File(dir, hardLinkFilename);
    }

    private class EntryLoggerCompactionEntryLog
    implements CompactionEntryLog {
        private final long compactionLogId;
        private final long logIdToCompact;
        private final File compactingLogFile;
        private final File compactedLogFile;
        private final File finalLogFile;

        EntryLoggerCompactionEntryLog(long compactionLogId, long logIdToCompact, File compactingLogFile, File compactedLogFile, File finalLogFile) {
            this.compactionLogId = compactionLogId;
            this.logIdToCompact = logIdToCompact;
            this.compactingLogFile = compactingLogFile;
            this.compactedLogFile = compactedLogFile;
            this.finalLogFile = finalLogFile;
        }

        @Override
        public long addEntry(long ledgerId, ByteBuf entry) throws IOException {
            return DefaultEntryLogger.this.addEntryForCompaction(ledgerId, entry);
        }

        @Override
        public void scan(EntryLogScanner scanner) throws IOException {
            DefaultEntryLogger.this.scanEntryLog(this.compactionLogId, scanner);
        }

        @Override
        public void flush() throws IOException {
            DefaultEntryLogger.this.flushCompactionLog();
        }

        @Override
        public void abort() {
            DefaultEntryLogger.this.removeCurCompactionLog();
            if (this.compactedLogFile.exists() && !this.compactedLogFile.delete()) {
                LOG.warn("Could not delete file: {}", (Object)this.compactedLogFile);
            }
        }

        @Override
        public void markCompacted() throws IOException {
            if (this.compactingLogFile.exists()) {
                if (!this.compactedLogFile.exists()) {
                    HardLink.createHardLink(this.compactingLogFile, this.compactedLogFile);
                }
            } else {
                throw new IOException("Compaction log doesn't exist any more after flush: " + this.compactingLogFile);
            }
            DefaultEntryLogger.this.removeCurCompactionLog();
        }

        @Override
        public void makeAvailable() throws IOException {
            if (!this.finalLogFile.exists()) {
                HardLink.createHardLink(this.compactedLogFile, this.finalLogFile);
            }
        }

        @Override
        public void finalizeAndCleanup() {
            if (this.compactedLogFile.exists() && !this.compactedLogFile.delete()) {
                LOG.warn("Could not delete file: {}", (Object)this.compactedLogFile);
            }
            if (this.compactingLogFile.exists() && !this.compactingLogFile.delete()) {
                LOG.warn("Could not delete file: {}", (Object)this.compactingLogFile);
            }
        }

        @Override
        public long getDstLogId() {
            return this.compactionLogId;
        }

        @Override
        public long getSrcLogId() {
            return this.logIdToCompact;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("logId", this.compactionLogId).add("compactedLogId", this.logIdToCompact).add("compactingLogFile", (Object)this.compactingLogFile).add("compactedLogFile", (Object)this.compactedLogFile).add("finalLogFile", (Object)this.finalLogFile).toString();
        }
    }

    static class RecentEntryLogsStatus {
        private final SortedMap<Long, Boolean> entryLogsStatusMap = new TreeMap<Long, Boolean>();
        private long leastUnflushedLogId;

        RecentEntryLogsStatus(long leastUnflushedLogId) {
            this.leastUnflushedLogId = leastUnflushedLogId;
        }

        synchronized void createdEntryLog(Long entryLogId) {
            this.entryLogsStatusMap.put(entryLogId, false);
        }

        synchronized void flushRotatedEntryLog(Long entryLogId) {
            this.entryLogsStatusMap.replace(entryLogId, true);
            while (!this.entryLogsStatusMap.isEmpty() && ((Boolean)this.entryLogsStatusMap.get(this.entryLogsStatusMap.firstKey())).booleanValue()) {
                long leastFlushedLogId = this.entryLogsStatusMap.firstKey();
                this.entryLogsStatusMap.remove(leastFlushedLogId);
                this.leastUnflushedLogId = leastFlushedLogId + 1L;
            }
        }

        synchronized long getLeastUnflushedLogId() {
            return this.leastUnflushedLogId;
        }

        synchronized boolean isFlushedLogId(long entryLogId) {
            return this.entryLogsStatusMap.getOrDefault(entryLogId, Boolean.FALSE) != false || entryLogId < this.leastUnflushedLogId;
        }
    }

    static class EntryLookupException
    extends Exception {
        EntryLookupException(String message) {
            super(message);
        }

        static class WrongEntryException
        extends EntryLookupException {
            WrongEntryException(long foundEntryId, long foundLedgerId, long ledgerId, long entryId, long entryLogId, long pos) {
                super(String.format("Found entry %d, ledger %d at pos %d entryLog %d, should have found entry %d for ledgerId %d", foundEntryId, foundLedgerId, pos, entryLogId, entryId, ledgerId));
            }
        }

        static class InvalidEntryLengthException
        extends EntryLookupException {
            InvalidEntryLengthException(long ledgerId, long entryId, long entryLogId, long pos) {
                super(String.format("Invalid entry length at pos %d (entry %d for ledgerId %d) for entryLog %d", pos, entryId, ledgerId, entryLogId));
            }
        }

        static class MissingEntryException
        extends EntryLookupException {
            MissingEntryException(long ledgerId, long entryId, long entryLogId, long pos) {
                super(String.format("pos %d (entry %d for ledgerId %d) past end of entryLog %d", pos, entryId, ledgerId, entryLogId));
            }
        }

        static class MissingLogFileException
        extends EntryLookupException {
            MissingLogFileException(long ledgerId, long entryId, long entryLogId, long pos) {
                super(String.format("Missing entryLog %d for ledgerId %d, entry %d at offset %d", entryLogId, ledgerId, entryId, pos));
            }
        }
    }

    static interface EntryLogListener {
        public void onRotateEntryLog();
    }

    private static class Header {
        final int version;
        final long ledgersMapOffset;
        final int ledgersCount;

        Header(int version, long ledgersMapOffset, int ledgersCount) {
            this.version = version;
            this.ledgersMapOffset = ledgersMapOffset;
            this.ledgersCount = ledgersCount;
        }
    }

    static class BufferedLogChannel
    extends BufferedChannel {
        private final long logId;
        private final EntryLogMetadata entryLogMetadata;
        private final File logFile;
        private long ledgerIdAssigned = -1L;

        public BufferedLogChannel(ByteBufAllocator allocator, FileChannel fc, int writeCapacity, int readCapacity, long logId, File logFile, long unpersistedBytesBound) throws IOException {
            super(allocator, fc, writeCapacity, readCapacity, unpersistedBytesBound);
            this.logId = logId;
            this.entryLogMetadata = new EntryLogMetadata(logId);
            this.logFile = logFile;
        }

        public long getLogId() {
            return this.logId;
        }

        public File getLogFile() {
            return this.logFile;
        }

        public void registerWrittenEntry(long ledgerId, long entrySize) {
            this.entryLogMetadata.addLedgerSize(ledgerId, entrySize);
        }

        public ConcurrentLongLongHashMap getLedgersMap() {
            return this.entryLogMetadata.getLedgersMap();
        }

        public Long getLedgerIdAssigned() {
            return this.ledgerIdAssigned;
        }

        public void setLedgerIdAssigned(Long ledgerId) {
            this.ledgerIdAssigned = ledgerId;
        }

        public String toString() {
            return MoreObjects.toStringHelper(BufferedChannel.class).add("logId", this.logId).add("logFile", (Object)this.logFile).add("ledgerIdAssigned", this.ledgerIdAssigned).toString();
        }

        void appendLedgersMap() throws IOException {
            long ledgerMapOffset = this.position();
            ConcurrentLongLongHashMap ledgersMap = this.getLedgersMap();
            final int numberOfLedgers = (int)ledgersMap.size();
            int maxMapSize = 160024;
            final ByteBuf serializedMap = ByteBufAllocator.DEFAULT.buffer(160024);
            try {
                ledgersMap.forEach(new ConcurrentLongLongHashMap.BiConsumerLong(){
                    int remainingLedgers;
                    boolean startNewBatch;
                    int remainingInBatch;
                    {
                        this.remainingLedgers = numberOfLedgers;
                        this.startNewBatch = true;
                        this.remainingInBatch = 0;
                    }

                    @Override
                    public void accept(long ledgerId, long size) {
                        if (this.startNewBatch) {
                            int batchSize = Math.min(this.remainingLedgers, 10000);
                            int ledgerMapSize = 24 + 16 * batchSize;
                            serializedMap.clear();
                            serializedMap.writeInt(ledgerMapSize - 4);
                            serializedMap.writeLong(-1L);
                            serializedMap.writeLong(-2L);
                            serializedMap.writeInt(batchSize);
                            this.startNewBatch = false;
                            this.remainingInBatch = batchSize;
                        }
                        serializedMap.writeLong(ledgerId);
                        serializedMap.writeLong(size);
                        --this.remainingLedgers;
                        if (--this.remainingInBatch == 0) {
                            try {
                                this.write(serializedMap);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            this.startNewBatch = true;
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
            finally {
                ReferenceCountUtil.release((Object)serializedMap);
            }
            super.flush();
            ByteBuffer mapInfo = ByteBuffer.allocate(12);
            mapInfo.putLong(ledgerMapOffset);
            mapInfo.putInt(numberOfLedgers);
            mapInfo.flip();
            this.fileChannel.write(mapInfo, 8L);
        }
    }
}

