/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.admin.ZooKeeperAdmin;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.ReconfigRecoveryTest;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.apache.zookeeper.test.ReconfigTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReconfigFailureCasesTest
extends QuorumPeerTestBase {
    private QuorumUtil qu;

    @BeforeEach
    public void setup() {
        QuorumPeerConfig.setReconfigEnabled((boolean)true);
        System.setProperty("zookeeper.DigestAuthenticationProvider.superDigest", "super:D/InIHSb7yEEbrWz8b9l71RjZJU=");
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.qu != null) {
            this.qu.tearDown();
        }
    }

    @Test
    public void testIncrementalReconfigInvokedOnHiearchicalQS() throws Exception {
        this.qu = new QuorumUtil(2);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        ZooKeeper[] zkArr = ReconfigTest.createHandles(this.qu);
        ZooKeeperAdmin[] zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> members = new ArrayList<String>();
        members.add("group.1=3:4:5");
        members.add("group.2=1:2");
        members.add("weight.1=0");
        members.add("weight.2=0");
        members.add("weight.3=1");
        members.add("weight.4=1");
        members.add("weight.5=1");
        for (int i = 1; i <= 5; ++i) {
            members.add("server." + i + "=127.0.0.1:" + this.qu.getPeer((int)i).peer.getQuorumAddress().getAllPorts().get(0) + ":" + this.qu.getPeer((int)i).peer.getElectionAddress().getAllPorts().get(0) + ";127.0.0.1:" + this.qu.getPeer((int)i).peer.getClientPort());
        }
        ReconfigTest.reconfig(zkAdminArr[1], null, null, members, -1L);
        ReconfigTest.testNormalOperation(zkArr[1], zkArr[2]);
        ArrayList<String> leavingServers = new ArrayList<String>();
        leavingServers.add("3");
        try {
            zkAdminArr[1].reconfigure(null, leavingServers, null, -1L, null);
            Assertions.fail((String)"Reconfig should have failed since the current config isn't Majority QS");
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have been BadArgumentsException!");
        }
        ReconfigTest.closeAllHandles(zkArr, zkAdminArr);
    }

    @Test
    public void testTooFewRemainingPariticipants() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        ZooKeeper[] zkArr = ReconfigTest.createHandles(this.qu);
        ZooKeeperAdmin[] zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        leavingServers.add("2");
        leavingServers.add("3");
        try {
            zkAdminArr[1].reconfigure(null, leavingServers, null, -1L, null);
            Assertions.fail((String)"Reconfig should have failed since the current config version is not 8");
        }
        catch (KeeperException.BadArgumentsException badArgumentsException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have been BadArgumentsException!");
        }
        ReconfigTest.closeAllHandles(zkArr, zkAdminArr);
    }

    @Test
    public void testReconfigVersionConditionFails() throws Exception {
        this.qu = new QuorumUtil(1);
        this.qu.disableJMXTest = true;
        this.qu.startAll();
        ZooKeeper[] zkArr = ReconfigTest.createHandles(this.qu);
        ZooKeeperAdmin[] zkAdminArr = ReconfigTest.createAdminHandles(this.qu);
        ArrayList<String> leavingServers = new ArrayList<String>();
        leavingServers.add("3");
        try {
            zkAdminArr[1].reconfigure(null, leavingServers, null, 8L, null);
            Assertions.fail((String)"Reconfig should have failed since the current config version is not 8");
        }
        catch (KeeperException.BadVersionException badVersionException) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Should have been BadVersionException!");
        }
        ReconfigTest.closeAllHandles(zkArr, zkAdminArr);
    }

    @Test
    public void testObserverToParticipantConversionFails() throws Exception {
        int i;
        int i2;
        ClientBase.setupTestEnv();
        int SERVER_COUNT = 4;
        int[][] ports = ReconfigRecoveryTest.generatePorts(4);
        HashSet<Integer> observers = new HashSet<Integer>();
        observers.add(3);
        StringBuilder sb = ReconfigRecoveryTest.generateConfig(4, ports, observers);
        String currentQuorumCfgSection = sb.toString();
        String nextQuorumCfgSection = currentQuorumCfgSection.replace("observer", "participant");
        QuorumPeerTestBase.MainThread[] mt = new QuorumPeerTestBase.MainThread[4];
        ZooKeeper[] zk = new ZooKeeper[4];
        ZooKeeperAdmin[] zkAdmin = new ZooKeeperAdmin[4];
        for (i2 = 1; i2 < 4; ++i2) {
            mt[i2] = new QuorumPeerTestBase.MainThread(i2, ports[i2][2], currentQuorumCfgSection, true, "100000000");
            mt[i2].start();
            zk[i2] = new ZooKeeper("127.0.0.1:" + ports[i2][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            zkAdmin[i2] = new ZooKeeperAdmin("127.0.0.1:" + ports[i2][2], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
            zkAdmin[i2].addAuthInfo("digest", "super:test".getBytes());
        }
        for (i2 = 1; i2 < 4; ++i2) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + ports[i2][2], ClientBase.CONNECTION_TIMEOUT * 2), (String)("waiting for server " + i2 + " being up"));
        }
        try {
            zkAdmin[1].reconfigure("", "", nextQuorumCfgSection, -1L, new Stat());
            Assertions.fail((String)"Reconfig should have failed with NewConfigNoQuorum");
        }
        catch (KeeperException.NewConfigNoQuorum i3) {
        }
        catch (Exception e) {
            Assertions.fail((String)"Reconfig should have failed with NewConfigNoQuorum");
        }
        ArrayList<String> leavingServers = new ArrayList<String>();
        leavingServers.add("3");
        ReconfigTest.reconfig(zkAdmin[1], null, leavingServers, null, -1L);
        ReconfigTest.testNormalOperation(zk[2], zk[3]);
        ReconfigTest.testServerHasConfig(zk[3], null, leavingServers);
        List<String> newMembers = Arrays.asList(nextQuorumCfgSection.split("\n"));
        ReconfigTest.reconfig(zkAdmin[1], null, null, newMembers, -1L);
        ReconfigTest.testNormalOperation(zk[2], zk[3]);
        for (i = 1; i < 4; ++i) {
            ReconfigTest.testServerHasConfig(zk[i], newMembers, null);
        }
        for (i = 1; i < 4; ++i) {
            zk[i].close();
            zkAdmin[i].close();
            mt[i].shutdown();
        }
    }
}

