/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.FastThreadLocal;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.CRC32CDigestManager;
import org.apache.bookkeeper.proto.checksum.CRC32DigestManager;
import org.apache.bookkeeper.proto.checksum.DummyDigestManager;
import org.apache.bookkeeper.proto.checksum.MacDigestManager;
import org.apache.bookkeeper.util.ByteBufList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DigestManager {
    private static final Logger logger = LoggerFactory.getLogger(DigestManager.class);
    public static final int METADATA_LENGTH = 32;
    public static final int LAC_METADATA_LENGTH = 16;
    final long ledgerId;
    final boolean useV2Protocol;
    private final ByteBufAllocator allocator;
    final int macCodeLength;
    private static final FastThreadLocal<ByteBuf> DIGEST_BUFFER = new FastThreadLocal<ByteBuf>(){

        protected ByteBuf initialValue() throws Exception {
            return PooledByteBufAllocator.DEFAULT.directBuffer(1024);
        }

        protected void onRemoval(ByteBuf value) throws Exception {
            value.release();
        }
    };

    abstract int getMacCodeLength();

    abstract int update(int var1, ByteBuf var2, int var3, int var4);

    abstract void populateValueAndReset(int var1, ByteBuf var2);

    abstract boolean isInt32Digest();

    public DigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        this.ledgerId = ledgerId;
        this.useV2Protocol = useV2Protocol;
        this.macCodeLength = this.getMacCodeLength();
        this.allocator = allocator;
    }

    public static DigestManager instantiate(long ledgerId, byte[] passwd, DataFormats.LedgerMetadataFormat.DigestType digestType, ByteBufAllocator allocator, boolean useV2Protocol) throws GeneralSecurityException {
        switch (digestType) {
            case HMAC: {
                return new MacDigestManager(ledgerId, passwd, useV2Protocol, allocator);
            }
            case CRC32: {
                return new CRC32DigestManager(ledgerId, useV2Protocol, allocator);
            }
            case CRC32C: {
                return new CRC32CDigestManager(ledgerId, useV2Protocol, allocator);
            }
            case DUMMY: {
                return new DummyDigestManager(ledgerId, useV2Protocol, allocator);
            }
        }
        throw new GeneralSecurityException("Unknown checksum type: " + digestType);
    }

    public static byte[] generateMasterKey(byte[] password) throws NoSuchAlgorithmException {
        return password.length > 0 ? MacDigestManager.genDigest("ledger", password) : MacDigestManager.EMPTY_LEDGER_KEY;
    }

    public ReferenceCounted computeDigestAndPackageForSending(long entryId, long lastAddConfirmed, long length, ByteBuf data, byte[] masterKey, int flags) {
        if (this.useV2Protocol) {
            return this.computeDigestAndPackageForSendingV2(entryId, lastAddConfirmed, length, data, masterKey, flags);
        }
        return this.computeDigestAndPackageForSendingV3(entryId, lastAddConfirmed, length, data);
    }

    private ReferenceCounted computeDigestAndPackageForSendingV2(long entryId, long lastAddConfirmed, long length, ByteBuf data, byte[] masterKey, int flags) {
        boolean isSmallEntry = data.readableBytes() < 16384;
        int headersSize = 56 + this.macCodeLength;
        int payloadSize = data.readableBytes();
        int bufferSize = 4 + headersSize + (isSmallEntry ? payloadSize : 0);
        ByteBuf buf = this.allocator.buffer(bufferSize, bufferSize);
        buf.writeInt(headersSize + payloadSize);
        buf.writeInt(BookieProtocol.PacketHeader.toInt((byte)2, (byte)1, (short)flags));
        buf.writeBytes(masterKey, 0, 20);
        buf.readerIndex(buf.writerIndex());
        buf.writeLong(this.ledgerId);
        buf.writeLong(entryId);
        buf.writeLong(lastAddConfirmed);
        buf.writeLong(length);
        int digest = this.update(0, buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf unwrapped = data.unwrap() != null && data.unwrap() instanceof CompositeByteBuf ? data.unwrap() : data;
        ReferenceCountUtil.retain((Object)unwrapped);
        ReferenceCountUtil.safeRelease((Object)data);
        if (unwrapped instanceof CompositeByteBuf) {
            CompositeByteBuf cbb = (CompositeByteBuf)unwrapped;
            for (int i = 0; i < cbb.numComponents(); ++i) {
                ByteBuf b = cbb.component(i);
                digest = this.update(digest, b, b.readerIndex(), b.readableBytes());
            }
        } else {
            digest = this.update(digest, unwrapped, unwrapped.readerIndex(), unwrapped.readableBytes());
        }
        this.populateValueAndReset(digest, buf);
        buf.readerIndex(0);
        if (isSmallEntry) {
            buf.writeBytes(unwrapped, unwrapped.readerIndex(), unwrapped.readableBytes());
            unwrapped.release();
            return buf;
        }
        return ByteBufList.get(buf, unwrapped);
    }

    private ByteBufList computeDigestAndPackageForSendingV3(long entryId, long lastAddConfirmed, long length, ByteBuf data) {
        ByteBuf headersBuffer = Unpooled.buffer((int)(32 + this.macCodeLength));
        headersBuffer.writeLong(this.ledgerId);
        headersBuffer.writeLong(entryId);
        headersBuffer.writeLong(lastAddConfirmed);
        headersBuffer.writeLong(length);
        int digest = this.update(0, headersBuffer, 0, 32);
        ByteBuf unwrapped = data.unwrap() != null && data.unwrap() instanceof CompositeByteBuf ? data.unwrap() : data;
        ReferenceCountUtil.retain((Object)unwrapped);
        ReferenceCountUtil.release((Object)data);
        if (unwrapped instanceof CompositeByteBuf) {
            CompositeByteBuf cbb = (CompositeByteBuf)unwrapped;
            for (int i = 0; i < cbb.numComponents(); ++i) {
                ByteBuf b = cbb.component(i);
                digest = this.update(digest, b, b.readerIndex(), b.readableBytes());
            }
        } else {
            digest = this.update(digest, unwrapped, unwrapped.readerIndex(), unwrapped.readableBytes());
        }
        this.populateValueAndReset(digest, headersBuffer);
        return ByteBufList.get(headersBuffer, unwrapped);
    }

    public ByteBufList computeDigestAndPackageForSendingLac(long lac) {
        ByteBuf headersBuffer = this.useV2Protocol ? this.allocator.buffer(16 + this.macCodeLength) : Unpooled.buffer((int)(16 + this.macCodeLength));
        headersBuffer.writeLong(this.ledgerId);
        headersBuffer.writeLong(lac);
        int digest = this.update(0, headersBuffer, 0, 16);
        this.populateValueAndReset(digest, headersBuffer);
        return ByteBufList.get(headersBuffer);
    }

    private void verifyDigest(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(-1L, dataReceived, true);
    }

    private void verifyDigest(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived, false);
    }

    private void verifyDigest(long entryId, ByteBuf dataReceived, boolean skipEntryIdCheck) throws BKException.BKDigestMatchException {
        if (32 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type.  Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        int digest = this.update(0, dataReceived, 0, 32);
        int offset = 32 + this.macCodeLength;
        digest = this.update(digest, dataReceived, offset, dataReceived.readableBytes() - offset);
        if (this.isInt32Digest()) {
            int receivedDigest = dataReceived.getInt(32);
            if (receivedDigest != digest) {
                logger.error("Digest mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
                throw new BKException.BKDigestMatchException();
            }
        } else {
            ByteBuf digestBuf = (ByteBuf)DIGEST_BUFFER.get();
            digestBuf.clear();
            this.populateValueAndReset(digest, digestBuf);
            if (!ByteBufUtil.equals((ByteBuf)digestBuf, (int)0, (ByteBuf)dataReceived, (int)32, (int)this.macCodeLength)) {
                logger.error("Mac mismatch for ledger-id: " + this.ledgerId + ", entry-id: " + entryId);
                throw new BKException.BKDigestMatchException();
            }
        }
        long actualLedgerId = dataReceived.readLong();
        long actualEntryId = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        if (!skipEntryIdCheck && actualEntryId != entryId) {
            logger.error("Entry-id mismatch in authenticated message, expected: " + entryId + " , actual: " + actualEntryId);
            throw new BKException.BKDigestMatchException();
        }
    }

    public long verifyDigestAndReturnLac(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        if (16 + this.macCodeLength > dataReceived.readableBytes()) {
            logger.error("Data received is smaller than the minimum for this digest type. Either the packet it corrupt, or the wrong digest is configured.  Digest type: {}, Packet Length: {}", (Object)this.getClass().getName(), (Object)dataReceived.readableBytes());
            throw new BKException.BKDigestMatchException();
        }
        int digest = this.update(0, dataReceived, 0, 16);
        if (this.isInt32Digest()) {
            int receivedDigest = dataReceived.getInt(16);
            if (receivedDigest != digest) {
                logger.error("Digest mismatch for ledger-id LAC: " + this.ledgerId);
                throw new BKException.BKDigestMatchException();
            }
        } else {
            ByteBuf digestBuf = (ByteBuf)DIGEST_BUFFER.get();
            digestBuf.clear();
            this.populateValueAndReset(digest, digestBuf);
            if (!ByteBufUtil.equals((ByteBuf)digestBuf, (int)0, (ByteBuf)dataReceived, (int)16, (int)this.macCodeLength)) {
                logger.error("Mac mismatch for ledger-id LAC: " + this.ledgerId);
                throw new BKException.BKDigestMatchException();
            }
        }
        long actualLedgerId = dataReceived.readLong();
        long lac = dataReceived.readLong();
        if (actualLedgerId != this.ledgerId) {
            logger.error("Ledger-id mismatch in authenticated message, expected: " + this.ledgerId + " , actual: " + actualLedgerId);
            throw new BKException.BKDigestMatchException();
        }
        return lac;
    }

    public ByteBuf verifyDigestAndReturnData(long entryId, ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(entryId, dataReceived);
        dataReceived.readerIndex(32 + this.macCodeLength);
        return dataReceived;
    }

    public RecoveryData verifyDigestAndReturnLastConfirmed(ByteBuf dataReceived) throws BKException.BKDigestMatchException {
        this.verifyDigest(dataReceived);
        dataReceived.readerIndex(8);
        dataReceived.readLong();
        long lastAddConfirmed = dataReceived.readLong();
        long length = dataReceived.readLong();
        return new RecoveryData(lastAddConfirmed, length);
    }

    public static final class RecoveryData {
        final long lastAddConfirmed;
        final long length;

        public RecoveryData(long lastAddConfirmed, long length) {
            this.lastAddConfirmed = lastAddConfirmed;
            this.length = length;
        }

        public long getLastAddConfirmed() {
            return this.lastAddConfirmed;
        }

        public long getLength() {
            return this.length;
        }
    }
}

