/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.storage.EntryLogIds;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Events;
import org.apache.bookkeeper.slogger.Slogger;
import org.apache.commons.lang3.tuple.Pair;

public class EntryLogIdsImpl
implements EntryLogIds {
    public static final Pattern FILE_PATTERN = Pattern.compile("^([0-9a-fA-F]+)\\.log$");
    public static final Pattern COMPACTED_FILE_PATTERN = Pattern.compile("^([0-9a-fA-F]+)\\.log\\.([0-9a-fA-F]+)\\.compacted$");
    private final LedgerDirsManager ledgerDirsManager;
    private final Slogger slog;
    private int nextId;
    private int maxId;

    public EntryLogIdsImpl(LedgerDirsManager ledgerDirsManager, Slogger slog) throws IOException {
        this.ledgerDirsManager = ledgerDirsManager;
        this.slog = slog.ctx(EntryLogIdsImpl.class);
        this.findLargestGap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int nextId() throws IOException {
        while (true) {
            EntryLogIdsImpl entryLogIdsImpl = this;
            synchronized (entryLogIdsImpl) {
                int current = this.nextId++;
                if (this.nextId != this.maxId) {
                    return current;
                }
                this.findLargestGap();
            }
        }
    }

    private void findLargestGap() throws IOException {
        long start = System.nanoTime();
        ArrayList<Integer> currentIds = new ArrayList<Integer>();
        for (File ledgerDir : this.ledgerDirsManager.getAllLedgerDirs()) {
            currentIds.addAll(EntryLogIdsImpl.logIdsInDirectory(ledgerDir));
            currentIds.addAll(EntryLogIdsImpl.compactedLogIdsInDirectory(ledgerDir));
        }
        Pair<Integer, Integer> gap = EntryLogIdsImpl.findLargestGap(currentIds);
        this.nextId = (Integer)gap.getLeft();
        this.maxId = (Integer)gap.getRight();
        this.slog.kv((Object)"dirs", this.ledgerDirsManager.getAllLedgerDirs()).kv((Object)"nextId", (Object)this.nextId).kv((Object)"maxId", (Object)this.maxId).kv((Object)"durationMs", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start)).info((Enum)Events.ENTRYLOG_IDS_CANDIDATES_SELECTED);
    }

    static Pair<Integer, Integer> findLargestGap(List<Integer> currentIds) {
        if (currentIds.isEmpty()) {
            return Pair.of((Object)0, (Object)Integer.MAX_VALUE);
        }
        Collections.sort(currentIds);
        int nextIdCandidate = 0;
        int maxIdCandidate = currentIds.get(0);
        int maxGap = maxIdCandidate - nextIdCandidate;
        for (int i = 0; i < currentIds.size(); ++i) {
            int gapSize;
            int gapStart = currentIds.get(i) + 1;
            int j = i + 1;
            int gapEnd = Integer.MAX_VALUE;
            if (j < currentIds.size()) {
                gapEnd = currentIds.get(j);
            }
            if ((gapSize = gapEnd - gapStart) <= maxGap) continue;
            maxGap = gapSize;
            nextIdCandidate = gapStart;
            maxIdCandidate = gapEnd;
        }
        return Pair.of((Object)nextIdCandidate, (Object)maxIdCandidate);
    }

    public static List<Integer> logIdsInDirectory(File directory) {
        File[] files;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                Matcher m = FILE_PATTERN.matcher(f.getName());
                if (!m.matches()) continue;
                int logId = Integer.parseUnsignedInt(m.group(1), 16);
                ids.add(logId);
            }
        }
        return ids;
    }

    private static List<Integer> compactedLogIdsInDirectory(File directory) {
        File[] files;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                Matcher m = COMPACTED_FILE_PATTERN.matcher(f.getName());
                if (!m.matches()) continue;
                int logId = Integer.parseUnsignedInt(m.group(1), 16);
                ids.add(logId);
            }
        }
        return ids;
    }
}

