/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZooKeeperServerMainTest;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509AuthFailureTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(X509AuthFailureTest.class);
    private static ClientX509Util clientX509Util;
    public static final int TIMEOUT = 5000;
    public static int CONNECTION_TIMEOUT;

    @BeforeEach
    public void setup() throws Exception {
        clientX509Util = new ClientX509Util();
        String testDataPath = System.getProperty("test.data.dir", "src/test/resources/data");
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        System.setProperty("zookeeper.client.secure", "true");
        System.setProperty(clientX509Util.getSslKeystoreLocationProperty(), testDataPath + "/ssl/testKeyStore.jks");
        System.setProperty(clientX509Util.getSslKeystorePasswdProperty(), "testpass");
        System.setProperty("zookeeper.admin.serverPort", "" + PortAssignment.unique());
    }

    @AfterEach
    public void teardown() throws Exception {
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        System.clearProperty("zookeeper.client.secure");
        System.clearProperty(clientX509Util.getSslKeystoreLocationProperty());
        System.clearProperty(clientX509Util.getSslKeystorePasswdProperty());
        System.clearProperty(clientX509Util.getSslTruststoreLocationProperty());
        System.clearProperty(clientX509Util.getSslTruststorePasswdProperty());
        System.clearProperty("zookeeper.admin.serverPort");
        clientX509Util.close();
    }

    @Test
    public void testSecureStandaloneServerAuthNFailure() throws Exception {
        Integer CLIENT_PORT = PortAssignment.unique();
        Integer SECURE_CLIENT_PORT = PortAssignment.unique();
        ZooKeeperServerMainTest.MainThread mt = new ZooKeeperServerMainTest.MainThread(CLIENT_PORT, SECURE_CLIENT_PORT, true, null);
        mt.start();
        Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + CLIENT_PORT, ClientBase.CONNECTION_TIMEOUT));
        try {
            ZooKeeper zk = this.createZKClnt("127.0.0.1:" + SECURE_CLIENT_PORT);
            Assertions.fail((String)"should not be reached");
        }
        catch (Exception zk) {
            // empty catch block
        }
        ServerStats serverStats = mt.getSecureCnxnFactory().getZooKeeperServer().serverStats();
        Assertions.assertTrue((serverStats.getAuthFailedCount() >= 1L ? 1 : 0) != 0);
        mt.shutdown();
    }

    private ZooKeeper createZKClnt(String cxnString) throws Exception {
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        ZooKeeper zk = new ZooKeeper(cxnString, 5000, (Watcher)watcher);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        return zk;
    }

    static {
        CONNECTION_TIMEOUT = 30000;
    }
}

