/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import io.grpc.Metadata;
import io.grpc.rls.RlsProtoData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckReturnValue;

final class RlsRequestFactory {
    private final String target;
    private final Map<String, RlsProtoData.GrpcKeyBuilder> keyBuilderTable;

    RlsRequestFactory(RlsProtoData.RouteLookupConfig rlsConfig, String target) {
        Preconditions.checkNotNull((Object)rlsConfig, (Object)"rlsConfig");
        this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.keyBuilderTable = RlsRequestFactory.createKeyBuilderTable(rlsConfig);
    }

    private static Map<String, RlsProtoData.GrpcKeyBuilder> createKeyBuilderTable(RlsProtoData.RouteLookupConfig config) {
        HashMap<String, RlsProtoData.GrpcKeyBuilder> table = new HashMap<String, RlsProtoData.GrpcKeyBuilder>();
        for (RlsProtoData.GrpcKeyBuilder grpcKeyBuilder : config.grpcKeybuilders()) {
            for (RlsProtoData.GrpcKeyBuilder.Name name : grpcKeyBuilder.names()) {
                boolean hasMethod = name.method() == null || name.method().isEmpty();
                String method = hasMethod ? "*" : name.method();
                String path = "/" + name.service() + "/" + method;
                table.put(path, grpcKeyBuilder);
            }
        }
        return table;
    }

    @CheckReturnValue
    RlsProtoData.RouteLookupRequest create(String service, String method, Metadata metadata) {
        Preconditions.checkNotNull((Object)service, (Object)"service");
        Preconditions.checkNotNull((Object)method, (Object)"method");
        String path = "/" + service + "/" + method;
        RlsProtoData.GrpcKeyBuilder grpcKeyBuilder = this.keyBuilderTable.get(path);
        if (grpcKeyBuilder == null) {
            grpcKeyBuilder = this.keyBuilderTable.get("/" + service + "/*");
        }
        if (grpcKeyBuilder == null) {
            return RlsProtoData.RouteLookupRequest.create((ImmutableMap<String, String>)ImmutableMap.of());
        }
        ImmutableMap.Builder<String, String> rlsRequestHeaders = this.createRequestHeaders(metadata, (List<RlsProtoData.NameMatcher>)grpcKeyBuilder.headers());
        RlsProtoData.ExtraKeys extraKeys = grpcKeyBuilder.extraKeys();
        ImmutableMap<String, String> constantKeys = grpcKeyBuilder.constantKeys();
        if (extraKeys.host() != null) {
            rlsRequestHeaders.put((Object)extraKeys.host(), (Object)this.target);
        }
        if (extraKeys.service() != null) {
            rlsRequestHeaders.put((Object)extraKeys.service(), (Object)service);
        }
        if (extraKeys.method() != null) {
            rlsRequestHeaders.put((Object)extraKeys.method(), (Object)method);
        }
        rlsRequestHeaders.putAll(constantKeys);
        return RlsProtoData.RouteLookupRequest.create((ImmutableMap<String, String>)rlsRequestHeaders.buildOrThrow());
    }

    private ImmutableMap.Builder<String, String> createRequestHeaders(Metadata metadata, List<RlsProtoData.NameMatcher> keyBuilder) {
        ImmutableMap.Builder rlsRequestHeaders = ImmutableMap.builder();
        for (RlsProtoData.NameMatcher nameMatcher : keyBuilder) {
            String requestHeaderName;
            String value = null;
            UnmodifiableIterator unmodifiableIterator = nameMatcher.names().iterator();
            while (unmodifiableIterator.hasNext() && (value = (String)metadata.get(Metadata.Key.of((String)(requestHeaderName = (String)unmodifiableIterator.next()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))) == null) {
            }
            if (value == null) continue;
            rlsRequestHeaders.put((Object)nameMatcher.key(), value);
        }
        return rlsRequestHeaders;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("keyBuilderTable", this.keyBuilderTable).toString();
    }
}

