/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.tools.perf.dlog.PerfWriter;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCommand
extends BKCommand<PerfWriter.Flags> {
    private static final Logger log = LoggerFactory.getLogger(WriteCommand.class);
    private static final String NAME = "write";
    private static final String DESC = "Write log records to distributedlog streams";

    public WriteCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new PerfWriter.Flags()).build());
    }

    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, PerfWriter.Flags cmdFlags) {
        if (serviceURI == null) {
            log.warn("No service uri is provided. Use default 'distributedlog://localhost/distributedlog'.");
            serviceURI = ServiceURI.create((String)"distributedlog://localhost/distributedlog");
        }
        PerfWriter writer = new PerfWriter(serviceURI, cmdFlags);
        writer.run();
        return true;
    }
}

