/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuorumPeerConfigTest {
    @Test
    public void testErrorMessageWhensecureClientPortNotSetButsecureClientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("secureClientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assertions.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "secureClientPortAddress is set but secureClientPort is not set";
            Assertions.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testErrorMessageWhenclientPortNotSetButclientPortAddressSet() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        try {
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("clientPortAddress", "localhost");
            quorumPeerConfig.parseProperties(zkProp);
            Assertions.fail((String)"IllegalArgumentException is expected");
        }
        catch (IllegalArgumentException e) {
            String expectedMessage = "clientPortAddress is set but clientPort is not set";
            Assertions.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void testConfigureSSLAuthGetsConfiguredIfSecurePortConfigured() throws IOException, QuorumPeerConfig.ConfigException {
        String sslAuthProp = "zookeeper.authProvider.x509";
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("secureClientPort", "12345");
        quorumPeerConfig.parseProperties(zkProp);
        String expected = "org.apache.zookeeper.server.auth.X509AuthenticationProvider";
        String result = System.getProperty(sslAuthProp);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testCustomSSLAuth() throws IOException {
        try (ClientX509Util x509Util = new ClientX509Util();){
            System.setProperty(x509Util.getSslAuthProviderProperty(), "y509");
            QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
            try {
                Properties zkProp = this.getDefaultZKProperties();
                zkProp.setProperty("secureClientPort", "12345");
                quorumPeerConfig.parseProperties(zkProp);
                Assertions.fail((String)"ConfigException is expected");
            }
            catch (QuorumPeerConfig.ConfigException e) {
                Assertions.assertNotNull((Object)e.getMessage());
            }
        }
    }

    @Test
    public void testSamePortConfiguredForClientAndElection() {
        Assertions.assertThrows(QuorumPeerConfig.ConfigException.class, () -> {
            QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
            Properties zkProp = this.getDefaultZKProperties();
            zkProp.setProperty("server.1", "localhost:2888:2888");
            quorumPeerConfig.parseProperties(zkProp);
        });
    }

    @Test
    public void testClientAddrFromClientPort() throws IOException, QuorumPeerConfig.ConfigException {
        long serverId = 1L;
        MockQuorumPeerConfig quorumPeerConfig = new MockQuorumPeerConfig(serverId);
        Properties zkProp = this.getDefaultZKProperties();
        int clientPort = 12345;
        zkProp.setProperty("clientPort", Integer.toString(clientPort));
        zkProp.setProperty("server.1", "127.0.0.1:2889:3889:participant");
        quorumPeerConfig.parseProperties(zkProp);
        QuorumPeer.QuorumServer qs = (QuorumPeer.QuorumServer)quorumPeerConfig.getQuorumVerifier().getAllMembers().get(serverId);
        InetSocketAddress expectedAddress = new InetSocketAddress("0.0.0.0", clientPort);
        Assertions.assertEquals((Object)expectedAddress, (Object)quorumPeerConfig.getClientPortAddress());
        Assertions.assertEquals((Object)quorumPeerConfig.getClientPortAddress(), (Object)qs.clientAddr);
    }

    @Test
    public void testJvmPauseMonitorConfigured() throws IOException, QuorumPeerConfig.ConfigException {
        Long sleepTime = 444L;
        Long warnTH = 5555L;
        Long infoTH = 555L;
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("dataDir", new File("myDataDir").getAbsolutePath());
        zkProp.setProperty("jvm.pause.monitor", "true");
        zkProp.setProperty("jvm.pause.sleep.time.ms", sleepTime.toString());
        zkProp.setProperty("jvm.pause.warn-threshold.ms", warnTH.toString());
        zkProp.setProperty("jvm.pause.info-threshold.ms", infoTH.toString());
        quorumPeerConfig.parseProperties(zkProp);
        Assertions.assertEquals((Long)sleepTime, (Long)quorumPeerConfig.getJvmPauseSleepTimeMs());
        Assertions.assertEquals((Long)warnTH, (Long)quorumPeerConfig.getJvmPauseWarnThresholdMs());
        Assertions.assertEquals((Long)infoTH, (Long)quorumPeerConfig.getJvmPauseInfoThresholdMs());
        Assertions.assertTrue((boolean)quorumPeerConfig.isJvmPauseMonitorToRun());
    }

    @Test
    public void testParseBoolean() throws IOException, QuorumPeerConfig.ConfigException {
        QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
        Properties zkProp = this.getDefaultZKProperties();
        zkProp.setProperty("localSessionsEnabled", "true");
        quorumPeerConfig.parseProperties(zkProp);
        Assertions.assertEquals((Object)true, (Object)quorumPeerConfig.areLocalSessionsEnabled());
        zkProp.setProperty("localSessionsEnabled", "false");
        quorumPeerConfig.parseProperties(zkProp);
        Assertions.assertEquals((Object)false, (Object)quorumPeerConfig.areLocalSessionsEnabled());
        zkProp.setProperty("localSessionsEnabled", "True");
        quorumPeerConfig.parseProperties(zkProp);
        Assertions.assertEquals((Object)true, (Object)quorumPeerConfig.areLocalSessionsEnabled());
        zkProp.setProperty("localSessionsEnabled", "False");
        quorumPeerConfig.parseProperties(zkProp);
        Assertions.assertEquals((Object)false, (Object)quorumPeerConfig.areLocalSessionsEnabled());
        zkProp.setProperty("localSessionsEnabled", "yes");
        try {
            quorumPeerConfig.parseProperties(zkProp);
            Assertions.fail((String)"Must throw exception as 'yes' is not accpetable for parseBoolean!");
        }
        catch (QuorumPeerConfig.ConfigException configException) {
            // empty catch block
        }
    }

    private Properties getDefaultZKProperties() {
        Properties zkProp = new Properties();
        zkProp.setProperty("dataDir", new File("myDataDir").getAbsolutePath());
        zkProp.setProperty("oraclePath", new File("mastership").getAbsolutePath());
        return zkProp;
    }

    public static class MockQuorumPeerConfig
    extends QuorumPeerConfig {
        public MockQuorumPeerConfig(long serverId) {
            this.serverId = serverId;
        }
    }
}

