/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.Recycler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.bookie.BufferedChannel;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.FileChannelProvider;
import org.apache.bookkeeper.bookie.JournalAliveListener;
import org.apache.bookkeeper.bookie.JournalChannel;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.stats.JournalStats;
import org.apache.bookkeeper.common.collections.BlockingMpscQueue;
import org.apache.bookkeeper.common.collections.RecyclableArrayList;
import org.apache.bookkeeper.common.util.MemoryLimitController;
import org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Journal
extends BookieCriticalThread
implements CheckpointSource {
    private static final Logger LOG = LoggerFactory.getLogger(Journal.class);
    private static final RecyclableArrayList.Recycler<QueueEntry> entryListRecycler = new RecyclableArrayList.Recycler();
    private final Recycler<ForceWriteRequest> forceWriteRequestsRecycler = new Recycler<ForceWriteRequest>(){

        protected ForceWriteRequest newObject(Recycler.Handle<ForceWriteRequest> handle) {
            return new ForceWriteRequest(handle);
        }
    };
    static final int PADDING_MASK = -256;
    static final long MB = 0x100000L;
    static final int KB = 1024;
    final long maxJournalSize;
    final long journalPreAllocSize;
    final int journalWriteBufferSize;
    final int maxBackupJournals;
    final File journalDirectory;
    final ServerConfiguration conf;
    final ForceWriteThread forceWriteThread;
    final FileChannelProvider fileChannelProvider;
    private final long maxGroupWaitInNanos;
    private final long bufferedEntriesThreshold;
    private final long bufferedWritesThreshold;
    private final boolean flushWhenQueueEmpty;
    private final boolean removePagesFromCache;
    private final int journalFormatVersionToWrite;
    private final int journalAlignmentSize;
    private final long journalPageCacheFlushIntervalMSec;
    private final boolean syncData;
    private final LastLogMark lastLogMark = new LastLogMark(0L, 0L);
    private static final String LAST_MARK_DEFAULT_NAME = "lastMark";
    private final String lastMarkFileName;
    private final ExecutorService cbThreadPool;
    private final Counter callbackTime;
    private final Counter journalTime;
    private static String journalThreadName = "BookieJournal";
    final BlockingQueue<QueueEntry> queue;
    final BlockingQueue<ForceWriteRequest> forceWriteRequests;
    volatile boolean running = true;
    private final LedgerDirsManager ledgerDirsManager;
    private final ByteBufAllocator allocator;
    private final MemoryLimitController memoryLimitController;
    private final JournalStats journalStats;
    private JournalAliveListener journalAliveListener;

    public static List<Long> listJournalIds(File journalDir, JournalIdFilter filter) {
        File[] logFiles = journalDir.listFiles();
        if (logFiles == null || logFiles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> logs = new ArrayList<Long>();
        for (File f : logFiles) {
            String name = f.getName();
            if (!name.endsWith(".txn")) continue;
            String idString = name.split("\\.")[0];
            long id = Long.parseLong(idString, 16);
            if (filter != null) {
                if (!filter.accept(id)) continue;
                logs.add(id);
                continue;
            }
            logs.add(id);
        }
        Collections.sort(logs);
        return logs;
    }

    private ForceWriteRequest createForceWriteRequest(JournalChannel logFile, long logId, long lastFlushedPosition, RecyclableArrayList<QueueEntry> forceWriteWaiters, boolean shouldClose, boolean isMarker) {
        ForceWriteRequest req = (ForceWriteRequest)this.forceWriteRequestsRecycler.get();
        req.forceWriteWaiters = forceWriteWaiters;
        req.logFile = logFile;
        req.logId = logId;
        req.lastFlushedPosition = lastFlushedPosition;
        req.shouldClose = shouldClose;
        req.isMarker = isMarker;
        req.enqueueTime = MathUtils.nowInNano();
        this.journalStats.getForceWriteQueueSize().inc();
        return req;
    }

    static void writePaddingBytes(JournalChannel jc, ByteBuf paddingBuffer, int journalAlignSize) throws IOException {
        int bytesToAlign = (int)(jc.bc.position() % (long)journalAlignSize);
        if (0 != bytesToAlign) {
            int paddingBytes = journalAlignSize - bytesToAlign;
            paddingBytes = paddingBytes < 8 ? journalAlignSize - (8 - paddingBytes) : (paddingBytes -= 8);
            paddingBuffer.clear();
            paddingBuffer.writeInt(-256);
            paddingBuffer.writeInt(paddingBytes);
            paddingBuffer.writerIndex(paddingBuffer.writerIndex() + paddingBytes);
            jc.preAllocIfNeeded(paddingBuffer.readableBytes());
            jc.bc.write(paddingBuffer);
        }
    }

    public Journal(int journalIndex, File journalDirectory, ServerConfiguration conf, LedgerDirsManager ledgerDirsManager) {
        this(journalIndex, journalDirectory, conf, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE, (ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    }

    public Journal(int journalIndex, File journalDirectory, ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator) {
        super(journalThreadName + "-" + conf.getBookiePort());
        this.allocator = allocator;
        StatsLogger journalStatsLogger = statsLogger.scopeLabel("journalIndex", String.valueOf(journalIndex));
        if (conf.isBusyWaitEnabled()) {
            this.queue = new BlockingMpscQueue(conf.getJournalQueueSize());
            this.forceWriteRequests = new BlockingMpscQueue(conf.getJournalQueueSize());
        } else {
            this.queue = new ArrayBlockingQueue<QueueEntry>(conf.getJournalQueueSize());
            this.forceWriteRequests = new ArrayBlockingQueue<ForceWriteRequest>(conf.getJournalQueueSize());
        }
        long journalMaxMemory = conf.getJournalMaxMemorySizeMb() / (long)conf.getJournalDirNames().length * 1024L * 1024L;
        this.memoryLimitController = new MemoryLimitController(journalMaxMemory);
        this.ledgerDirsManager = ledgerDirsManager;
        this.conf = conf;
        this.journalDirectory = journalDirectory;
        this.maxJournalSize = conf.getMaxJournalSizeMB() * 0x100000L;
        this.journalPreAllocSize = (long)conf.getJournalPreAllocSizeMB() * 0x100000L;
        this.journalWriteBufferSize = conf.getJournalWriteBufferSizeKB() * 1024;
        this.syncData = conf.getJournalSyncData();
        this.maxBackupJournals = conf.getMaxBackupJournals();
        this.forceWriteThread = new ForceWriteThread((Thread)((Object)this), conf.getJournalAdaptiveGroupWrites(), journalStatsLogger);
        this.maxGroupWaitInNanos = TimeUnit.MILLISECONDS.toNanos(conf.getJournalMaxGroupWaitMSec());
        this.bufferedWritesThreshold = conf.getJournalBufferedWritesThreshold();
        this.bufferedEntriesThreshold = conf.getJournalBufferedEntriesThreshold();
        this.journalFormatVersionToWrite = conf.getJournalFormatVersionToWrite();
        this.journalAlignmentSize = conf.getJournalAlignmentSize();
        this.journalPageCacheFlushIntervalMSec = conf.getJournalPageCacheFlushIntervalMSec();
        if (conf.getNumJournalCallbackThreads() > 0) {
            this.cbThreadPool = Executors.newFixedThreadPool(conf.getNumJournalCallbackThreads(), new CbThreadFactory());
            this.callbackTime = journalStatsLogger.getThreadScopedCounter("callback-thread-time");
        } else {
            this.cbThreadPool = MoreExecutors.newDirectExecutorService();
            this.callbackTime = journalStatsLogger.getThreadScopedCounter("callback-time");
        }
        this.journalTime = journalStatsLogger.getThreadScopedCounter("journal-thread-time");
        this.flushWhenQueueEmpty = this.maxGroupWaitInNanos <= 0L || conf.getJournalFlushWhenQueueEmpty();
        this.removePagesFromCache = conf.getJournalRemovePagesFromCache();
        this.lastMarkFileName = conf.getJournalDirs().length == 1 ? LAST_MARK_DEFAULT_NAME : "lastMark." + journalIndex;
        this.lastLogMark.readLog();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Last Log Mark : {}", (Object)this.lastLogMark.getCurMark());
        }
        try {
            this.fileChannelProvider = FileChannelProvider.newProvider(conf.getJournalChannelProvider());
        }
        catch (IOException e) {
            LOG.error("Failed to initiate file channel provider: {}", (Object)conf.getJournalChannelProvider());
            throw new RuntimeException(e);
        }
        this.journalStats = new JournalStats(journalStatsLogger, journalMaxMemory, () -> this.memoryLimitController.currentUsage());
    }

    public Journal(int journalIndex, File journalDirectory, ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger, ByteBufAllocator allocator, JournalAliveListener journalAliveListener) {
        this(journalIndex, journalDirectory, conf, ledgerDirsManager, statsLogger, allocator);
        this.journalAliveListener = journalAliveListener;
    }

    JournalStats getJournalStats() {
        return this.journalStats;
    }

    public File getJournalDirectory() {
        return this.journalDirectory;
    }

    public LastLogMark getLastLogMark() {
        return this.lastLogMark;
    }

    void setLastLogMark(Long id, long scanOffset) {
        this.lastLogMark.setCurLogMark(id, scanOffset);
    }

    @Override
    public CheckpointSource.Checkpoint newCheckpoint() {
        return new LogMarkCheckpoint(this.lastLogMark.markLog());
    }

    @Override
    public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        List<Long> logs;
        if (!(checkpoint instanceof LogMarkCheckpoint)) {
            return;
        }
        LogMarkCheckpoint lmcheckpoint = (LogMarkCheckpoint)checkpoint;
        LastLogMark mark = lmcheckpoint.mark;
        mark.rollLog(mark);
        if (compact && (logs = Journal.listJournalIds(this.journalDirectory, new JournalRollingFilter(mark))).size() >= this.maxBackupJournals) {
            int maxIdx = logs.size() - this.maxBackupJournals;
            for (int i = 0; i < maxIdx; ++i) {
                long id = logs.get(i);
                if (id >= mark.getCurMark().getLogFileId()) continue;
                File journalFile = new File(this.journalDirectory, Long.toHexString(id) + ".txn");
                if (!journalFile.delete()) {
                    LOG.warn("Could not delete old journal file {}", (Object)journalFile);
                }
                LOG.info("garbage collected journal " + journalFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scanJournal(long journalId, long journalPos, JournalScanner scanner, boolean skipInvalidRecord) throws IOException {
        JournalChannel recLog = journalPos <= 0L ? new JournalChannel(this.journalDirectory, journalId, this.journalPreAllocSize, this.journalWriteBufferSize, this.conf, this.fileChannelProvider) : new JournalChannel(this.journalDirectory, journalId, this.journalPreAllocSize, this.journalWriteBufferSize, journalPos, this.conf, this.fileChannelProvider);
        int journalVersion = recLog.getFormatVersion();
        try {
            ByteBuffer lenBuff = ByteBuffer.allocate(4);
            ByteBuffer recBuff = ByteBuffer.allocate(65536);
            while (true) {
                long offset = recLog.fc.position();
                lenBuff.clear();
                Journal.fullRead(recLog, lenBuff);
                if (lenBuff.remaining() != 0) break;
                lenBuff.flip();
                int len = lenBuff.getInt();
                if (len == 0) break;
                boolean isPaddingRecord = false;
                if (len < 0) {
                    if (len == -256 && journalVersion >= 5) {
                        lenBuff.clear();
                        Journal.fullRead(recLog, lenBuff);
                        if (lenBuff.remaining() != 0) break;
                        lenBuff.flip();
                        len = lenBuff.getInt();
                        if (len == 0) continue;
                        isPaddingRecord = true;
                    } else {
                        LOG.error("Invalid record found with negative length: {}", (Object)len);
                        throw new IOException("Invalid record found with negative length " + len);
                    }
                }
                recBuff.clear();
                if (recBuff.remaining() < len) {
                    recBuff = ByteBuffer.allocate(len);
                }
                recBuff.limit(len);
                if (Journal.fullRead(recLog, recBuff) != len) break;
                recBuff.flip();
                if (isPaddingRecord) continue;
                scanner.process(journalVersion, offset, recBuff);
            }
            long l = recLog.fc.position();
            return l;
        }
        catch (IOException e) {
            if (!skipInvalidRecord) {
                throw e;
            }
            LOG.warn("Failed to parse journal file, and skipInvalidRecord is true, skip this journal file reply");
            long l = recLog.fc.position();
            return l;
        }
        finally {
            recLog.close();
        }
    }

    public void logAddEntry(ByteBuffer entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) throws InterruptedException {
        this.logAddEntry(Unpooled.wrappedBuffer((ByteBuffer)entry), ackBeforeSync, cb, ctx);
    }

    public void logAddEntry(ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) throws InterruptedException {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        this.logAddEntry(ledgerId, entryId, entry, ackBeforeSync, cb, ctx);
    }

    @VisibleForTesting
    public void logAddEntry(long ledgerId, long entryId, ByteBuf entry, boolean ackBeforeSync, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) throws InterruptedException {
        entry.retain();
        this.journalStats.getJournalQueueSize().inc();
        this.journalStats.getJournalCbQueueSize().inc();
        this.memoryLimitController.reserveMemory((long)entry.readableBytes());
        this.queue.put(QueueEntry.create(entry, ackBeforeSync, ledgerId, entryId, cb, ctx, MathUtils.nowInNano(), this.journalStats.getJournalAddEntryStats(), this.journalStats.getJournalCbQueueSize(), this.journalStats.getCbThreadPoolQueueSize(), this.journalStats.getJournalCbQueuedLatency(), this.callbackTime));
    }

    void forceLedger(long ledgerId, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx) {
        this.queue.add(QueueEntry.create(null, false, ledgerId, -16384L, cb, ctx, MathUtils.nowInNano(), this.journalStats.getJournalForceLedgerStats(), this.journalStats.getJournalCbQueueSize(), this.journalStats.getCbThreadPoolQueueSize(), this.journalStats.getJournalCbQueuedLatency(), this.callbackTime));
        this.journalStats.getJournalQueueSize().inc();
        this.journalStats.getJournalCbQueueSize().inc();
    }

    public int getJournalQueueLength() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LOG.info("Starting journal on {}", (Object)this.journalDirectory);
        ThreadRegistry.register((String)journalThreadName, (int)0);
        if (this.conf.isBusyWaitEnabled()) {
            try {
                CpuAffinity.acquireCore();
            }
            catch (Exception e) {
                LOG.warn("Unable to acquire CPU core for Journal thread: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        RecyclableArrayList toFlush = entryListRecycler.newInstance();
        int numEntriesToFlush = 0;
        ByteBuf lenBuff = Unpooled.buffer((int)4);
        ByteBuf paddingBuff = Unpooled.buffer((int)(2 * this.conf.getJournalAlignmentSize()));
        paddingBuff.writeZero(paddingBuff.capacity());
        BufferedChannel bc = null;
        JournalChannel logFile = null;
        this.forceWriteThread.start();
        Stopwatch journalCreationWatcher = Stopwatch.createUnstarted();
        Stopwatch journalFlushWatcher = Stopwatch.createUnstarted();
        long batchSize = 0L;
        try {
            List<Long> journalIds = Journal.listJournalIds(this.journalDirectory, null);
            long logId = journalIds.isEmpty() ? System.currentTimeMillis() : journalIds.get(journalIds.size() - 1);
            long lastFlushPosition = 0L;
            boolean groupWhenTimeout = false;
            long dequeueStartTime = 0L;
            long lastFlushTimeMs = System.currentTimeMillis();
            long busyStartTime = System.nanoTime();
            QueueEntry qe = null;
            while (true) {
                if (null == logFile) {
                    journalCreationWatcher.reset().start();
                    logFile = new JournalChannel(this.journalDirectory, ++logId, this.journalPreAllocSize, this.journalWriteBufferSize, this.journalAlignmentSize, this.removePagesFromCache, this.journalFormatVersionToWrite, this.getBufferedChannelBuilder(), this.conf, this.fileChannelProvider);
                    this.journalStats.getJournalCreationStats().registerSuccessfulEvent(journalCreationWatcher.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                    bc = logFile.getBufferedChannel();
                    lastFlushPosition = bc.position();
                }
                if (qe == null) {
                    if (dequeueStartTime != 0L) {
                        this.journalStats.getJournalProcessTimeStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)dequeueStartTime), TimeUnit.NANOSECONDS);
                    }
                    if (numEntriesToFlush == 0) {
                        this.journalTime.add(MathUtils.elapsedNanos((long)busyStartTime));
                        qe = this.queue.take();
                        busyStartTime = dequeueStartTime = MathUtils.nowInNano();
                        this.journalStats.getJournalQueueSize().dec();
                        this.journalStats.getJournalQueueStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)qe.enqueueTime), TimeUnit.NANOSECONDS);
                    } else {
                        long pollWaitTimeNanos = this.maxGroupWaitInNanos - MathUtils.elapsedNanos((long)((QueueEntry)toFlush.get((int)0)).enqueueTime);
                        if (this.flushWhenQueueEmpty || pollWaitTimeNanos < 0L) {
                            pollWaitTimeNanos = 0L;
                        }
                        qe = this.queue.poll(pollWaitTimeNanos, TimeUnit.NANOSECONDS);
                        dequeueStartTime = MathUtils.nowInNano();
                        if (qe != null) {
                            this.journalStats.getJournalQueueSize().dec();
                            this.journalStats.getJournalQueueStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)qe.enqueueTime), TimeUnit.NANOSECONDS);
                        }
                        boolean shouldFlush = false;
                        if (this.maxGroupWaitInNanos > 0L && !groupWhenTimeout && MathUtils.elapsedNanos((long)((QueueEntry)toFlush.get((int)0)).enqueueTime) > this.maxGroupWaitInNanos) {
                            groupWhenTimeout = true;
                        } else if (this.maxGroupWaitInNanos > 0L && groupWhenTimeout && (qe == null || MathUtils.elapsedNanos((long)qe.enqueueTime) < this.maxGroupWaitInNanos)) {
                            groupWhenTimeout = false;
                            shouldFlush = true;
                            this.journalStats.getFlushMaxWaitCounter().inc();
                        } else if (qe != null && (this.bufferedEntriesThreshold > 0L && (long)toFlush.size() > this.bufferedEntriesThreshold || bc.position() > lastFlushPosition + this.bufferedWritesThreshold)) {
                            groupWhenTimeout = false;
                            shouldFlush = true;
                            this.journalStats.getFlushMaxOutstandingBytesCounter().inc();
                        } else if (qe == null && this.flushWhenQueueEmpty) {
                            groupWhenTimeout = false;
                            shouldFlush = true;
                            this.journalStats.getFlushEmptyQueueCounter().inc();
                        }
                        if (shouldFlush) {
                            boolean shouldRolloverJournal;
                            if (this.journalFormatVersionToWrite >= 5) {
                                Journal.writePaddingBytes(logFile, paddingBuff, this.journalAlignmentSize);
                            }
                            journalFlushWatcher.reset().start();
                            bc.flush();
                            for (int i = 0; i < toFlush.size(); ++i) {
                                QueueEntry entry = (QueueEntry)toFlush.get(i);
                                if (entry == null || this.syncData && !entry.ackBeforeSync) continue;
                                toFlush.set(i, null);
                                --numEntriesToFlush;
                                entry.setEnqueueCbThreadPooleQueueTime(MathUtils.nowInNano());
                                this.journalStats.getCbThreadPoolQueueSize().inc();
                                this.cbThreadPool.execute(entry);
                            }
                            lastFlushPosition = bc.position();
                            this.journalStats.getJournalFlushStats().registerSuccessfulEvent(journalFlushWatcher.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
                            if (LOG.isDebugEnabled()) {
                                for (QueueEntry e : toFlush) {
                                    if (e == null) continue;
                                    LOG.debug("Written and queuing for flush Ledger: {}  Entry: {}", (Object)e.ledgerId, (Object)e.entryId);
                                }
                            }
                            this.journalStats.getForceWriteBatchEntriesStats().registerSuccessfulValue((long)numEntriesToFlush);
                            this.journalStats.getForceWriteBatchBytesStats().registerSuccessfulValue(batchSize);
                            boolean bl = shouldRolloverJournal = lastFlushPosition > this.maxJournalSize;
                            if (this.syncData || shouldRolloverJournal || System.currentTimeMillis() - lastFlushTimeMs >= this.journalPageCacheFlushIntervalMSec) {
                                this.forceWriteRequests.put(this.createForceWriteRequest(logFile, logId, lastFlushPosition, (RecyclableArrayList<QueueEntry>)toFlush, shouldRolloverJournal, false));
                                lastFlushTimeMs = System.currentTimeMillis();
                            }
                            toFlush = entryListRecycler.newInstance();
                            numEntriesToFlush = 0;
                            batchSize = 0L;
                            if (shouldRolloverJournal) {
                                logFile = null;
                                continue;
                            }
                        }
                    }
                }
                if (!this.running) {
                    LOG.info("Journal Manager is asked to shut down, quit.");
                    break;
                }
                if (qe == null) continue;
                if (qe.entryId == -32768L && this.journalFormatVersionToWrite < 6) {
                    this.memoryLimitController.releaseMemory((long)qe.entry.readableBytes());
                    qe.entry.release();
                } else if (qe.entryId != -16384L) {
                    int entrySize = qe.entry.readableBytes();
                    this.journalStats.getJournalWriteBytes().add((long)entrySize);
                    batchSize += (long)(4 + entrySize);
                    lenBuff.clear();
                    lenBuff.writeInt(entrySize);
                    logFile.preAllocIfNeeded(4 + entrySize);
                    bc.write(lenBuff);
                    bc.write(qe.entry);
                    this.memoryLimitController.releaseMemory((long)qe.entry.readableBytes());
                    qe.entry.release();
                }
                toFlush.add((Object)qe);
                ++numEntriesToFlush;
                qe = null;
            }
        }
        catch (IOException ioe) {
            LOG.error("I/O exception in Journal thread!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Journal exits when shutting down");
        }
        finally {
            IOUtils.close(LOG, bc);
            if (this.journalAliveListener != null) {
                this.journalAliveListener.onJournalExit();
            }
        }
        LOG.info("Journal exited loop!");
    }

    public BufferedChannelBuilder getBufferedChannelBuilder() {
        return (fc, capacity) -> new BufferedChannel(this.allocator, fc, capacity);
    }

    public synchronized void shutdown() {
        try {
            if (!this.running) {
                return;
            }
            LOG.info("Shutting down Journal");
            if (this.fileChannelProvider != null) {
                this.fileChannelProvider.close();
            }
            this.forceWriteThread.shutdown();
            this.cbThreadPool.shutdown();
            if (!this.cbThreadPool.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warn("Couldn't shutdown journal callback thread gracefully. Forcing");
            }
            this.cbThreadPool.shutdownNow();
            this.running = false;
            this.interrupt();
            this.join();
            LOG.info("Finished Shutting down Journal thread");
        }
        catch (IOException | InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Interrupted during shutting down journal : ", (Throwable)ie);
        }
    }

    private static int fullRead(JournalChannel fc, ByteBuffer bb) throws IOException {
        int total = 0;
        while (bb.remaining() > 0) {
            int rc = fc.read(bb);
            if (rc <= 0) {
                return total;
            }
            total += rc;
        }
        return total;
    }

    @VisibleForTesting
    public void joinThread() throws InterruptedException {
        this.join();
    }

    long getMemoryUsage() {
        return this.memoryLimitController.currentUsage();
    }

    private static class CbThreadFactory
    implements ThreadFactory {
        private int counter = 0;
        private String threadBaseName = "bookie-journal-callback";

        private CbThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int threadOrdinal = this.counter++;
            Thread t = new Thread(r, this.threadBaseName + "-" + threadOrdinal);
            ThreadRegistry.register((String)this.threadBaseName, (int)threadOrdinal, (long)t.getId());
            return t;
        }
    }

    private class ForceWriteThread
    extends BookieCriticalThread {
        volatile boolean running;
        Thread threadToNotifyOnEx;
        private final boolean enableGroupForceWrites;
        private final Counter forceWriteThreadTime;

        public ForceWriteThread(Thread threadToNotifyOnEx, boolean enableGroupForceWrites, StatsLogger statsLogger) {
            super("ForceWriteThread");
            this.running = true;
            this.threadToNotifyOnEx = threadToNotifyOnEx;
            this.enableGroupForceWrites = enableGroupForceWrites;
            this.forceWriteThreadTime = statsLogger.getThreadScopedCounter("force-write-thread-time");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            LOG.info("ForceWrite Thread started");
            ThreadRegistry.register((String)super.getName(), (int)0);
            if (Journal.this.conf.isBusyWaitEnabled()) {
                try {
                    CpuAffinity.acquireCore();
                }
                catch (Exception e) {
                    LOG.warn("Unable to acquire CPU core for Journal ForceWrite thread: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            boolean shouldForceWrite = true;
            int numReqInLastForceWrite = 0;
            long busyStartTime = System.nanoTime();
            boolean forceWriteMarkerSent = false;
            while (this.running) {
                ForceWriteRequest req = null;
                try {
                    this.forceWriteThreadTime.add(MathUtils.elapsedNanos((long)busyStartTime));
                    req = Journal.this.forceWriteRequests.take();
                    busyStartTime = System.nanoTime();
                    if (!req.isMarker && shouldForceWrite) {
                        ForceWriteRequest marker;
                        if (this.enableGroupForceWrites && !(forceWriteMarkerSent = Journal.this.forceWriteRequests.offer(marker = Journal.this.createForceWriteRequest(req.logFile, 0L, 0L, (RecyclableArrayList<QueueEntry>)null, false, true)))) {
                            marker.recycle();
                            Counter failures = Journal.this.journalStats.getForceWriteGroupingFailures();
                            failures.inc();
                            LOG.error("Fail to send force write grouping marker, Journal.forceWriteRequests queue(capacity {}) is full, current failure counter is {}.", (Object)Journal.this.conf.getJournalQueueSize(), (Object)failures.get());
                        }
                        if (numReqInLastForceWrite > 0) {
                            Journal.this.journalStats.getForceWriteGroupingCountStats().registerSuccessfulValue((long)numReqInLastForceWrite);
                            numReqInLastForceWrite = 0;
                        }
                    }
                    numReqInLastForceWrite += req.process(shouldForceWrite);
                    shouldForceWrite = !this.enableGroupForceWrites || req.isMarker || !forceWriteMarkerSent || req.shouldClose;
                    if (req == null) continue;
                }
                catch (IOException ioe) {
                    LOG.error("I/O exception in ForceWrite thread", (Throwable)ioe);
                    this.running = false;
                    if (req == null) continue;
                    req.recycle();
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.info("ForceWrite thread interrupted");
                    if (null != req) {
                        req.shouldClose = true;
                        req.closeFileIfNecessary();
                    }
                    this.running = false;
                    if (req == null) continue;
                    {
                        catch (Throwable throwable) {
                            if (req != null) {
                                req.recycle();
                            }
                            throw throwable;
                        }
                    }
                    req.recycle();
                    continue;
                }
                req.recycle();
            }
            this.threadToNotifyOnEx.interrupt();
        }

        void shutdown() throws InterruptedException {
            this.running = false;
            this.interrupt();
            this.join();
        }
    }

    @VisibleForTesting
    public class ForceWriteRequest {
        private JournalChannel logFile;
        private RecyclableArrayList<QueueEntry> forceWriteWaiters;
        private boolean shouldClose;
        private boolean isMarker;
        private long lastFlushedPosition;
        private long logId;
        private long enqueueTime;
        private final Recycler.Handle<ForceWriteRequest> recyclerHandle;

        public int process(boolean shouldForceWrite) throws IOException {
            Journal.this.journalStats.getForceWriteQueueSize().dec();
            Journal.this.journalStats.getFwEnqueueTimeStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueTime), TimeUnit.NANOSECONDS);
            if (this.isMarker) {
                return 0;
            }
            long startTime = MathUtils.nowInNano();
            try {
                int i;
                if (shouldForceWrite) {
                    this.logFile.forceWrite(false);
                    Journal.this.journalStats.getJournalSyncStats().registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTime), TimeUnit.NANOSECONDS);
                }
                Journal.this.lastLogMark.setCurLogMark(this.logId, this.lastFlushedPosition);
                for (i = 0; i < this.forceWriteWaiters.size(); ++i) {
                    QueueEntry qe = (QueueEntry)this.forceWriteWaiters.get(i);
                    if (qe == null) continue;
                    qe.setEnqueueCbThreadPooleQueueTime(MathUtils.nowInNano());
                    Journal.this.journalStats.getCbThreadPoolQueueSize().inc();
                    Journal.this.cbThreadPool.execute(qe);
                }
                i = this.forceWriteWaiters.size();
                return i;
            }
            catch (IOException e) {
                Journal.this.journalStats.getJournalSyncStats().registerFailedEvent(MathUtils.elapsedNanos((long)startTime), TimeUnit.NANOSECONDS);
                throw e;
            }
            finally {
                this.closeFileIfNecessary();
            }
        }

        public void closeFileIfNecessary() {
            if (this.shouldClose) {
                try {
                    this.logFile.close();
                    this.shouldClose = false;
                }
                catch (IOException ioe) {
                    LOG.error("I/O exception while closing file", (Throwable)ioe);
                }
            }
        }

        private ForceWriteRequest(Recycler.Handle<ForceWriteRequest> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        private void recycle() {
            this.logFile = null;
            if (this.forceWriteWaiters != null) {
                this.forceWriteWaiters.recycle();
                this.forceWriteWaiters = null;
            }
            this.recyclerHandle.recycle((Object)this);
        }
    }

    static class QueueEntry
    implements Runnable {
        ByteBuf entry;
        long ledgerId;
        long entryId;
        BookkeeperInternalCallbacks.WriteCallback cb;
        Object ctx;
        long enqueueTime;
        long enqueueCbThreadPooleQueueTime;
        boolean ackBeforeSync;
        OpStatsLogger journalAddEntryStats;
        OpStatsLogger journalCbQueuedLatency;
        Counter journalCbQueueSize;
        Counter cbThreadPoolQueueSize;
        Counter callbackTime;
        private final Recycler.Handle<QueueEntry> recyclerHandle;
        private static final Recycler<QueueEntry> RECYCLER = new Recycler<QueueEntry>(){

            protected QueueEntry newObject(Recycler.Handle<QueueEntry> handle) {
                return new QueueEntry(handle);
            }
        };

        static QueueEntry create(ByteBuf entry, boolean ackBeforeSync, long ledgerId, long entryId, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, long enqueueTime, OpStatsLogger journalAddEntryStats, Counter journalCbQueueSize, Counter cbThreadPoolQueueSize, OpStatsLogger journalCbQueuedLatency, Counter callbackTime) {
            QueueEntry qe = (QueueEntry)RECYCLER.get();
            qe.entry = entry;
            qe.ackBeforeSync = ackBeforeSync;
            qe.cb = cb;
            qe.ctx = ctx;
            qe.ledgerId = ledgerId;
            qe.entryId = entryId;
            qe.enqueueTime = enqueueTime;
            qe.journalAddEntryStats = journalAddEntryStats;
            qe.journalCbQueuedLatency = journalCbQueuedLatency;
            qe.journalCbQueueSize = journalCbQueueSize;
            qe.cbThreadPoolQueueSize = cbThreadPoolQueueSize;
            qe.callbackTime = callbackTime;
            return qe;
        }

        public void setEnqueueCbThreadPooleQueueTime(long enqueueCbThreadPooleQueueTime) {
            this.enqueueCbThreadPooleQueueTime = enqueueCbThreadPooleQueueTime;
        }

        @Override
        public void run() {
            this.journalCbQueuedLatency.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueCbThreadPooleQueueTime), TimeUnit.NANOSECONDS);
            long startTime = System.nanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acknowledge Ledger: {}, Entry: {}", (Object)this.ledgerId, (Object)this.entryId);
            }
            this.journalCbQueueSize.dec();
            this.cbThreadPoolQueueSize.dec();
            this.journalAddEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueTime), TimeUnit.NANOSECONDS);
            this.cb.writeComplete(0, this.ledgerId, this.entryId, null, this.ctx);
            this.callbackTime.add(MathUtils.elapsedNanos((long)startTime));
            this.recycle();
        }

        private QueueEntry(Recycler.Handle<QueueEntry> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        private void recycle() {
            this.entry = null;
            this.cb = null;
            this.ctx = null;
            this.journalAddEntryStats = null;
            this.journalCbQueuedLatency = null;
            this.journalCbQueueSize = null;
            this.cbThreadPoolQueueSize = null;
            this.callbackTime = null;
            this.recyclerHandle.recycle((Object)this);
        }
    }

    public static interface JournalScanner {
        public void process(int var1, long var2, ByteBuffer var4) throws IOException;
    }

    private static class JournalRollingFilter
    implements JournalIdFilter {
        final LastLogMark lastMark;

        JournalRollingFilter(LastLogMark lastMark) {
            this.lastMark = lastMark;
        }

        @Override
        public boolean accept(long journalId) {
            return journalId < this.lastMark.getCurMark().getLogFileId();
        }
    }

    public class LastLogMark {
        private final LogMark curMark;

        LastLogMark(long logId, long logPosition) {
            this.curMark = new LogMark(logId, logPosition);
        }

        void setCurLogMark(long logId, long logPosition) {
            this.curMark.setLogMark(logId, logPosition);
        }

        LastLogMark markLog() {
            return new LastLogMark(this.curMark.getLogFileId(), this.curMark.getLogFileOffset());
        }

        public LogMark getCurMark() {
            return this.curMark;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void rollLog(LastLogMark lastMark) throws LedgerDirsManager.NoWritableLedgerDirException {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            lastMark.getCurMark().writeLogMark(bb);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RollLog to persist last marked log : {}", (Object)lastMark.getCurMark());
            }
            List<File> writableLedgerDirs = Journal.this.ledgerDirsManager.getWritableLedgerDirsForNewLog();
            for (File dir : writableLedgerDirs) {
                File file = new File(dir, Journal.this.lastMarkFileName);
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(file);
                    fos.write(buff);
                    fos.getChannel().force(true);
                    fos.close();
                    fos = null;
                }
                catch (IOException e) {
                    LOG.error("Problems writing to " + file, (Throwable)e);
                }
                finally {
                    IOUtils.close(LOG, (Closeable)fos);
                }
            }
        }

        public void readLog() {
            byte[] buff = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(buff);
            LogMark mark = new LogMark();
            for (File dir : Journal.this.ledgerDirsManager.getAllLedgerDirs()) {
                File file = new File(dir, Journal.this.lastMarkFileName);
                try {
                    try (FileInputStream fis = new FileInputStream(file);){
                        int bytesRead = fis.read(buff);
                        if (bytesRead != 16) {
                            throw new IOException("Couldn't read enough bytes from lastMark. Wanted 16, got " + bytesRead);
                        }
                    }
                    bb.clear();
                    mark.readLogMark(bb);
                    if (this.curMark.compare(mark) >= 0) continue;
                    this.curMark.setLogMark(mark.getLogFileId(), mark.getLogFileOffset());
                }
                catch (IOException e) {
                    LOG.error("Problems reading from " + file + " (this is okay if it is the first time starting this bookie");
                }
            }
        }

        public String toString() {
            return this.curMark.toString();
        }
    }

    private static class LogMarkCheckpoint
    implements CheckpointSource.Checkpoint {
        final LastLogMark mark;

        public LogMarkCheckpoint(LastLogMark checkpoint) {
            this.mark = checkpoint;
        }

        @Override
        public int compareTo(CheckpointSource.Checkpoint o) {
            if (o == CheckpointSource.Checkpoint.MAX) {
                return -1;
            }
            if (o == CheckpointSource.Checkpoint.MIN) {
                return 1;
            }
            return this.mark.getCurMark().compare(((LogMarkCheckpoint)o).mark.getCurMark());
        }

        public boolean equals(Object o) {
            if (!(o instanceof LogMarkCheckpoint)) {
                return false;
            }
            return 0 == this.compareTo((LogMarkCheckpoint)o);
        }

        public int hashCode() {
            return this.mark.hashCode();
        }

        public String toString() {
            return this.mark.toString();
        }
    }

    @FunctionalInterface
    public static interface BufferedChannelBuilder {
        public static final BufferedChannelBuilder DEFAULT_BCBUILDER = (fc, capacity) -> new BufferedChannel((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, fc, capacity);

        public BufferedChannel create(FileChannel var1, int var2) throws IOException;
    }

    public static interface JournalIdFilter {
        public boolean accept(long var1);
    }
}

