/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.ZooKeeperMain;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveWatchesCmdTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveWatchesCmdTest.class);
    private ZooKeeper zk;
    private ZooKeeperMain zkMain;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
        this.zkMain = new ZooKeeperMain(this.zk);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        if (this.zk != null) {
            this.zk.close();
        }
        super.tearDown();
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveWatchesWithNoPassedOptions() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 2);
        this.zk.create("/testnode1", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/testnode2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Adding childwatcher to /testnode1 and /testnode2");
        this.zk.getChildren("/testnode1", (Watcher)myWatcher);
        this.zk.getChildren("/testnode2", (Watcher)myWatcher);
        LOG.info("Adding datawatcher to /testnode1 and /testnode2");
        this.zk.getData("/testnode1", (Watcher)myWatcher, null);
        this.zk.getData("/testnode2", (Watcher)myWatcher, null);
        String cmdstring = "removewatches /testnode1";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove child watches");
        LOG.info("Waiting for the DataWatchRemoved event");
        myWatcher.matches();
        Assertions.assertTrue((boolean)this.zk.getChildWatches().contains("/testnode2"), (String)"Failed to find child watches for the path testnode2");
        Assertions.assertTrue((boolean)this.zk.getDataWatches().contains("/testnode2"), (String)"Failed to find data watches for the path testnode2");
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveNodeDataChangedWatches() throws Exception {
        LOG.info("Adding data watcher using getData()");
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getData("/testnode1", (Watcher)myWatcher, null);
        String cmdstring = "removewatches /testnode1 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove data watches");
        LOG.info("Waiting for the DataWatchRemoved event");
        myWatcher.matches();
        Assertions.assertEquals((int)0, (int)this.zk.getDataWatches().size(), (String)("Data watches are not removed : " + this.zk.getDataWatches()));
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveNodeCreatedWatches() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.DataWatchRemoved);
        MyWatcher myWatcher1 = new MyWatcher("/testnode1", expectedEvents, 1);
        MyWatcher myWatcher2 = new MyWatcher("/testnode1/testnode2", expectedEvents, 1);
        LOG.info("Adding NodeCreated watcher");
        this.zk.exists("/testnode1", (Watcher)myWatcher1);
        this.zk.exists("/testnode1/testnode2", (Watcher)myWatcher2);
        String cmdstring1 = "removewatches /testnode1 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring1);
        this.zkMain.cl.parseCommand(cmdstring1);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove pre-create watches");
        myWatcher1.matches();
        Assertions.assertEquals((int)1, (int)this.zk.getExistWatches().size(), (String)("Failed to remove pre-create watches :" + this.zk.getExistWatches()));
        Assertions.assertTrue((boolean)this.zk.getExistWatches().contains("/testnode1/testnode2"), (String)("Failed to remove pre-create watches :" + this.zk.getExistWatches()));
        String cmdstring2 = "removewatches /testnode1/testnode2 -d";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring2);
        this.zkMain.cl.parseCommand(cmdstring2);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove data watches");
        myWatcher2.matches();
        Assertions.assertEquals((int)0, (int)this.zk.getExistWatches().size(), (String)("Failed to remove pre-create watches : " + this.zk.getExistWatches()));
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveNodeChildrenChangedWatches() throws Exception {
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        LOG.info("Adding child changed watcher");
        this.zk.getChildren("/testnode1", (Watcher)myWatcher);
        String cmdstring = "removewatches /testnode1 -c";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove child watches");
        myWatcher.matches();
        Assertions.assertEquals((int)0, (int)this.zk.getChildWatches().size(), (String)("Failed to remove child watches : " + this.zk.getChildWatches()));
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveNodeDeletedWatches() throws Exception {
        LOG.info("Adding NodeDeleted watcher");
        ArrayList<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();
        expectedEvents.add(Watcher.Event.EventType.ChildWatchRemoved);
        expectedEvents.add(Watcher.Event.EventType.NodeDeleted);
        MyWatcher myWatcher = new MyWatcher("/testnode1", expectedEvents, 1);
        this.zk.create("/testnode1", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.create("/testnode1/testnode2", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getChildren("/testnode1/testnode2", (Watcher)myWatcher);
        this.zk.getChildren("/testnode1", (Watcher)myWatcher);
        String cmdstring = "removewatches /testnode1 -c";
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove child watches");
        LOG.info("Waiting for the ChildWatchRemoved event");
        myWatcher.matches();
        Assertions.assertEquals((int)1, (int)this.zk.getChildWatches().size(), (String)("Failed to remove child watches : " + this.zk.getChildWatches()));
        Assertions.assertTrue((boolean)this.zk.getChildWatches().contains("/testnode1/testnode2"), (String)("Failed to remove child watches :" + this.zk.getChildWatches()));
        this.zk.delete("/testnode1/testnode2", -1);
        myWatcher.matches();
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveAnyWatches() throws Exception {
        this.verifyRemoveAnyWatches(false);
    }

    @Test
    @Timeout(value=30L)
    public void testRemoveWatchesLocallyWhenNoServerConnection() throws Exception {
        this.verifyRemoveAnyWatches(true);
    }

    private void verifyRemoveAnyWatches(boolean local) throws Exception {
        final HashMap pathVsEvent = new HashMap();
        LOG.info("Adding NodeChildrenChanged, NodeDataChanged watchers");
        final CountDownLatch watcherLatch = new CountDownLatch(2);
        Watcher watcher = new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getType()) {
                    case ChildWatchRemoved: 
                    case DataWatchRemoved: {
                        this.addWatchNotifications(pathVsEvent, event);
                        watcherLatch.countDown();
                        break;
                    }
                    case NodeChildrenChanged: 
                    case NodeDataChanged: {
                        this.addWatchNotifications(pathVsEvent, event);
                    }
                }
            }

            private void addWatchNotifications(Map<String, List<Watcher.Event.EventType>> pathVsEvent2, WatchedEvent event) {
                pathVsEvent2.computeIfAbsent(event.getPath(), k -> new ArrayList()).add(event.getType());
            }
        };
        this.zk.create("/testnode1", "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zk.getChildren("/testnode1", watcher);
        this.zk.getData("/testnode1", watcher, null);
        String cmdstring = "removewatches /testnode1 -a";
        if (local) {
            LOG.info("Stopping ZK server to verify deletion of watches locally");
            this.stopServer();
            cmdstring = "removewatches /testnode1 -a -l";
        }
        LOG.info("Remove watchers using shell command : {}", (Object)cmdstring);
        this.zkMain.cl.parseCommand(cmdstring);
        Assertions.assertTrue((boolean)this.zkMain.processZKCmd(this.zkMain.cl), (String)"Removewatches cmd fails to remove child/data watches");
        LOG.info("Waiting for the WatchRemoved events");
        watcherLatch.await(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)pathVsEvent.size(), (String)"Didn't receives WatchRemoved events!");
        Assertions.assertTrue((boolean)((List)pathVsEvent.get("/testnode1")).contains(Watcher.Event.EventType.DataWatchRemoved), (String)"Didn't receives DataWatchRemoved!");
        Assertions.assertTrue((boolean)((List)pathVsEvent.get("/testnode1")).contains(Watcher.Event.EventType.ChildWatchRemoved), (String)"Didn't receives ChildWatchRemoved!");
    }

    private static class MyWatcher
    implements Watcher {
        private final String path;
        private String eventPath;
        private final CountDownLatch latch;
        private final List<Watcher.Event.EventType> expectedEvents = new ArrayList<Watcher.Event.EventType>();

        MyWatcher(String path, List<Watcher.Event.EventType> expectedEvents, int count) {
            this.path = path;
            this.latch = new CountDownLatch(count);
            this.expectedEvents.addAll(expectedEvents);
        }

        public void process(WatchedEvent event) {
            LOG.debug("Event path : {}, eventPath : {}", (Object)this.path, (Object)event.getPath());
            this.eventPath = event.getPath();
            if (this.expectedEvents.contains(event.getType())) {
                this.latch.countDown();
            }
        }

        public boolean matches() throws InterruptedException {
            if (!this.latch.await(ClientBase.CONNECTION_TIMEOUT / 3, TimeUnit.MILLISECONDS)) {
                LOG.error("Failed to get watch notifications!");
                return false;
            }
            LOG.debug("Client path : {} eventPath : {}", (Object)this.path, (Object)this.eventPath);
            return this.path.equals(this.eventPath);
        }
    }
}

