/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.Quotes;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.TemplateApplier;
import org.inferred.freebuilder.processor.source.feature.GuavaLibrary;
import org.inferred.freebuilder.shaded.com.google.common.base.Preconditions;

public class PreconditionExcerpts {
    private static final Pattern ANY_OPERATOR = Pattern.compile("[+=<>!&^|?:]|\\binstanceof\\b");
    private static final Pattern BOOLEAN_BINARY_OPERATOR = Pattern.compile("&&|\\|\\|");

    public static Excerpt checkArgument(String conditionTemplate, String messageTemplate, Object ... args) {
        return new GuavaCheckExcerpt("checkArgument", conditionTemplate, messageTemplate, args, IllegalArgumentException.class);
    }

    public static Excerpt checkState(String conditionTemplate, String messageTemplate, Object ... args) {
        return new GuavaCheckExcerpt("checkState", conditionTemplate, messageTemplate, args, IllegalStateException.class);
    }

    private static String negate(String conditionTemplate) {
        if (conditionTemplate.startsWith("!") && !BOOLEAN_BINARY_OPERATOR.matcher(conditionTemplate).find()) {
            return conditionTemplate.substring(1);
        }
        if (ANY_OPERATOR.matcher(conditionTemplate).find()) {
            return "!(" + conditionTemplate + ")";
        }
        return "!" + conditionTemplate;
    }

    private PreconditionExcerpts() {
    }

    private static final class GuavaCheckExcerpt
    implements Excerpt {
        private final String methodName;
        private final String condition;
        private final String message;
        private final Object[] args;
        private final Class<? extends RuntimeException> exceptionType;

        private GuavaCheckExcerpt(String methodName, String condition, String message, Object[] args, Class<? extends RuntimeException> exceptionType) {
            this.args = args;
            this.condition = condition;
            this.message = message;
            this.methodName = methodName;
            this.exceptionType = exceptionType;
        }

        @Override
        public void addTo(SourceBuilder code) {
            if (code.feature(GuavaLibrary.GUAVA).isAvailable()) {
                this.addGuavaTo(code);
            } else {
                this.addIfBlockTo(code);
            }
        }

        private void addIfBlockTo(SourceBuilder code) {
            TemplateApplier templateApplier = TemplateApplier.withParams(this.args);
            code.add("if (", new Object[0]);
            templateApplier.onText((csq, start, end) -> code.add("%s", csq.subSequence(start, end))).onParam(param -> code.add("%s", param)).parse(PreconditionExcerpts.negate(this.condition));
            code.addLine(") {", new Object[0]).add("  throw new %s(", this.exceptionType);
            AtomicBoolean inString = new AtomicBoolean(false);
            AtomicBoolean needsSeparator = new AtomicBoolean(false);
            templateApplier.onText((csq, start, end) -> {
                if (!inString.getAndSet(true)) {
                    if (needsSeparator.getAndSet(true)) {
                        code.add(" + ", new Object[0]);
                    }
                    code.add("\"", new Object[0]);
                }
                code.add("%s", Quotes.escapeJava(csq.subSequence(start, end).toString()));
            }).onParam(param -> {
                if (inString.getAndSet(false)) {
                    code.add("\"", new Object[0]);
                }
                if (needsSeparator.getAndSet(true)) {
                    code.add(" + ", new Object[0]);
                }
                code.add("%s", param);
            }).parse(this.message);
            if (inString.get()) {
                code.add("\"", new Object[0]);
            }
            code.addLine(");", new Object[0]).addLine("}", new Object[0]);
        }

        private void addGuavaTo(SourceBuilder code) {
            TemplateApplier templateApplier = TemplateApplier.withParams(this.args);
            code.add("%s.%s(", Preconditions.class, this.methodName);
            templateApplier.onText((csq, start, end) -> code.add("%s", csq.subSequence(start, end))).onParam(param -> code.add("%s", param)).parse(this.condition);
            code.add(", \"", new Object[0]);
            ArrayList templateArgs = new ArrayList();
            templateApplier.onText((csq, start, end) -> code.add("%s", Quotes.escapeJava(csq.subSequence(start, end).toString().replaceAll("%", "%%")))).onParam(param -> {
                templateArgs.add(param);
                code.add("%%s", new Object[0]);
            }).parse(this.message);
            code.add("\"", new Object[0]);
            for (Object arg : templateArgs) {
                code.add(", %s", arg);
            }
            code.add(");\n", new Object[0]);
        }
    }
}

