/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.util.AdHash;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdHashTest
extends ZKTestCase {
    private static Random rand = new Random();

    private static List<Long> generateRandomHashes(int count) {
        ArrayList<Long> list = new ArrayList<Long>(count);
        for (int i = 0; i < count; ++i) {
            list.add(rand.nextLong());
        }
        return list;
    }

    private static void addListOfDigests(AdHash hash, List<Long> digests) {
        for (long b : digests) {
            hash.addDigest(b);
        }
    }

    private static void removeListOfDigests(AdHash hash, List<Long> digests) {
        for (long b : digests) {
            hash.removeDigest(b);
        }
    }

    @Test
    public void testAdHash() throws Exception {
        List<Long> bucket1 = AdHashTest.generateRandomHashes(50);
        List<Long> bucket2 = AdHashTest.generateRandomHashes(3);
        List<Long> bucket3 = AdHashTest.generateRandomHashes(30);
        List<Long> bucket4 = AdHashTest.generateRandomHashes(10);
        List<Long> bucket5 = AdHashTest.generateRandomHashes(5);
        AdHash hash12 = new AdHash();
        AdHashTest.addListOfDigests(hash12, bucket1);
        AdHashTest.addListOfDigests(hash12, bucket2);
        AdHash hash21 = new AdHash();
        AdHashTest.addListOfDigests(hash21, bucket2);
        AdHashTest.addListOfDigests(hash21, bucket1);
        Assertions.assertEquals((Object)hash12, (Object)hash21);
        AdHash hashall = new AdHash();
        AdHashTest.addListOfDigests(hashall, bucket1);
        AdHashTest.addListOfDigests(hashall, bucket2);
        AdHashTest.addListOfDigests(hashall, bucket3);
        AdHashTest.addListOfDigests(hashall, bucket4);
        AdHashTest.addListOfDigests(hashall, bucket5);
        Assertions.assertFalse((boolean)hashall.equals((Object)hash21), (String)"digest of different set not different");
        AdHashTest.removeListOfDigests(hashall, bucket4);
        AdHashTest.removeListOfDigests(hashall, bucket5);
        AdHashTest.addListOfDigests(hash21, bucket3);
        Assertions.assertEquals((Object)hashall, (Object)hash21, (String)"hashall with 4 & 5 removed should match hash21 with 3 added");
        AdHashTest.removeListOfDigests(hashall, bucket3);
        AdHashTest.removeListOfDigests(hashall, bucket2);
        AdHashTest.removeListOfDigests(hashall, bucket1);
        Assertions.assertEquals((Object)hashall.toString(), (Object)"0", (String)"empty hashall's digest should be 0");
        AdHash hash45 = new AdHash();
        AdHashTest.addListOfDigests(hash45, bucket4);
        AdHashTest.addListOfDigests(hash45, bucket5);
        AdHashTest.addListOfDigests(hashall, bucket4);
        AdHashTest.addListOfDigests(hashall, bucket5);
        Assertions.assertEquals((Object)hashall, (Object)hash45, (String)"empty hashall + 4&5 should equal hash45");
    }
}

