/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.util.ByteBufList;

public interface BookieProtocol {
    public static final byte LOWEST_COMPAT_PROTOCOL_VERSION = 0;
    public static final byte CURRENT_PROTOCOL_VERSION = 2;
    public static final long INVALID_ENTRY_ID = -1L;
    public static final long LAST_ADD_CONFIRMED = -1L;
    public static final int MASTER_KEY_LENGTH = 20;
    public static final byte ADDENTRY = 1;
    public static final byte READENTRY = 2;
    public static final byte AUTH = 3;
    public static final byte READ_LAC = 4;
    public static final byte WRITE_LAC = 5;
    public static final byte GET_BOOKIE_INFO = 6;
    public static final int EOK = 0;
    public static final int ENOLEDGER = 1;
    public static final int ENOENTRY = 2;
    public static final int EBADREQ = 100;
    public static final int EIO = 101;
    public static final int EUA = 102;
    public static final int EBADVERSION = 103;
    public static final int EFENCED = 104;
    public static final int EREADONLY = 105;
    public static final int ETOOMANYREQUESTS = 106;
    public static final int EUNKNOWNLEDGERSTATE = 107;
    public static final short FLAG_NONE = 0;
    public static final short FLAG_DO_FENCING = 1;
    public static final short FLAG_RECOVERY_ADD = 2;
    public static final short FLAG_HIGH_PRIORITY = 4;

    public static class AuthResponse
    extends Response {
        final BookkeeperProtocol.AuthMessage authMessage;

        AuthResponse(byte protocolVersion, BookkeeperProtocol.AuthMessage authMessage) {
            this.init(protocolVersion, (byte)3, 0, -1L, -1L);
            this.authMessage = authMessage;
        }

        BookkeeperProtocol.AuthMessage getAuthMessage() {
            return this.authMessage;
        }
    }

    public static class ErrorResponse
    extends Response {
        ErrorResponse(byte protocolVersion, byte opCode, int errorCode, long ledgerId, long entryId) {
            this.init(protocolVersion, opCode, errorCode, ledgerId, entryId);
        }
    }

    public static class AddResponse
    extends Response {
        private final Recycler.Handle<AddResponse> recyclerHandle;
        private static final Recycler<AddResponse> RECYCLER = new Recycler<AddResponse>(){

            protected AddResponse newObject(Recycler.Handle<AddResponse> handle) {
                return new AddResponse(handle);
            }
        };

        static AddResponse create(byte protocolVersion, int errorCode, long ledgerId, long entryId) {
            AddResponse response = (AddResponse)RECYCLER.get();
            response.init(protocolVersion, (byte)1, errorCode, ledgerId, entryId);
            return response;
        }

        private AddResponse(Recycler.Handle<AddResponse> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        @Override
        public void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }
    }

    public static class ReadResponse
    extends Response
    implements ReferenceCounted {
        final ByteBuf data;

        ReadResponse(byte protocolVersion, int errorCode, long ledgerId, long entryId) {
            this(protocolVersion, errorCode, ledgerId, entryId, Unpooled.EMPTY_BUFFER);
        }

        ReadResponse(byte protocolVersion, int errorCode, long ledgerId, long entryId, ByteBuf data) {
            this.init(protocolVersion, (byte)2, errorCode, ledgerId, entryId);
            this.data = data;
        }

        boolean hasData() {
            return this.data.readableBytes() > 0;
        }

        ByteBuf getData() {
            return this.data;
        }

        public int refCnt() {
            return this.data.refCnt();
        }

        public ReferenceCounted retain() {
            return this.data.retain();
        }

        public ReferenceCounted retain(int increment) {
            return this.data.retain(increment);
        }

        public ReferenceCounted touch() {
            return this.data.touch();
        }

        public ReferenceCounted touch(Object hint) {
            return this.data.touch(hint);
        }

        @Override
        public boolean release() {
            return this.data.release();
        }

        public boolean release(int decrement) {
            return this.data.release(decrement);
        }
    }

    public static abstract class Response {
        byte protocolVersion;
        byte opCode;
        int errorCode;
        long ledgerId;
        long entryId;

        protected void init(byte protocolVersion, byte opCode, int errorCode, long ledgerId, long entryId) {
            this.protocolVersion = protocolVersion;
            this.opCode = opCode;
            this.errorCode = errorCode;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
        }

        byte getProtocolVersion() {
            return this.protocolVersion;
        }

        byte getOpCode() {
            return this.opCode;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        long getEntryId() {
            return this.entryId;
        }

        int getErrorCode() {
            return this.errorCode;
        }

        public String toString() {
            return String.format("Op(%d)[Ledger:%d,Entry:%d,errorCode=%d]", this.opCode, this.ledgerId, this.entryId, this.errorCode);
        }

        boolean release() {
            return true;
        }

        void recycle() {
        }
    }

    public static class AuthRequest
    extends Request {
        final BookkeeperProtocol.AuthMessage authMessage;

        AuthRequest(byte protocolVersion, BookkeeperProtocol.AuthMessage authMessage) {
            this.init(protocolVersion, (byte)3, -1L, -1L, (short)0, null);
            this.authMessage = authMessage;
        }

        BookkeeperProtocol.AuthMessage getAuthMessage() {
            return this.authMessage;
        }
    }

    public static class ReadRequest
    extends Request {
        ReadRequest(byte protocolVersion, long ledgerId, long entryId, short flags, byte[] masterKey) {
            this.init(protocolVersion, (byte)2, ledgerId, entryId, flags, masterKey);
        }

        boolean isFencing() {
            return (this.flags & 1) == 1;
        }
    }

    public static class ParsedAddRequest
    extends Request {
        ByteBuf data;
        private final Recycler.Handle<ParsedAddRequest> recyclerHandle;
        private static final Recycler<ParsedAddRequest> RECYCLER = new Recycler<ParsedAddRequest>(){

            protected ParsedAddRequest newObject(Recycler.Handle<ParsedAddRequest> handle) {
                return new ParsedAddRequest(handle);
            }
        };

        static ParsedAddRequest create(byte protocolVersion, long ledgerId, long entryId, short flags, byte[] masterKey, ByteBuf data) {
            ParsedAddRequest add = (ParsedAddRequest)RECYCLER.get();
            add.protocolVersion = protocolVersion;
            add.opCode = 1;
            add.ledgerId = ledgerId;
            add.entryId = entryId;
            add.flags = flags;
            add.masterKey = masterKey;
            add.data = data.retain();
            return add;
        }

        ByteBuf getData() {
            return this.data;
        }

        boolean isRecoveryAdd() {
            return (this.flags & 2) == 2;
        }

        void release() {
            this.data.release();
        }

        private ParsedAddRequest(Recycler.Handle<ParsedAddRequest> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        @Override
        public void recycle() {
            this.ledgerId = -1L;
            this.entryId = -1L;
            this.masterKey = null;
            this.data = null;
            this.recyclerHandle.recycle((Object)this);
        }
    }

    public static class AddRequest
    extends Request {
        ByteBufList data;
        private final Recycler.Handle<AddRequest> recyclerHandle;
        private static final Recycler<AddRequest> RECYCLER = new Recycler<AddRequest>(){

            protected AddRequest newObject(Recycler.Handle<AddRequest> handle) {
                return new AddRequest(handle);
            }
        };

        static AddRequest create(byte protocolVersion, long ledgerId, long entryId, short flags, byte[] masterKey, ByteBufList data) {
            AddRequest add = (AddRequest)RECYCLER.get();
            add.protocolVersion = protocolVersion;
            add.opCode = 1;
            add.ledgerId = ledgerId;
            add.entryId = entryId;
            add.flags = flags;
            add.masterKey = masterKey;
            add.data = data.retain();
            return add;
        }

        ByteBufList getData() {
            return ByteBufList.clone(this.data);
        }

        boolean isRecoveryAdd() {
            return (this.flags & 2) == 2;
        }

        private AddRequest(Recycler.Handle<AddRequest> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        @Override
        public void recycle() {
            this.ledgerId = -1L;
            this.entryId = -1L;
            this.masterKey = null;
            ReferenceCountUtil.safeRelease((Object)((Object)this.data));
            this.data = null;
            this.recyclerHandle.recycle((Object)this);
        }
    }

    public static class Request {
        byte protocolVersion;
        byte opCode;
        long ledgerId;
        long entryId;
        short flags;
        byte[] masterKey;

        protected void init(byte protocolVersion, byte opCode, long ledgerId, long entryId, short flags, byte[] masterKey) {
            this.protocolVersion = protocolVersion;
            this.opCode = opCode;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.flags = flags;
            this.masterKey = masterKey;
        }

        byte getProtocolVersion() {
            return this.protocolVersion;
        }

        byte getOpCode() {
            return this.opCode;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        long getEntryId() {
            return this.entryId;
        }

        short getFlags() {
            return this.flags;
        }

        boolean hasMasterKey() {
            return this.masterKey != null;
        }

        byte[] getMasterKey() {
            assert (this.hasMasterKey());
            return this.masterKey;
        }

        boolean isHighPriority() {
            return (this.flags & 4) == 4;
        }

        public String toString() {
            return String.format("Op(%d)[Ledger:%d,Entry:%d]", this.opCode, this.ledgerId, this.entryId);
        }

        public void recycle() {
        }
    }

    public static final class PacketHeader {
        public static int toInt(byte version, byte opCode, short flags) {
            if (version == 0) {
                return opCode;
            }
            return (version & 0xFF) << 24 | (opCode & 0xFF) << 16 | flags & 0xFFFF;
        }

        public static byte getVersion(int packetHeader) {
            return (byte)(packetHeader >> 24);
        }

        public static byte getOpCode(int packetHeader) {
            byte version = PacketHeader.getVersion(packetHeader);
            if (version == 0) {
                return (byte)packetHeader;
            }
            return (byte)(packetHeader >> 16 & 0xFF);
        }

        public static short getFlags(int packetHeader) {
            byte version = (byte)(packetHeader >> 24);
            if (version == 0) {
                return 0;
            }
            return (short)(packetHeader & 0xFFFF);
        }
    }
}

