/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKSyncLogWriter;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogSegmentCreation
extends TestDistributedLogBase {
    static Logger LOG = LoggerFactory.getLogger(TestLogSegmentCreation.class);

    @Test(timeout=60000L)
    public void testCreateLogSegmentAfterLoseLock() throws Exception {
        URI uri = this.createDLMURI("/LogSegmentCreation");
        String name = "distrlog-createlogsegment-afterloselock";
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setLockTimeout(99999L).setOutputBufferSize(0).setImmediateFlushEnabled(true).setEnableLedgerAllocatorPool(true).setLedgerAllocatorPoolName("test");
        Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(uri).build();
        DistributedLogManager dlm = namespace.openLog(name);
        int numSegments = 3;
        for (int i = 0; i < 3; ++i) {
            BKSyncLogWriter out = (BKSyncLogWriter)dlm.startLogSegmentNonPartitioned();
            out.write(DLMTestUtil.getLogRecordInstance(i));
            out.closeAndComplete();
        }
        List segments = dlm.getLogSegments();
        LOG.info("Segments : {}", (Object)segments);
        Assert.assertEquals((long)3L, (long)segments.size());
        DistributedLogManager dlm1 = namespace.openLog(name);
        DistributedLogManager dlm2 = namespace.openLog(name);
        BKAsyncLogWriter writer1 = (BKAsyncLogWriter)dlm1.startAsyncLogSegmentNonPartitioned();
        LOG.info("Created writer 1.");
        BKSyncLogWriter writer2 = (BKSyncLogWriter)dlm2.startLogSegmentNonPartitioned();
        LOG.info("Created writer 2.");
        writer2.write(DLMTestUtil.getLogRecordInstance(3L));
        writer2.closeAndComplete();
        try {
            Utils.ioResult((CompletableFuture)writer1.write(DLMTestUtil.getLogRecordInstance(4L)));
            Assert.fail((String)"Should fail on writing new log records.");
        }
        catch (Throwable t) {
            LOG.error("Failed to write entry : ", t);
        }
        segments = dlm.getLogSegments();
        boolean hasInprogress = false;
        boolean hasDuplicatedSegment = false;
        long nextSeqNo = ((LogSegmentMetadata)segments.get(0)).getLogSegmentSequenceNumber();
        for (int i = 1; i < segments.size(); ++i) {
            LogSegmentMetadata segment = (LogSegmentMetadata)segments.get(i);
            Assert.assertTrue((segment.getLogSegmentSequenceNumber() >= nextSeqNo ? 1 : 0) != 0);
            if (segment.getLogSegmentSequenceNumber() == nextSeqNo) {
                hasDuplicatedSegment = true;
            }
            nextSeqNo = segment.getLogSegmentSequenceNumber();
            if (!segment.isInProgress()) continue;
            hasInprogress = true;
        }
        Assert.assertEquals((long)4L, (long)segments.size());
        Assert.assertFalse((boolean)hasInprogress);
        Assert.assertFalse((boolean)hasDuplicatedSegment);
        LOG.info("Segments : duplicated = {}, inprogress = {}, {}", new Object[]{hasDuplicatedSegment, hasInprogress, segments});
        dlm1.close();
        dlm2.close();
        dlm.close();
        namespace.close();
    }
}

