/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorage;
import org.apache.bookkeeper.bookie.storage.ldb.KeyValueStorageFactory;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.rocksdb.AbstractSlice;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.OptionsUtil;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueStorageRocksDB
implements KeyValueStorage {
    static KeyValueStorageFactory factory = (defaultBasePath, subPath, dbConfigType, conf) -> new KeyValueStorageRocksDB(defaultBasePath, subPath, dbConfigType, conf);
    private final RocksDB db;
    private final WriteOptions optionSync;
    private final WriteOptions optionDontSync;
    private final ReadOptions optionCache;
    private final ReadOptions optionDontCache;
    private final WriteBatch emptyBatch;
    private static final String ROCKSDB_LOG_PATH = "dbStorage_rocksDB_logPath";
    private static final Logger log = LoggerFactory.getLogger(KeyValueStorageRocksDB.class);

    public KeyValueStorageRocksDB(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf) throws IOException {
        this(basePath, subPath, dbConfigType, conf, false);
    }

    public KeyValueStorageRocksDB(String basePath, String subPath, KeyValueStorageFactory.DbConfigType dbConfigType, ServerConfiguration conf, boolean readOnly) throws IOException {
        try {
            RocksDB.loadLibrary();
        }
        catch (Throwable t) {
            throw new IOException("Failed to load RocksDB JNI library", t);
        }
        this.optionSync = new WriteOptions();
        this.optionDontSync = new WriteOptions();
        this.optionCache = new ReadOptions();
        this.optionDontCache = new ReadOptions();
        this.emptyBatch = new WriteBatch();
        String dbFilePath = "";
        DBOptions dbOptions = new DBOptions();
        ArrayList cfDescs = new ArrayList();
        ArrayList cfHandles = new ArrayList();
        try {
            dbFilePath = dbConfigType == KeyValueStorageFactory.DbConfigType.EntryLocation ? conf.getEntryLocationRocksdbConf() : (dbConfigType == KeyValueStorageFactory.DbConfigType.LedgerMetadata ? conf.getLedgerMetadataRocksdbConf() : conf.getDefaultRocksDBConf());
            OptionsUtil.loadOptionsFromFile((String)dbFilePath, (Env)Env.getDefault(), (DBOptions)dbOptions, cfDescs, (boolean)false);
            String logPath = conf.getString(ROCKSDB_LOG_PATH, "");
            if (!logPath.isEmpty()) {
                Path logPathSetting = FileSystems.getDefault().getPath(logPath, subPath);
                Files.createDirectories(logPathSetting, new FileAttribute[0]);
                log.info("RocksDB<{}> log path: {}", (Object)subPath, (Object)logPathSetting);
                dbOptions.setDbLogDir(logPathSetting.toString());
            }
            String path = FileSystems.getDefault().getPath(basePath, subPath).toFile().toString();
            this.db = readOnly ? RocksDB.openReadOnly((DBOptions)dbOptions, (String)path, cfDescs, cfHandles) : RocksDB.open((DBOptions)dbOptions, (String)path, cfDescs, cfHandles);
        }
        catch (RocksDBException e) {
            throw new IOException("Error open RocksDB database", e);
        }
        this.optionSync.setSync(true);
        this.optionDontSync.setSync(false);
        this.optionCache.setFillCache(true);
        this.optionDontCache.setFillCache(false);
    }

    @Override
    public void close() throws IOException {
        this.db.close();
        this.optionSync.close();
        this.optionDontSync.close();
        this.optionCache.close();
        this.optionDontCache.close();
        this.emptyBatch.close();
    }

    @Override
    public void put(byte[] key, byte[] value) throws IOException {
        try {
            this.db.put(this.optionDontSync, key, value);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB put", e);
        }
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB get", e);
        }
    }

    @Override
    public int get(byte[] key, byte[] value) throws IOException {
        try {
            int res = this.db.get(key, value);
            if (res == -1) {
                return -1;
            }
            if (res > value.length) {
                throw new IOException("Value array is too small to fit the result");
            }
            return res;
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB get", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Map.Entry<byte[], byte[]> getFloor(byte[] key) throws IOException {
        try (Slice upperBound = new Slice(key);
             ReadOptions option = new ReadOptions(this.optionCache).setIterateUpperBound((AbstractSlice)upperBound);
             RocksIterator iterator = this.db.newIterator(option);){
            iterator.seekToLast();
            if (iterator.isValid()) {
                EntryWrapper entryWrapper = new EntryWrapper(iterator.key(), iterator.value());
                return entryWrapper;
            }
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public Map.Entry<byte[], byte[]> getCeil(byte[] key) throws IOException {
        try (RocksIterator iterator = this.db.newIterator(this.optionCache);){
            iterator.seek(key);
            if (iterator.isValid()) {
                EntryWrapper entryWrapper = new EntryWrapper(iterator.key(), iterator.value());
                return entryWrapper;
            }
            Map.Entry<byte[], byte[]> entry = null;
            return entry;
        }
    }

    @Override
    public void delete(byte[] key) throws IOException {
        try {
            this.db.delete(this.optionDontSync, key);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB delete", e);
        }
    }

    @Override
    public void compact(byte[] firstKey, byte[] lastKey) throws IOException {
        try {
            this.db.compactRange(firstKey, lastKey);
        }
        catch (RocksDBException e) {
            throw new IOException("Error in RocksDB compact", e);
        }
    }

    @Override
    public void sync() throws IOException {
        try {
            this.db.write(this.optionSync, this.emptyBatch);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public KeyValueStorage.CloseableIterator<byte[]> keys() {
        final RocksIterator iterator = this.db.newIterator(this.optionCache);
        iterator.seekToFirst();
        return new KeyValueStorage.CloseableIterator<byte[]>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public byte[] next() {
                Preconditions.checkState((boolean)iterator.isValid());
                byte[] key = iterator.key();
                iterator.next();
                return key;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    @Override
    public KeyValueStorage.CloseableIterator<byte[]> keys(byte[] firstKey, byte[] lastKey) {
        final Slice upperBound = new Slice(lastKey);
        final ReadOptions option = new ReadOptions(this.optionCache).setIterateUpperBound((AbstractSlice)upperBound);
        final RocksIterator iterator = this.db.newIterator(option);
        iterator.seek(firstKey);
        return new KeyValueStorage.CloseableIterator<byte[]>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public byte[] next() {
                Preconditions.checkState((boolean)iterator.isValid());
                byte[] key = iterator.key();
                iterator.next();
                return key;
            }

            @Override
            public void close() {
                iterator.close();
                option.close();
                upperBound.close();
            }
        };
    }

    @Override
    public KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>> iterator() {
        final RocksIterator iterator = this.db.newIterator(this.optionDontCache);
        iterator.seekToFirst();
        final EntryWrapper entryWrapper = new EntryWrapper();
        return new KeyValueStorage.CloseableIterator<Map.Entry<byte[], byte[]>>(){

            @Override
            public boolean hasNext() {
                return iterator.isValid();
            }

            @Override
            public Map.Entry<byte[], byte[]> next() {
                Preconditions.checkState((boolean)iterator.isValid());
                EntryWrapper.access$002(entryWrapper, iterator.key());
                EntryWrapper.access$102(entryWrapper, iterator.value());
                iterator.next();
                return entryWrapper;
            }

            @Override
            public void close() {
                iterator.close();
            }
        };
    }

    @Override
    public long count() throws IOException {
        try {
            return this.db.getLongProperty("rocksdb.estimate-num-keys");
        }
        catch (RocksDBException e) {
            throw new IOException("Error in getting records count", e);
        }
    }

    @Override
    public KeyValueStorage.Batch newBatch() {
        return new RocksDBBatch();
    }

    private static final class EntryWrapper
    implements Map.Entry<byte[], byte[]> {
        private byte[] key;
        private byte[] value;

        public EntryWrapper() {
            this.key = null;
            this.value = null;
        }

        public EntryWrapper(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public byte[] setValue(byte[] value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        static /* synthetic */ byte[] access$002(EntryWrapper x0, byte[] x1) {
            x0.key = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(EntryWrapper x0, byte[] x1) {
            x0.value = x1;
            return x1;
        }
    }

    private class RocksDBBatch
    implements KeyValueStorage.Batch {
        private final WriteBatch writeBatch = new WriteBatch();

        private RocksDBBatch() {
        }

        @Override
        public void close() {
            this.writeBatch.close();
        }

        @Override
        public void put(byte[] key, byte[] value) throws IOException {
            try {
                this.writeBatch.put(key, value);
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        @Override
        public void remove(byte[] key) throws IOException {
            try {
                this.writeBatch.delete(key);
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        @Override
        public void clear() {
            this.writeBatch.clear();
        }

        @Override
        public void deleteRange(byte[] beginKey, byte[] endKey) throws IOException {
            try {
                this.writeBatch.deleteRange(beginKey, endKey);
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                KeyValueStorageRocksDB.this.db.write(KeyValueStorageRocksDB.this.optionSync, this.writeBatch);
            }
            catch (RocksDBException e) {
                throw new IOException("Failed to flush RocksDB batch", e);
            }
        }
    }
}

