/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.TxnLogProposalIterator;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.LearnerMaster;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerHandlerTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(LearnerHandlerTest.class);
    private MockLearnerHandler learnerHandler;
    private Socket sock;
    private Leader leader;
    private long currentZxid;
    private MockZKDatabase db;

    @BeforeEach
    public void setUp() throws Exception {
        this.db = new MockZKDatabase(null);
        this.sock = (Socket)Mockito.mock(Socket.class);
        this.leader = (Leader)Mockito.mock(Leader.class);
        Mockito.when((Object)this.leader.startForwarding((LearnerHandler)ArgumentMatchers.any(LearnerHandler.class), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) {
                LearnerHandlerTest.this.currentZxid = (Long)invocation.getArgument(1);
                return 0L;
            }
        });
        Mockito.when((Object)this.leader.getZKDatabase()).thenReturn((Object)this.db);
        this.learnerHandler = new MockLearnerHandler(this.sock, this.leader);
    }

    Leader.Proposal createProposal(long zxid) {
        Leader.Proposal p = new Leader.Proposal();
        p.packet = new QuorumPacket();
        p.packet.setZxid(zxid);
        p.packet.setType(2);
        return p;
    }

    public void queuedPacketMatches(long[] zxids) {
        int index = 0;
        for (QuorumPacket qp : this.learnerHandler.getQueuedPackets()) {
            if (qp.getType() != 2) continue;
            this.assertZxidEquals(zxids[index++], qp.getZxid());
        }
    }

    void reset() {
        this.learnerHandler.getQueuedPackets().clear();
        this.learnerHandler.threadStarted = false;
        this.learnerHandler.setFirstPacket(true);
    }

    public void assertOpType(int type, long zxid, long currentZxid) {
        Queue packets = this.learnerHandler.getQueuedPackets();
        Assertions.assertTrue((packets.size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)type, (int)((QuorumPacket)packets.peek()).getType());
        this.assertZxidEquals(zxid, ((QuorumPacket)packets.peek()).getZxid());
        this.assertZxidEquals(currentZxid, this.currentZxid);
    }

    void assertZxidEquals(long expected, long value) {
        Assertions.assertEquals((long)expected, (long)value, (String)("Expected 0x" + Long.toHexString(expected) + " but was 0x" + Long.toHexString(value)));
    }

    @Test
    public void testEmptyCommittedLog() throws Exception {
        long peerZxid = 3L;
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(14, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        this.reset();
        peerZxid = 1L;
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        Assertions.assertEquals((int)1, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
        peerZxid = 0L;
        this.db.setSnapshotSizeFactor(-1.0);
        this.db.lastProcessedZxid = 1L;
        this.db.committedLog.clear();
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        Assertions.assertEquals((int)0, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testCommittedLog() throws Exception {
        this.db.lastProcessedZxid = 6L;
        this.db.committedLog.add(this.createProposal(2L));
        this.db.committedLog.add(this.createProposal(3L));
        this.db.committedLog.add(this.createProposal(5L));
        long peerZxid = 4L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(14, 3L, 5L);
        Assertions.assertEquals((int)3, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L});
        this.reset();
        peerZxid = 2L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assertions.assertEquals((int)5, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{3L, 5L});
        this.reset();
        peerZxid = 1L;
        this.db.setSnapshotSizeFactor(-1.0);
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        Assertions.assertEquals((int)0, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testTxnLog() throws Exception {
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(5L));
        this.db.txnLog.add(this.createProposal(6L));
        this.db.txnLog.add(this.createProposal(7L));
        this.db.txnLog.add(this.createProposal(8L));
        this.db.txnLog.add(this.createProposal(9L));
        this.db.lastProcessedZxid = 9L;
        this.db.committedLog.add(this.createProposal(6L));
        this.db.committedLog.add(this.createProposal(7L));
        this.db.committedLog.add(this.createProposal(8L));
        long peerZxid = 4L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(14, 3L, this.db.getmaxCommittedLog());
        Assertions.assertEquals((int)9, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L, 8L});
        this.reset();
        peerZxid = 3L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assertions.assertEquals((int)9, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L, 8L});
        this.reset();
    }

    @Test
    public void testTxnLogProposalIteratorClosure() throws Exception {
        this.db = new MockZKDatabase(null){

            @Override
            public Iterator<Leader.Proposal> getProposalsFromTxnLog(long peerZxid, long limit) {
                return TxnLogProposalIterator.EMPTY_ITERATOR;
            }
        };
        this.db.lastProcessedZxid = 7L;
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        Mockito.when((Object)this.leader.getZKDatabase()).thenReturn((Object)this.db);
        long peerZxid = 4L;
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader), (String)"Couldn't identify snapshot transfer!");
        this.reset();
    }

    @Test
    public void testTxnLogOnly() throws Exception {
        this.db.lastProcessedZxid = 7L;
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(5L));
        this.db.txnLog.add(this.createProposal(6L));
        this.db.txnLog.add(this.createProposal(7L));
        this.db.txnLog.add(this.createProposal(8L));
        long peerZxid = 4L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(14, 3L, this.db.lastProcessedZxid);
        Assertions.assertEquals((int)7, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{5L, 6L, 7L});
        this.reset();
        peerZxid = 2L;
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.db.lastProcessedZxid, this.db.lastProcessedZxid);
        Assertions.assertEquals((int)9, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{3L, 5L, 6L, 7L});
        this.reset();
        peerZxid = 1L;
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        Assertions.assertEquals((int)0, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    long getZxid(long epoch, long counter) {
        return ZxidUtils.makeZxid((long)epoch, (long)counter);
    }

    @Test
    public void testTxnLogWithNegativeZxid() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 3L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 5L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 6L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 7L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 8L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(15L, 9L)));
        this.db.lastProcessedZxid = this.getZxid(15L, 9L);
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 6L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 7L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(15L, 8L)));
        long peerZxid = this.getZxid(15L, 4L);
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(14, this.getZxid(15L, 3L), this.db.getmaxCommittedLog());
        Assertions.assertEquals((int)9, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(15L, 5L), this.getZxid(15L, 6L), this.getZxid(15L, 7L), this.getZxid(15L, 8L)});
        this.reset();
        peerZxid = this.getZxid(15L, 3L);
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.db.getmaxCommittedLog(), this.db.getmaxCommittedLog());
        Assertions.assertEquals((int)9, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(15L, 5L), this.getZxid(15L, 6L), this.getZxid(15L, 7L), this.getZxid(15L, 8L)});
        this.reset();
    }

    @Test
    public void testNewEpochZxid() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(0L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.lastProcessedZxid = this.getZxid(2L, 0L);
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        long peerZxid = this.getZxid(0L, 0L);
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        Assertions.assertEquals((int)0, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
        peerZxid = this.getZxid(1L, 0L);
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.getZxid(1L, 2L), this.getZxid(1L, 2L));
        Assertions.assertEquals((int)5, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(1L, 1L), this.getZxid(1L, 2L)});
        this.reset();
        peerZxid = this.getZxid(2L, 0L);
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.getZxid(2L, 0L), this.getZxid(2L, 0L));
        Assertions.assertEquals((int)1, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testDuplicatedTxn() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(0L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.lastProcessedZxid = this.getZxid(2L, 0L);
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.committedLog.add(this.createProposal(this.getZxid(1L, 2L)));
        long peerZxid = this.getZxid(1L, 0L);
        Assertions.assertFalse((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.assertOpType(13, this.getZxid(1L, 2L), this.getZxid(1L, 2L));
        Assertions.assertEquals((int)5, (int)this.learnerHandler.getQueuedPackets().size());
        this.queuedPacketMatches(new long[]{this.getZxid(1L, 1L), this.getZxid(1L, 2L)});
        this.reset();
    }

    @Test
    public void testCrossEpochTrunc() throws Exception {
        this.db.txnLog.add(this.createProposal(this.getZxid(1L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(2L, 1L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(2L, 2L)));
        this.db.txnLog.add(this.createProposal(this.getZxid(4L, 1L)));
        this.db.lastProcessedZxid = this.getZxid(6L, 0L);
        long peerZxid = this.getZxid(3L, 1L);
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        Assertions.assertEquals((int)0, (int)this.learnerHandler.getQueuedPackets().size());
        this.reset();
    }

    @Test
    public void testTxnLogGap() throws Exception {
        this.db.txnLog.add(this.createProposal(2L));
        this.db.txnLog.add(this.createProposal(3L));
        this.db.txnLog.add(this.createProposal(4L));
        this.db.lastProcessedZxid = 8L;
        this.db.committedLog.add(this.createProposal(7L));
        this.db.committedLog.add(this.createProposal(8L));
        long peerZxid = 3L;
        Assertions.assertTrue((boolean)this.learnerHandler.syncFollower(peerZxid, (LearnerMaster)this.leader));
        this.reset();
    }

    class MockZKDatabase
    extends ZKDatabase {
        long lastProcessedZxid;
        ReentrantReadWriteLock lock;
        LinkedList<Leader.Proposal> committedLog;
        LinkedList<Leader.Proposal> txnLog;

        public MockZKDatabase(FileTxnSnapLog snapLog) {
            super(snapLog);
            this.lock = new ReentrantReadWriteLock();
            this.committedLog = new LinkedList();
            this.txnLog = new LinkedList();
        }

        public long getDataTreeLastProcessedZxid() {
            return this.lastProcessedZxid;
        }

        public long getmaxCommittedLog() {
            if (!this.committedLog.isEmpty()) {
                return this.committedLog.getLast().packet.getZxid();
            }
            return 0L;
        }

        public long getminCommittedLog() {
            if (!this.committedLog.isEmpty()) {
                return this.committedLog.getFirst().packet.getZxid();
            }
            return 0L;
        }

        public List<Leader.Proposal> getCommittedLog() {
            return this.committedLog;
        }

        public ReentrantReadWriteLock getLogLock() {
            return this.lock;
        }

        public Iterator<Leader.Proposal> getProposalsFromTxnLog(long peerZxid, long limit) {
            if (peerZxid >= this.txnLog.peekFirst().packet.getZxid()) {
                return this.txnLog.iterator();
            }
            return Collections.emptyIterator();
        }

        public long calculateTxnLogSizeLimit() {
            return 1L;
        }
    }

    class MockLearnerHandler
    extends LearnerHandler {
        boolean threadStarted;

        MockLearnerHandler(Socket sock, Leader leader) throws IOException {
            super(sock, new BufferedInputStream(sock.getInputStream()), (LearnerMaster)leader);
            this.threadStarted = false;
        }

        protected void startSendingPackets() {
            this.threadStarted = true;
        }

        protected boolean shouldSendMarkerPacketForLogging() {
            return false;
        }
    }
}

