/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnSnapLogMetricsTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLogMetricsTest.class);
    CountDownLatch allCreatedLatch;

    @Test
    public void testFileTxnSnapLogMetrics() throws Exception {
        SyncRequestProcessor.setSnapCount((int)100);
        QuorumUtil util = new QuorumUtil(1);
        util.startAll();
        this.allCreatedLatch = new CountDownLatch(1);
        byte[] data = new byte[500];
        ZooKeeper zk = ClientBase.createZKClient(util.getConnString());
        for (int i = 0; i < 150; ++i) {
            zk.create("/path" + i, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        if (null == zk.exists("/path149", (Watcher)new MockWatcher())) {
            this.allCreatedLatch.await();
        }
        ServerMetrics.getMetrics().resetAll();
        int leader = util.getLeaderServer();
        util.shutdown(leader);
        util.start(leader);
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        LOG.info("txn loaded during start up {}", values.get("max_startup_txns_loaded"));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_loaded"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_txns_loaded")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_load_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_txns_load_time")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_snap_load_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_snap_load_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        util.shutdownAll();
    }

    private class MockWatcher
    implements Watcher {
        private MockWatcher() {
        }

        public void process(WatchedEvent e) {
            LOG.info("all nodes created");
            FileTxnSnapLogMetricsTest.this.allCreatedLatch.countDown();
        }
    }
}

