/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ZKClientConfigTest {
    private static final File testData = new File(System.getProperty("test.data.dir", "src/test/resources/data"));

    @BeforeAll
    public static void init() {
        if (!testData.exists()) {
            testData.mkdirs();
        }
    }

    @Test
    @Timeout(value=10L)
    public void testDefaultConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("zookeeper.sasl.client.username", "zookeeper1");
        properties.put("zookeeper.sasl.clientconfig", "Client1");
        properties.put("zookeeper.sasl.client", "true");
        properties.put("zookeeper.server.realm", "zookeeper/hadoop.hadoop.com");
        properties.put("zookeeper.disableAutoWatchReset", "true");
        properties.put("zookeeper.clientCnxnSocket", "ClientCnxnSocketNetty");
        properties.put("zookeeper.client.secure", "true");
        for (Map.Entry e : properties.entrySet()) {
            System.setProperty((String)e.getKey(), (String)e.getValue());
        }
        ZKClientConfig conf = new ZKClientConfig();
        for (Map.Entry e : properties.entrySet()) {
            Assertions.assertEquals(e.getValue(), (Object)conf.getProperty((String)e.getKey()));
        }
        for (Map.Entry e : properties.entrySet()) {
            System.clearProperty((String)e.getKey());
        }
        conf = new ZKClientConfig();
        for (Map.Entry e : properties.entrySet()) {
            String result = conf.getProperty((String)e.getKey());
            Assertions.assertNull((Object)result);
        }
    }

    @Test
    @Timeout(value=10L)
    public void testSystemPropertyValue() {
        String clientName = "zookeeper1";
        System.setProperty("zookeeper.sasl.client.username", clientName);
        ZKClientConfig conf = new ZKClientConfig();
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)clientName);
        String newClientName = "zookeeper2";
        conf.setProperty("zookeeper.sasl.client.username", newClientName);
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)newClientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testReadConfigurationFile() throws IOException, QuorumPeerConfig.ConfigException {
        File file = File.createTempFile("clientConfig", ".conf", testData);
        file.deleteOnExit();
        Properties clientConfProp = new Properties();
        clientConfProp.setProperty("zookeeper.sasl.client", "true");
        clientConfProp.setProperty("zookeeper.sasl.client.username", "ZK");
        clientConfProp.setProperty("zookeeper.sasl.clientconfig", "MyClient");
        clientConfProp.setProperty("zookeeper.server.realm", "HADOOP.COM");
        clientConfProp.setProperty("dummyProperty", "dummyValue");
        try (FileOutputStream io = new FileOutputStream(file);){
            clientConfProp.store(io, "Client Configurations");
        }
        ZKClientConfig conf = new ZKClientConfig();
        conf.addConfiguration(file.getAbsolutePath());
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.sasl.client"), (Object)"true");
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.sasl.client.username"), (Object)"ZK");
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.sasl.clientconfig"), (Object)"MyClient");
        Assertions.assertEquals((Object)conf.getProperty("zookeeper.server.realm"), (Object)"HADOOP.COM");
        Assertions.assertEquals((Object)conf.getProperty("dummyProperty"), (Object)"dummyValue");
        file.delete();
    }

    @Test
    @Timeout(value=10L)
    public void testSetConfiguration() {
        ZKClientConfig conf = new ZKClientConfig();
        String defaultValue = conf.getProperty("zookeeper.sasl.client", "true");
        if (defaultValue.equals("true")) {
            conf.setProperty("zookeeper.sasl.client", "false");
        } else {
            conf.setProperty("zookeeper.sasl.client", "true");
        }
        Assertions.assertTrue((conf.getProperty("zookeeper.sasl.client") != defaultValue ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=10L)
    public void testIntegerRetrievalFromProperty() {
        ZKClientConfig conf = new ZKClientConfig();
        String prop = "UnSetProperty" + System.currentTimeMillis();
        int defaultValue = 100;
        int result = conf.getInt(prop, defaultValue);
        Assertions.assertEquals((int)defaultValue, (int)result);
        conf.setProperty("jute.maxbuffer", "InvlaidIntValue123");
        try {
            result = conf.getInt("jute.maxbuffer", defaultValue);
            Assertions.fail((String)"NumberFormatException is expected");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assertions.assertEquals((int)defaultValue, (int)result);
        int value = 1048575;
        conf.setProperty("jute.maxbuffer", Integer.toString(value));
        result = conf.getInt("jute.maxbuffer", defaultValue);
        Assertions.assertEquals((int)value, (int)result);
        value = 12345;
        conf.setProperty("jute.maxbuffer", " " + value + " ");
        result = conf.getInt("jute.maxbuffer", defaultValue);
        Assertions.assertEquals((int)value, (int)result);
    }

    @Test
    @Timeout(value=10L)
    public void testIntegerRetrievalFromHexadecimalProperty() {
        int hexaValue = 0x3000000;
        String wrongValue = "0xwel";
        int defaultValue = 100;
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        zkClientConfig.setProperty("jute.maxbuffer", Integer.toString(hexaValue));
        int result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
        Assertions.assertEquals((int)result, (int)hexaValue);
        zkClientConfig.setProperty("jute.maxbuffer", wrongValue);
        try {
            result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
            Assertions.fail((String)"NumberFormatException is expected");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        zkClientConfig.setProperty("jute.maxbuffer", " " + hexaValue + " ");
        result = zkClientConfig.getInt("jute.maxbuffer", defaultValue);
        Assertions.assertEquals((int)result, (int)hexaValue);
    }
}

