/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;
import java.util.function.LongPredicate;

public class ConcurrentLongLongHashMap {
    private static final long EmptyKey = -1L;
    private static final long DeletedKey = -2L;
    private static final long ValueNotFound = -1L;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private static final float DefaultMapFillFactor = 0.66f;
    private static final float DefaultMapIdleFactor = 0.15f;
    private static final float DefaultExpandFactor = 2.0f;
    private static final float DefaultShrinkFactor = 2.0f;
    private static final boolean DefaultAutoShrink = false;
    private final Section[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    public ConcurrentLongLongHashMap() {
        this(256);
    }

    @Deprecated
    public ConcurrentLongLongHashMap(int expectedItems) {
        this(expectedItems, 16);
    }

    @Deprecated
    public ConcurrentLongLongHashMap(int expectedItems, int concurrencyLevel) {
        this(expectedItems, concurrencyLevel, 0.66f, 0.15f, false, 2.0f, 2.0f);
    }

    public ConcurrentLongLongHashMap(int expectedItems, int concurrencyLevel, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
        Preconditions.checkArgument((expectedItems > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((concurrencyLevel > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((expectedItems >= concurrencyLevel ? 1 : 0) != 0);
        Preconditions.checkArgument((mapFillFactor > 0.0f && mapFillFactor < 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((mapIdleFactor > 0.0f && mapIdleFactor < 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((mapFillFactor > mapIdleFactor ? 1 : 0) != 0);
        Preconditions.checkArgument((expandFactor > 1.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((shrinkFactor > 1.0f ? 1 : 0) != 0);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / mapFillFactor);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity, mapFillFactor, mapIdleFactor, autoShrink, expandFactor, shrinkFactor);
        }
    }

    public long size() {
        long size = 0L;
        for (Section s : this.sections) {
            size += (long)s.size;
        }
        return size;
    }

    public long sizeInBytes() {
        long size = 0L;
        for (Section s : this.sections) {
            size += (long)s.table.length * 8L;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section s : this.sections) {
            capacity += (long)s.capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section s : this.sections) {
            if (s.size == 0) continue;
            return false;
        }
        return true;
    }

    long getUsedBucketCount() {
        long usedBucketCount = 0L;
        for (Section s : this.sections) {
            usedBucketCount += (long)s.usedBuckets;
        }
        return usedBucketCount;
    }

    public long get(long key) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).get(key, (int)h);
    }

    public boolean containsKey(long key) {
        return this.get(key) != -1L;
    }

    public long put(long key, long value) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        ConcurrentLongLongHashMap.checkBiggerEqualZero(value);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, false, null);
    }

    public long putIfAbsent(long key, long value) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        ConcurrentLongLongHashMap.checkBiggerEqualZero(value);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, true, null);
    }

    public long computeIfAbsent(long key, LongLongFunction provider) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        Preconditions.checkNotNull((Object)provider);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).put(key, -1L, (int)h, true, provider);
    }

    public long addAndGet(long key, long delta) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).addAndGet(key, delta, (int)h);
    }

    public boolean compareAndSet(long key, long currentValue, long newValue) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        ConcurrentLongLongHashMap.checkBiggerEqualZero(newValue);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).compareAndSet(key, currentValue, newValue, (int)h);
    }

    public long remove(long key) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).remove(key, -1L, (int)h);
    }

    public boolean remove(long key, long value) {
        ConcurrentLongLongHashMap.checkBiggerEqualZero(key);
        ConcurrentLongLongHashMap.checkBiggerEqualZero(value);
        long h = ConcurrentLongLongHashMap.hash(key);
        return this.getSection(h).remove(key, value, (int)h) != -1L;
    }

    public int removeIf(LongPredicate filter) {
        Preconditions.checkNotNull((Object)filter);
        int removedCount = 0;
        for (Section s : this.sections) {
            removedCount += s.removeIf(filter);
        }
        return removedCount;
    }

    public int removeIf(LongLongPredicate filter) {
        Preconditions.checkNotNull((Object)filter);
        int removedCount = 0;
        for (Section s : this.sections) {
            removedCount += s.removeIf(filter);
        }
        return removedCount;
    }

    private Section getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section s : this.sections) {
            s.clear();
        }
    }

    public void forEach(BiConsumerLong processor) {
        for (Section s : this.sections) {
            s.forEach(processor);
        }
    }

    public List<Long> keys() {
        ArrayList keys = Lists.newArrayList();
        this.forEach((key, value) -> keys.add(key));
        return keys;
    }

    public List<Long> values() {
        ArrayList values = Lists.newArrayList();
        this.forEach((key, value) -> values.add(value));
        return values;
    }

    public Map<Long, Long> asMap() {
        HashMap map = Maps.newHashMap();
        this.forEach((key, value) -> map.put(key, value));
        return map;
    }

    static final long hash(long key) {
        long hash = key * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int max) {
        return (int)(n & (long)(max - 1)) << 1;
    }

    private static int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static void checkBiggerEqualZero(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Keys and values must be >= 0");
        }
    }

    private static final class Section
    extends StampedLock {
        private volatile long[] table;
        private volatile int capacity;
        private final int initCapacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThresholdUp;
        private int resizeThresholdBelow;
        private final float mapFillFactor;
        private final float mapIdleFactor;
        private final float expandFactor;
        private final float shrinkFactor;
        private final boolean autoShrink;

        Section(int capacity, float mapFillFactor, float mapIdleFactor, boolean autoShrink, float expandFactor, float shrinkFactor) {
            this.initCapacity = this.capacity = ConcurrentLongLongHashMap.alignToPowerOfTwo(capacity);
            this.table = new long[2 * this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.autoShrink = autoShrink;
            this.mapFillFactor = mapFillFactor;
            this.mapIdleFactor = mapIdleFactor;
            this.expandFactor = expandFactor;
            this.shrinkFactor = shrinkFactor;
            this.resizeThresholdUp = (int)((float)this.capacity * mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * mapIdleFactor);
            Arrays.fill(this.table, -1L);
        }

        long get(long key, int keyHash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            int bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    long storedKey = this.table[bucket];
                    long storedValue = this.table[bucket + 1];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (key == storedKey) {
                            long l = storedValue;
                            return l;
                        }
                        if (storedKey == -1L) {
                            long l = -1L;
                            return l;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
                            storedKey = this.table[bucket];
                            storedValue = this.table[bucket + 1];
                        }
                        if (key == storedKey) {
                            long l = storedValue;
                            return l;
                        }
                        if (storedKey == -1L) {
                            long l = -1L;
                            return l;
                        }
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long put(long key, long value, int keyHash, boolean onlyIfAbsent, LongLongFunction valueProvider) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    long storedKey = this.table[bucket];
                    long storedValue = this.table[bucket + 1];
                    if (key == storedKey) {
                        if (!onlyIfAbsent) {
                            this.table[bucket + 1] = value;
                            long l = storedValue;
                            return l;
                        }
                        long l = storedValue;
                        return l;
                    }
                    if (storedKey == -1L) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        if (value == -1L) {
                            value = valueProvider.apply(key);
                        }
                        this.table[bucket] = key;
                        this.table[bucket + 1] = value;
                        ++this.size;
                        long l = valueProvider != null ? value : -1L;
                        return l;
                    }
                    if (storedKey == -2L && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongLongHashMap.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long addAndGet(long key, long delta, int keyHash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    long storedKey = this.table[bucket];
                    long storedValue = this.table[bucket + 1];
                    if (key == storedKey) {
                        long newValue = storedValue + delta;
                        ConcurrentLongLongHashMap.checkBiggerEqualZero(newValue);
                        this.table[bucket + 1] = newValue;
                        long l = newValue;
                        return l;
                    }
                    if (storedKey == -1L) {
                        ConcurrentLongLongHashMap.checkBiggerEqualZero(delta);
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        this.table[bucket] = key;
                        this.table[bucket + 1] = delta;
                        ++this.size;
                        long l = delta;
                        return l;
                    }
                    if (storedKey == -2L && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongLongHashMap.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean compareAndSet(long key, long currentValue, long newValue, int keyHash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    long storedKey = this.table[bucket];
                    long storedValue = this.table[bucket + 1];
                    if (key == storedKey) {
                        if (storedValue != currentValue) {
                            boolean bl = false;
                            return bl;
                        }
                        this.table[bucket + 1] = newValue;
                        boolean bl = true;
                        return bl;
                    }
                    if (storedKey == -1L) {
                        if (currentValue == -1L) {
                            if (firstDeletedKey != -1) {
                                bucket = firstDeletedKey;
                            } else {
                                ++this.usedBuckets;
                            }
                            this.table[bucket] = key;
                            this.table[bucket + 1] = newValue;
                            ++this.size;
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    if (storedKey == -2L && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThresholdUp) {
                    try {
                        int newCapacity = ConcurrentLongLongHashMap.alignToPowerOfTwo((int)((float)this.capacity * this.expandFactor));
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private long remove(long key, long value, int keyHash) {
            stamp = this.writeLock();
            bucket = ConcurrentLongLongHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    storedKey = this.table[bucket];
                    storedValue = this.table[bucket + 1];
                    if (key == storedKey) {
                        if (value == -1L || value == storedValue) {
                            --this.size;
                            this.cleanBucket(bucket);
                            var13_8 = storedValue;
                            return var13_8;
                        }
                        var13_9 = -1L;
                        return var13_9;
                    }
                    if (storedKey == -1L) {
                        var13_10 = -1L;
                        return var13_10;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongLongHashMap.access$500((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl32
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl32:
                // 3 sources

            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        int removeIf(LongPredicate filter) {
            stamp = this.writeLock();
            removedCount = 0;
            try {
                for (bucket = 0; bucket < this.table.length; bucket += 2) {
                    storedKey = this.table[bucket];
                    if (storedKey == -2L || storedKey == -1L || !filter.test(storedKey)) continue;
                    --this.size;
                    ++removedCount;
                    this.cleanBucket(bucket);
                }
                var5_4 = removedCount;
                return var5_4;
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongLongHashMap.access$500((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl25
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl25:
                // 3 sources

            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        int removeIf(LongLongPredicate filter) {
            stamp = this.writeLock();
            removedCount = 0;
            try {
                for (bucket = 0; bucket < this.table.length; bucket += 2) {
                    storedKey = this.table[bucket];
                    storedValue = this.table[bucket + 1];
                    if (storedKey == -2L || storedKey == -1L || !filter.test(storedKey, storedValue)) continue;
                    --this.size;
                    ++removedCount;
                    this.cleanBucket(bucket);
                }
                var5_4 = removedCount;
                return var5_4;
            }
            finally {
                if (this.autoShrink && this.size < this.resizeThresholdBelow) {
                    try {
                        newCapacity = Math.max(ConcurrentLongLongHashMap.access$500((int)((float)this.capacity / this.shrinkFactor)), this.initCapacity);
                        newResizeThresholdUp = (int)((float)newCapacity * this.mapFillFactor);
                        if (newCapacity >= this.capacity || newResizeThresholdUp <= this.size) ** GOTO lbl26
                        this.rehash(newCapacity);
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
lbl26:
                // 3 sources

            }
        }

        private void cleanBucket(int bucket) {
            int nextInArray = bucket + 2 & this.table.length - 1;
            if (this.table[nextInArray] == -1L) {
                this.table[bucket] = -1L;
                this.table[bucket + 1] = -1L;
                --this.usedBuckets;
                bucket = bucket - 2 & this.table.length - 1;
                while (this.table[bucket] == -2L) {
                    this.table[bucket] = -1L;
                    this.table[bucket + 1] = -1L;
                    --this.usedBuckets;
                    bucket = bucket - 2 & this.table.length - 1;
                }
            } else {
                this.table[bucket] = -2L;
                this.table[bucket + 1] = -1L;
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                if (this.autoShrink && this.capacity > this.initCapacity) {
                    this.shrinkToInitCapacity();
                } else {
                    Arrays.fill(this.table, -1L);
                    this.size = 0;
                    this.usedBuckets = 0;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(BiConsumerLong processor) {
            long stamp = this.tryOptimisticRead();
            long[] table = this.table;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    table = this.table;
                }
                for (int bucket = 0; bucket < table.length; bucket += 2) {
                    long storedKey = table[bucket];
                    long storedValue = table[bucket + 1];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedKey = table[bucket];
                        storedValue = table[bucket + 1];
                    }
                    if (storedKey == -2L || storedKey == -1L) continue;
                    processor.accept(storedKey, storedValue);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash(int newCapacity) {
            long[] newTable = new long[2 * newCapacity];
            Arrays.fill(newTable, -1L);
            for (int i = 0; i < this.table.length; i += 2) {
                long storedKey = this.table[i];
                long storedValue = this.table[i + 1];
                if (storedKey == -1L || storedKey == -2L) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedKey, storedValue);
            }
            this.table = newTable;
            this.usedBuckets = this.size;
            this.capacity = newCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private void shrinkToInitCapacity() {
            long[] newTable = new long[2 * this.initCapacity];
            Arrays.fill(newTable, -1L);
            this.table = newTable;
            this.size = 0;
            this.usedBuckets = 0;
            this.capacity = this.initCapacity;
            this.resizeThresholdUp = (int)((float)this.capacity * this.mapFillFactor);
            this.resizeThresholdBelow = (int)((float)this.capacity * this.mapIdleFactor);
        }

        private static void insertKeyValueNoLock(long[] table, int capacity, long key, long value) {
            int bucket = ConcurrentLongLongHashMap.signSafeMod(ConcurrentLongLongHashMap.hash(key), capacity);
            while (true) {
                long storedKey;
                if ((storedKey = table[bucket]) == -1L) {
                    table[bucket] = key;
                    table[bucket + 1] = value;
                    return;
                }
                bucket = bucket + 2 & table.length - 1;
            }
        }
    }

    public static interface LongLongPredicate {
        public boolean test(long var1, long var3);
    }

    public static interface LongLongFunction {
        public long apply(long var1);
    }

    public static interface BiConsumerLong {
        public void accept(long var1, long var3);
    }

    public static class Builder {
        int expectedItems = 256;
        int concurrencyLevel = 16;
        float mapFillFactor = 0.66f;
        float mapIdleFactor = 0.15f;
        float expandFactor = 2.0f;
        float shrinkFactor = 2.0f;
        boolean autoShrink = false;

        public Builder expectedItems(int expectedItems) {
            this.expectedItems = expectedItems;
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder mapFillFactor(float mapFillFactor) {
            this.mapFillFactor = mapFillFactor;
            return this;
        }

        public Builder mapIdleFactor(float mapIdleFactor) {
            this.mapIdleFactor = mapIdleFactor;
            return this;
        }

        public Builder expandFactor(float expandFactor) {
            this.expandFactor = expandFactor;
            return this;
        }

        public Builder shrinkFactor(float shrinkFactor) {
            this.shrinkFactor = shrinkFactor;
            return this;
        }

        public Builder autoShrink(boolean autoShrink) {
            this.autoShrink = autoShrink;
            return this;
        }

        public ConcurrentLongLongHashMap build() {
            return new ConcurrentLongLongHashMap(this.expectedItems, this.concurrencyLevel, this.mapFillFactor, this.mapIdleFactor, this.autoShrink, this.expandFactor, this.shrinkFactor);
        }
    }
}

