/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.stats;

import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;

@StatsDoc(name="journal", category="server", help="Journal related stats")
public class JournalStats {
    @StatsDoc(name="JOURNAL_ADD_ENTRY", help="operation stats of recording addEntry requests in the journal", parent="ADD_ENTRY")
    private final OpStatsLogger journalAddEntryStats;
    @StatsDoc(name="JOURNAL_FORCE_LEDGER", help="operation stats of recording forceLedger requests in the journal", parent="FORCE_LEDGER")
    private final OpStatsLogger journalForceLedgerStats;
    @StatsDoc(name="JOURNAL_SYNC", help="operation stats of syncing data to journal disks", parent="JOURNAL_ADD_ENTRY", happensAfter="JOURNAL_FORCE_WRITE_ENQUEUE")
    private final OpStatsLogger journalSyncStats;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_ENQUEUE", help="operation stats of enqueueing force write requests to force write queue", parent="JOURNAL_ADD_ENTRY", happensAfter="JOURNAL_PROCESS_TIME_LATENCY")
    private final OpStatsLogger fwEnqueueTimeStats;
    @StatsDoc(name="JOURNAL_CREATION_LATENCY", help="operation stats of creating journal files", parent="JOURNAL_PROCESS_TIME_LATENCY")
    private final OpStatsLogger journalCreationStats;
    @StatsDoc(name="JOURNAL_FLUSH_LATENCY", help="operation stats of flushing data from memory to filesystem (but not yet fsyncing to disks)", parent="JOURNAL_PROCESS_TIME_LATENCY", happensAfter="JOURNAL_CREATION_LATENCY")
    private final OpStatsLogger journalFlushStats;
    @StatsDoc(name="JOURNAL_PROCESS_TIME_LATENCY", help="operation stats of processing requests in a journal (from dequeue an item to finish processing it)", parent="JOURNAL_ADD_ENTRY", happensAfter="JOURNAL_QUEUE_LATENCY")
    private final OpStatsLogger journalProcessTimeStats;
    @StatsDoc(name="JOURNAL_QUEUE_LATENCY", help="operation stats of enqueuing requests to a journal", parent="JOURNAL_ADD_ENTRY")
    private final OpStatsLogger journalQueueStats;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_GROUPING_COUNT", help="The distribution of number of force write requests grouped in a force write")
    private final OpStatsLogger forceWriteGroupingCountStats;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_BATCH_ENTRIES", help="The distribution of number of entries grouped together into a force write request")
    private final OpStatsLogger forceWriteBatchEntriesStats;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_BATCH_BYTES", help="The distribution of number of bytes grouped together into a force write request")
    private final OpStatsLogger forceWriteBatchBytesStats;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_GROUPING_FAILURES", help="The number of force write grouping failures")
    private final Counter forceWriteGroupingFailures;
    @StatsDoc(name="JOURNAL_QUEUE_SIZE", help="The journal queue size")
    private final Counter journalQueueSize;
    @StatsDoc(name="JOURNAL_FORCE_WRITE_QUEUE_SIZE", help="The force write queue size")
    private final Counter forceWriteQueueSize;
    @StatsDoc(name="JOURNAL_CB_QUEUE_SIZE", help="The journal callback queue size")
    private final Counter journalCbQueueSize;
    @StatsDoc(name="JOURNAL_NUM_FLUSH_MAX_WAIT", help="The number of journal flushes triggered by MAX_WAIT time")
    private final Counter flushMaxWaitCounter;
    @StatsDoc(name="JOURNAL_NUM_FLUSH_MAX_OUTSTANDING_BYTES", help="The number of journal flushes triggered by MAX_OUTSTANDING_BYTES")
    private final Counter flushMaxOutstandingBytesCounter;
    @StatsDoc(name="JOURNAL_NUM_FLUSH_EMPTY_QUEUE", help="The number of journal flushes triggered when journal queue becomes empty")
    private final Counter flushEmptyQueueCounter;
    @StatsDoc(name="JOURNAL_WRITE_BYTES", help="The number of bytes appended to the journal")
    private final Counter journalWriteBytes;
    @StatsDoc(name="JOURNAL_MEMORY_MAX", help="The max amount of memory in bytes that can be used by the bookie journal")
    private final Gauge<Long> journalMemoryMaxStats;
    @StatsDoc(name="JOURNAL_MEMORY_USED", help="The actual amount of memory in bytes currently used by the bookie journal")
    private final Gauge<Long> journalMemoryUsedStats;

    public JournalStats(StatsLogger statsLogger, final long maxJournalMemoryBytes, final Supplier<Long> currentJournalMemoryBytes) {
        this.journalAddEntryStats = statsLogger.getOpStatsLogger("JOURNAL_ADD_ENTRY");
        this.journalForceLedgerStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_LEDGER");
        this.journalSyncStats = statsLogger.getOpStatsLogger("JOURNAL_SYNC");
        this.fwEnqueueTimeStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_ENQUEUE");
        this.journalCreationStats = statsLogger.getOpStatsLogger("JOURNAL_CREATION_LATENCY");
        this.journalFlushStats = statsLogger.getOpStatsLogger("JOURNAL_FLUSH_LATENCY");
        this.journalQueueStats = statsLogger.getOpStatsLogger("JOURNAL_QUEUE_LATENCY");
        this.journalProcessTimeStats = statsLogger.getOpStatsLogger("JOURNAL_PROCESS_TIME_LATENCY");
        this.forceWriteGroupingCountStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_GROUPING_COUNT");
        this.forceWriteGroupingFailures = statsLogger.getCounter("JOURNAL_FORCE_WRITE_GROUPING_FAILURES");
        this.forceWriteBatchEntriesStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_BATCH_ENTRIES");
        this.forceWriteBatchBytesStats = statsLogger.getOpStatsLogger("JOURNAL_FORCE_WRITE_BATCH_BYTES");
        this.journalQueueSize = statsLogger.getCounter("JOURNAL_QUEUE_SIZE");
        this.forceWriteQueueSize = statsLogger.getCounter("JOURNAL_FORCE_WRITE_QUEUE_SIZE");
        this.journalCbQueueSize = statsLogger.getCounter("JOURNAL_CB_QUEUE_SIZE");
        this.flushMaxWaitCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_MAX_WAIT");
        this.flushMaxOutstandingBytesCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_MAX_OUTSTANDING_BYTES");
        this.flushEmptyQueueCounter = statsLogger.getCounter("JOURNAL_NUM_FLUSH_EMPTY_QUEUE");
        this.journalWriteBytes = statsLogger.getCounter("JOURNAL_WRITE_BYTES");
        this.journalMemoryMaxStats = new Gauge<Long>(){

            public Long getDefaultValue() {
                return maxJournalMemoryBytes;
            }

            public Long getSample() {
                return maxJournalMemoryBytes;
            }
        };
        statsLogger.registerGauge("JOURNAL_MEMORY_MAX", this.journalMemoryMaxStats);
        this.journalMemoryUsedStats = new Gauge<Long>(){

            public Long getDefaultValue() {
                return -1L;
            }

            public Long getSample() {
                return (Long)currentJournalMemoryBytes.get();
            }
        };
        statsLogger.registerGauge("JOURNAL_MEMORY_USED", this.journalMemoryUsedStats);
    }

    public OpStatsLogger getJournalAddEntryStats() {
        return this.journalAddEntryStats;
    }

    public OpStatsLogger getJournalForceLedgerStats() {
        return this.journalForceLedgerStats;
    }

    public OpStatsLogger getJournalSyncStats() {
        return this.journalSyncStats;
    }

    public OpStatsLogger getFwEnqueueTimeStats() {
        return this.fwEnqueueTimeStats;
    }

    public OpStatsLogger getJournalCreationStats() {
        return this.journalCreationStats;
    }

    public OpStatsLogger getJournalFlushStats() {
        return this.journalFlushStats;
    }

    public OpStatsLogger getJournalProcessTimeStats() {
        return this.journalProcessTimeStats;
    }

    public OpStatsLogger getJournalQueueStats() {
        return this.journalQueueStats;
    }

    public OpStatsLogger getForceWriteGroupingCountStats() {
        return this.forceWriteGroupingCountStats;
    }

    public OpStatsLogger getForceWriteBatchEntriesStats() {
        return this.forceWriteBatchEntriesStats;
    }

    public OpStatsLogger getForceWriteBatchBytesStats() {
        return this.forceWriteBatchBytesStats;
    }

    public Counter getForceWriteGroupingFailures() {
        return this.forceWriteGroupingFailures;
    }

    public Counter getJournalQueueSize() {
        return this.journalQueueSize;
    }

    public Counter getForceWriteQueueSize() {
        return this.forceWriteQueueSize;
    }

    public Counter getJournalCbQueueSize() {
        return this.journalCbQueueSize;
    }

    public Counter getFlushMaxWaitCounter() {
        return this.flushMaxWaitCounter;
    }

    public Counter getFlushMaxOutstandingBytesCounter() {
        return this.flushMaxOutstandingBytesCounter;
    }

    public Counter getFlushEmptyQueueCounter() {
        return this.flushEmptyQueueCounter;
    }

    public Counter getJournalWriteBytes() {
        return this.journalWriteBytes;
    }

    public Gauge<Long> getJournalMemoryMaxStats() {
        return this.journalMemoryMaxStats;
    }

    public Gauge<Long> getJournalMemoryUsedStats() {
        return this.journalMemoryUsedStats;
    }
}

