/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor.source;

import org.inferred.freebuilder.processor.source.Excerpt;
import org.inferred.freebuilder.processor.source.IdKey;
import org.inferred.freebuilder.processor.source.Scope;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.ValueType;

public class Variable
extends ValueType
implements Excerpt,
Scope.Key<IdKey> {
    private final String preferredName;

    public Variable(String preferredName) {
        this.preferredName = preferredName;
    }

    @Override
    public Scope.Level level() {
        return Scope.Level.METHOD;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void addTo(SourceBuilder code) {
        IdKey name = code.scope().computeIfAbsent(this, () -> new IdKey(this.pickName(code)));
        code.add("%s", name.name());
    }

    @Override
    protected void addFields(ValueType.FieldReceiver fields) {
        fields.add("preferredName", this.preferredName);
    }

    private String pickName(SourceBuilder code) {
        if (this.registerName(code, this.preferredName)) {
            return this.preferredName;
        }
        if (this.registerName(code, "_" + this.preferredName)) {
            return "_" + this.preferredName;
        }
        int suffix = 2;
        while (!this.registerName(code, "_" + this.preferredName + suffix)) {
            ++suffix;
        }
        return "_" + this.preferredName + suffix;
    }

    private boolean registerName(SourceBuilder code, String name) {
        return code.scope().putIfAbsent(new IdKey(name), this) == null;
    }
}

